/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.integral;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.enums.IntegralOrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.integral.IntegralCashPayChannelEnum;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralCouponPayRecordPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralOrdersPOMapper;
import com.wmeimob.fastboot.bizvane.po.IntegralCouponPayRecordPO;
import com.wmeimob.fastboot.bizvane.po.IntegralCouponPayRecordPOExample;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersPO;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersPOExample;
import com.wmeimob.fastboot.bizvane.po.IntegralRefundOrderPO;
import com.wmeimob.fastboot.bizvane.po.IntegralWechatMchPO;
import com.wmeimob.fastboot.bizvane.service.IntegralOrdersService;
import com.wmeimob.fastboot.bizvane.service.IntegralRefundOrderService;
import com.wmeimob.fastboot.bizvane.service.skyworth.IntegralWeChatMchService;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.starter.wechat.service.WechatService;
import com.wmeimob.wechat.util.XmlUtil;
import io.swagger.annotations.Api;
import java.io.InputStream;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import me.hao0.wechat.model.base.WechatMch;
import me.hao0.wechat.model.base.WechatMp;
import me.hao0.wepay.core.Wepay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.DigestUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/notifyCallBack"})
@Api(description="\u521b\u7ef4\u5b9a\u5236\u79ef\u5206\u5546\u57ce\u73b0\u91d1\u652f\u4ed8\u56de\u8c03")
public class NotifyCallBackController {
    private static final Logger log = LoggerFactory.getLogger(NotifyCallBackController.class);
    @Autowired
    private IntegralOrdersService integralOrdersService;
    @Autowired
    private IntegralWeChatMchService integralWeChatMchService;
    @Autowired
    private WechatService wechatService;
    @Autowired
    private IntegralRefundOrderService integralRefundOrderService;
    @Resource
    private IntegralCouponPayRecordPOMapper integralCouponPayRecordPOMapper;
    @Resource
    private IntegralOrdersPOMapper integralOrdersPOMapper;

    @PostMapping(value={"/pay"})
    public String payCallBack(HttpServletRequest request) {
        try {
            Map paymentMap = XmlUtil.readStringXmlOut((InputStream)request.getInputStream());
            log.info("\u652f\u4ed8\u56de\u8c03:{}", (Object)JSONObject.toJSONString((Object)paymentMap));
            String resultCode = (String)paymentMap.get("result_code");
            if ("SUCCESS".equals(resultCode)) {
                String orderNo = (String)paymentMap.get("out_trade_no");
                String appid = (String)paymentMap.get("appid");
                IntegralOrdersPO integralOrdersPO = this.integralOrdersService.findByOrderNo(orderNo);
                if (integralOrdersPO == null) {
                    log.info("\u5fae\u4fe1\u56de\u8c03\u8ba2\u5355:{}\u4e0d\u5b58\u5728", (Object)orderNo);
                    return "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[\u53c2\u6570\u683c\u5f0f\u6821\u9a8c\u5931\u8d25]]></return_msg></xml>";
                }
                Integer merchantId = integralOrdersPO.getMerchantId();
                IntegralWechatMchPO IntegralWechatMchPO2 = this.integralWeChatMchService.findByBrandId(merchantId);
                if (IntegralWechatMchPO2 == null) {
                    log.info("\u5fae\u4fe1\u56de\u8c03\u8ba2\u5355:{}\u4e0d\u5b58\u5728IntegralWechatMchPO\u914d\u7f6e", (Object)orderNo);
                    return "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[\u53c2\u6570\u683c\u5f0f\u6821\u9a8c\u5931\u8d25]]></return_msg></xml>";
                }
                log.info("IntegralWechatMchPO:{}", (Object)IntegralWechatMchPO2);
                WechatMch wechatMch = new WechatMch();
                wechatMch.setMchKey(IntegralWechatMchPO2.getMchKey());
                wechatMch.setMchNo(IntegralWechatMchPO2.getMchNo());
                wechatMch.setP12(IntegralWechatMchPO2.getP12());
                WechatMp wechatMp = new WechatMp();
                wechatMp.setAppid(appid);
                Wepay wepay = this.wechatService.getWepay(wechatMp, wechatMch);
                Boolean aBoolean = wepay.notifies().verifySign(paymentMap);
                if (aBoolean.booleanValue()) {
                    Integer result = this.integralOrdersService.paySuccess(orderNo, IntegralCashPayChannelEnum.WECHAT_PAY);
                    log.info("\u66f4\u65b0\u8ba2\u5355:{}\u652f\u4ed8\u72b6\u6001:{}", (Object)orderNo, (Object)result);
                    return "<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>";
                }
            }
            return "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[\u53c2\u6570\u683c\u5f0f\u6821\u9a8c\u5931\u8d25]]></return_msg></xml>";
        }
        catch (Exception e) {
            log.error("Skyworth\u79ef\u5206\u5546\u57ce\u73b0\u91d1\u652f\u4ed8\u5931\u8d25error:{}", (Throwable)e);
            return "<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>";
        }
    }

    @PostMapping(value={"/payCoupon"})
    public String payCouponCallBack(HttpServletRequest request) {
        try {
            Map paymentMap = XmlUtil.readStringXmlOut((InputStream)request.getInputStream());
            log.info("\u652f\u4ed8\u56de\u8c03:{}", (Object)JSONObject.toJSONString((Object)paymentMap));
            String resultCode = (String)paymentMap.get("result_code");
            if ("SUCCESS".equals(resultCode)) {
                String orderNo = (String)paymentMap.get("out_trade_no");
                String appid = (String)paymentMap.get("appid");
                String transaction_id = (String)paymentMap.get("transaction_id");
                IntegralCouponPayRecordPOExample integralCouponPayRecordPOExample = new IntegralCouponPayRecordPOExample();
                integralCouponPayRecordPOExample.createCriteria().andOrderNoEqualTo(orderNo).andValidEqualTo(Boolean.TRUE);
                List integralCouponPayRecordPOS = this.integralCouponPayRecordPOMapper.selectByExample(integralCouponPayRecordPOExample);
                IntegralCouponPayRecordPO integralCouponPayRecordPO = (IntegralCouponPayRecordPO)integralCouponPayRecordPOS.get(0);
                Integer merchantId = integralCouponPayRecordPO.getMerchantId();
                IntegralWechatMchPO IntegralWechatMchPO2 = this.integralWeChatMchService.findByBrandId(merchantId);
                if (IntegralWechatMchPO2 == null) {
                    log.info("\u5fae\u4fe1\u56de\u8c03\u79ef\u5206\u5238\u8ba2\u5355:{}\u4e0d\u5b58\u5728IntegralWechatMchPO\u914d\u7f6e", (Object)orderNo);
                    return "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[\u53c2\u6570\u683c\u5f0f\u6821\u9a8c\u5931\u8d25]]></return_msg></xml>";
                }
                log.info("IntegralWechatMchPO:{}", (Object)IntegralWechatMchPO2);
                WechatMch wechatMch = new WechatMch();
                wechatMch.setMchKey(IntegralWechatMchPO2.getMchKey());
                wechatMch.setMchNo(IntegralWechatMchPO2.getMchNo());
                wechatMch.setP12(IntegralWechatMchPO2.getP12());
                WechatMp wechatMp = new WechatMp();
                wechatMp.setAppid(appid);
                Wepay wepay = this.wechatService.getWepay(wechatMp, wechatMch);
                Boolean aBoolean = wepay.notifies().verifySign(paymentMap);
                if (aBoolean.booleanValue()) {
                    Integer result = this.integralOrdersService.payCouponSuccess(integralCouponPayRecordPO, transaction_id);
                    log.info("\u66f4\u65b0\u8ba2\u5355:{}\u652f\u4ed8\u72b6\u6001:{}", (Object)orderNo, (Object)result);
                    return "<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>";
                }
            }
            return "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[\u53c2\u6570\u683c\u5f0f\u6821\u9a8c\u5931\u8d25]]></return_msg></xml>";
        }
        catch (Exception e) {
            log.error("Skyworth\u79ef\u5206\u5546\u57ce\u73b0\u91d1\u652f\u4ed8\u5931\u8d25error:{}", (Throwable)e);
            return "<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>";
        }
    }

    @PostMapping(value={"/refund"})
    public String refundCallBack(HttpServletRequest request) {
        try {
            Map paymentMap = XmlUtil.readStringXmlOut((InputStream)request.getInputStream());
            log.info("\u9000\u6b3e\u56de\u8c03:{}", (Object)JSONObject.toJSONString((Object)paymentMap));
            String resultCode = (String)paymentMap.get("return_code");
            String appid = (String)paymentMap.get("appid");
            IntegralWechatMchPO IntegralWechatMchPO2 = this.integralWeChatMchService.findByAppId(appid);
            if (IntegralWechatMchPO2 == null) {
                throw new MallAdminException("appid=" + appid + "\u6ca1\u6709\u914d\u7f6e\u79ef\u5206\u5546\u57ce\u73b0\u91d1\u652f\u4ed8\u4fe1\u606f");
            }
            if ("SUCCESS".equals(resultCode)) {
                String reqInfo = (String)paymentMap.get("req_info");
                String decryptData = NotifyCallBackController.decryptData(reqInfo, IntegralWechatMchPO2.getMchKey());
                Map readStringXmlOut = XmlUtil.readStringXmlOut((String)decryptData);
                log.info("\u9000\u6b3e\u56de\u8c03\u89e3\u5bc6:{}", (Object)readStringXmlOut);
                String refundNo = (String)readStringXmlOut.get("out_refund_no");
                String refundStatus = (String)readStringXmlOut.get("refund_status");
                if ("SUCCESS".equals(refundStatus)) {
                    log.info("\u9000\u6b3e\u6210\u529f!");
                    IntegralRefundOrderPO refundOrderPO = this.integralRefundOrderService.findByRefundNo(refundNo);
                    String orderNo = refundOrderPO.getOrderNo();
                    Integer merchantId = refundOrderPO.getMerchantId();
                    IntegralOrdersPO ordersPO = new IntegralOrdersPO();
                    ordersPO.setOrderStatus(IntegralOrdersStatusEnum.REFUND.getCode());
                    IntegralOrdersPOExample integralOrdersPOExample = new IntegralOrdersPOExample();
                    integralOrdersPOExample.createCriteria().andOrderNoEqualTo(orderNo).andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
                    int i = this.integralOrdersPOMapper.updateByExampleSelective(ordersPO, integralOrdersPOExample);
                    log.info("\u66f4\u65b0\u79ef\u5206\u5546\u57ce\u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u9000\u6b3e");
                    IntegralOrders orders = this.integralOrdersService.refund(orderNo, merchantId, null, null, Boolean.TRUE);
                    return "<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>";
                }
            }
            return "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[\u53c2\u6570\u683c\u5f0f\u6821\u9a8c\u5931\u8d25]]></return_msg></xml>";
        }
        catch (Exception e) {
            log.error("Skyworth\u79ef\u5206\u5546\u57ce\u73b0\u91d1\u9000\u6b3e\u5931\u8d25error:{}", (Throwable)e);
            return "<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>";
        }
    }

    public static String decryptData(String base64Data, String mchKey) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        SecretKeySpec key = new SecretKeySpec(DigestUtils.md5DigestAsHex((byte[])mchKey.getBytes()).toLowerCase().getBytes(), "AES");
        cipher.init(2, key);
        byte[] bytes = cipher.doFinal(Base64.getDecoder().decode(base64Data));
        return new String(bytes);
    }
}

