/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.integral;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.CommonUtil;
import com.wmeimob.fastboot.bizvane.entity.IntegralClassify;
import com.wmeimob.fastboot.bizvane.newmapper.CompanyBrandRelationPOMapper;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPO;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPOExample;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.IntegralClassifyService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.core.annotation.Page;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.core.rest.RestResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/integral/classify"})
@Api(description="\u79ef\u5206\u5546\u57ce\u5206\u7c7bAPI")
public class ClassifyController {
    private static final Logger log = LoggerFactory.getLogger(ClassifyController.class);
    @Autowired
    private IntegralClassifyService integralClassifyService;
    @Autowired
    private CompanyBrandRelationPOMapper companyBrandRelationPOMapper;
    @Autowired
    private BizvaneInterface bizvaneInterface;

    @ApiOperation(value="\u4fdd\u5b58\u4fee\u6539\u5206\u7c7b")
    @RequestMapping(value={"/saveClassify"}, method={RequestMethod.POST})
    public RestResult saveClassify(@RequestBody IntegralClassify integralClassify) {
        if (CommonUtil.hasChinese((String)integralClassify.getClassifyNo())) {
            throw new CustomException("\u5206\u7c7b\u7f16\u53f7\u4e0d\u80fd\u5b58\u5728\u4e2d\u6587\uff01");
        }
        int num = 0;
        if (integralClassify.getId() == null) {
            log.info("\u79ef\u5206\u5546\u57ce\u5206\u7c7b\u65b0\u589e\u3002\u3002\u3002\u3002");
            num = this.integralClassifyService.add(integralClassify);
        } else {
            log.info("\u79ef\u5206\u5546\u57ce\u5206\u7c7b\u4fee\u6539\u3002\u3002\u3002\u3002");
            num = this.integralClassifyService.update(integralClassify);
        }
        if (num == 1) {
            return RestResult.success();
        }
        return RestResult.fail();
    }

    @ApiOperation(value="\u5220\u9664\u5206\u7c7b")
    @ApiImplicitParam(name="id", value="\u4e3b\u952eid", dataType="int", paramType="query", required=true)
    @RequestMapping(value={"/deleteClassify"}, method={RequestMethod.GET})
    public RestResult deleteClassify(@RequestParam(value="id") Integer id) {
        log.info("\u5220\u9664\u5206\u7c7b\u3002\u3002\u3002\u3002");
        int num = this.integralClassifyService.delete(id);
        if (num == 1) {
            return RestResult.success();
        }
        return RestResult.fail();
    }

    @ApiOperation(value="\u5206\u7c7b\u5206\u9875")
    @ApiImplicitParams(value={@ApiImplicitParam(name="merchantId", value="\u54c1\u724cid", dataType="int", paramType="query", required=true), @ApiImplicitParam(name="pageIndex", value="\u5f53\u524d\u9875\u6570", dataType="int", paramType="query", required=true), @ApiImplicitParam(name="pageSize", value="\u4e00\u9875\u5c55\u793a\u6570\u91cf", dataType="int", paramType="query", required=true)})
    @RequestMapping(value={"/getClassifyList"}, method={RequestMethod.GET})
    @Page
    public PageInfo getClassifyList(@RequestParam(value="merchantId") Integer merchantId) {
        log.info("\u67e5\u8be2\u6240\u6709\u5206\u7c7b\u5206\u9875\u3002\u3002\u3002");
        List list = this.integralClassifyService.getList(merchantId);
        return new PageInfo(list);
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5206\u7c7b")
    @ApiImplicitParam(name="merchantId", value="\u54c1\u724cid", dataType="int", paramType="query", required=true)
    @RequestMapping(value={"/getClassifyMap"}, method={RequestMethod.GET})
    public List<Map> getClassifyMap(@RequestParam(value="merchantId") Integer merchantId) {
        log.info("\u67e5\u8be2\u6240\u6709\u5206\u7c7b\u3002\u3002\u3002");
        List list = this.integralClassifyService.getList(merchantId);
        ArrayList<Map> mapList = new ArrayList<Map>();
        if (list != null && list.size() > 0) {
            for (IntegralClassify classify : list) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("key", classify.getId());
                map.put("value", classify.getName());
                mapList.add(map);
            }
        }
        return mapList;
    }

    @GetMapping(value={"/getCompany"})
    public ResponseData getClassifyQRCord(Integer merchantId) {
        CompanyBrandRelationPOExample companyBrandRelationPOExample = new CompanyBrandRelationPOExample();
        companyBrandRelationPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
        List companyBrandRelationPOList = this.companyBrandRelationPOMapper.selectByExample(companyBrandRelationPOExample);
        if (CollectionUtils.isEmpty((Collection)companyBrandRelationPOList)) {
            return ResponseUtil.getFailedMsg((String)"\u8be5\u54c1\u724c\u4e0d\u5b58\u5728\uff01");
        }
        CompanyBrandRelationPO companyBrandRelationPO = (CompanyBrandRelationPO)companyBrandRelationPOList.get(0);
        log.info("ClassifyController_getClassifyQRCord:{}", (Object)JSON.toJSONString((Object)companyBrandRelationPO));
        return ResponseUtil.getSuccessData((Object)companyBrandRelationPO);
    }
}

