/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.wxmsgnotice.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.entity.WXTemplateJumpPages;
import com.wmeimob.fastboot.bizvane.entity.WxMsgData;
import com.wmeimob.fastboot.bizvane.entity.WxMsgResult;
import com.wmeimob.fastboot.bizvane.entity.WxMsgTemplate;
import com.wmeimob.fastboot.bizvane.enums.ShippingModeEnum;
import com.wmeimob.fastboot.bizvane.enums.WXMsgTemplate.WXMsgTemplateStrLengthEnum;
import com.wmeimob.fastboot.bizvane.enums.WXMsgTemplate.WXMsgTemplateTypeEnum;
import com.wmeimob.fastboot.bizvane.newmapper.CourierPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MsgWxNoticeRecordPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MsgWxTemplatePOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrderItemsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrdersPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.WechatMchPOMapper;
import com.wmeimob.fastboot.bizvane.po.CourierPO;
import com.wmeimob.fastboot.bizvane.po.MsgWxNoticeRecordPO;
import com.wmeimob.fastboot.bizvane.po.MsgWxNoticeRecordPOExample;
import com.wmeimob.fastboot.bizvane.po.MsgWxTemplatePO;
import com.wmeimob.fastboot.bizvane.po.MsgWxTemplatePOExample;
import com.wmeimob.fastboot.bizvane.po.OrderItemsPOExample;
import com.wmeimob.fastboot.bizvane.po.OrdersPO;
import com.wmeimob.fastboot.bizvane.po.OrdersPOExample;
import com.wmeimob.fastboot.bizvane.po.WechatMchPO;
import com.wmeimob.fastboot.bizvane.po.WechatMchPOExample;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.wxmsgnotice.WXMsgNoticeService;
import com.wmeimob.fastboot.bizvane.utils.DateUtil;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.utils.response.SysResponseEnum;
import com.wmeimob.fastboot.bizvane.utils.wxsubscribe.WXTemplateDataCreateUtil;
import com.wmeimob.fastboot.bizvane.utils.wxsubscribe.WxSubscribeSendUtil;
import com.wmeimob.fastboot.bizvane.vo.wx_msg_template.WXMsgTemplateActiveAndDeactivateRequestVO;
import com.wmeimob.fastboot.bizvane.vo.wx_msg_template.WXMsgTemplateNoticeVO;
import com.wmeimob.fastboot.bizvane.vo.wx_msg_template.WXMsgTemplateSelectAvailableRequestVO;
import com.wmeimob.fastboot.bizvane.vo.wx_msg_template.WXMsgTemplateSelectAvailableResponseVO;
import com.wmeimob.fastboot.bizvane.vo.wx_msg_template.WXMsgTemplateSelectRequestVO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class WXMsgNoticeServiceImpl
implements WXMsgNoticeService {
    private static final Logger log = LoggerFactory.getLogger(WXMsgNoticeServiceImpl.class);
    @Resource
    private MsgWxNoticeRecordPOMapper msgWxNoticeRecordPOMapper;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private WxSubscribeSendUtil wxSubscribeSendUtil;
    @Resource
    private WechatMchPOMapper wechatMchPOMapper;
    @Resource
    private OrdersPOMapper ordersPOMapper;
    @Resource
    private OrderItemsPOMapper orderItemsPOMapper;
    @Resource
    private MsgWxTemplatePOMapper msgWxTemplatePOMapper;
    @Resource
    private CourierPOMapper courierPOMapper;

    @Transactional
    public ResponseData sendGoodsNotice(WXMsgTemplateNoticeVO vo) {
        String accessToken;
        log.info("WXMsgNoticeServiceImpl#sendGoodsNotice:{}", (Object)JSON.toJSONString((Object)vo));
        String templateId = vo.getTemplateId();
        OrdersPOExample searchOrder = new OrdersPOExample();
        searchOrder.createCriteria().andValidEqualTo(Boolean.TRUE).andIdEqualTo(vo.getOrderId());
        List ordersPOS = this.ordersPOMapper.selectByExample(searchOrder);
        log.info("ordersPOS:{}", (Object)JSON.toJSONString((Object)ordersPOS));
        if (CollectionUtils.isEmpty((Collection)ordersPOS)) {
            return ResponseUtil.getFailedMsg((String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (ordersPOS.size() > 1) {
            return ResponseUtil.getFailedMsg((String)"\u8ba2\u5355\u4fe1\u606f\u8fc7\u591a");
        }
        if (((OrdersPO)ordersPOS.get(0)).getMerchantId() == null || StringUtils.isEmpty((Object)((OrdersPO)ordersPOS.get(0)).getWechatOpenid())) {
            return ResponseUtil.getFailedMsg((String)"\u8ba2\u5355\u7f3a\u5c11\u90e8\u5206\u6570\u636e");
        }
        OrdersPO order = (OrdersPO)ordersPOS.get(0);
        Integer merchantId = order.getMerchantId();
        vo.setUserName(order.getUserName());
        vo.setPhone(order.getMobile());
        vo.setOrderNo(order.getOrderNo());
        String touser = order.getWechatOpenid();
        if (Integer.valueOf(ShippingModeEnum.SELF_MENTION.getCode()).equals(order.getShippingMode())) {
            return ResponseUtil.getFailedMsg((String)"\u81ea\u63d0\u6682\u65f6\u4e0d\u63d0\u9192");
        }
        OrderItemsPOExample searchOrderItem = new OrderItemsPOExample();
        searchOrderItem.createCriteria().andValidEqualTo(Boolean.TRUE).andOrderIdEqualTo(vo.getOrderId());
        List orderItemsPOS = this.orderItemsPOMapper.selectByExample(searchOrderItem);
        log.info("orderItemsPOS:{}", (Object)JSON.toJSONString((Object)orderItemsPOS));
        if (CollectionUtils.isEmpty((Collection)ordersPOS)) {
            return ResponseUtil.getFailedMsg((String)"\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        WechatMchPOExample wechatMchPOExample = new WechatMchPOExample();
        wechatMchPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(merchantId);
        List wechatMchPOS = this.wechatMchPOMapper.selectByExample(wechatMchPOExample);
        log.info("wechatMchPOS:{}", (Object)JSON.toJSONString((Object)wechatMchPOS));
        if (CollectionUtils.isEmpty((Collection)wechatMchPOS)) {
            return ResponseUtil.getFailedMsg((String)"\u5c0f\u7a0b\u5e8fappId\u4e0d\u5b58\u5728");
        }
        if (wechatMchPOS.size() > 1) {
            return ResponseUtil.getFailedMsg((String)"\u5c0f\u7a0b\u5e8fappId\u8fc7\u591a");
        }
        try {
            accessToken = this.bizvaneInterface.obtainToken(((WechatMchPO)wechatMchPOS.get(0)).getAppId());
            log.info("\u83b7\u53d6\u5230\u7684\u5f53\u524dtoken\u4e3a accessToken\uff1a{}", JSON.toJSON((Object)accessToken));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseUtil.getFailedMsg((String)"accessToken\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)accessToken)) {
            return ResponseUtil.getFailedMsg((String)"accessToken\u4e3a\u7a7a");
        }
        WxMsgTemplate wxMsgTemplate = new WxMsgTemplate();
        WxMsgData wxMsgData = new WxMsgData();
        wxMsgData.setCharacter_string2(WXTemplateDataCreateUtil.createKeyValue((String)WXTemplateDataCreateUtil.lengthCheck((String)vo.getOrderNo(), (WXMsgTemplateStrLengthEnum)WXMsgTemplateStrLengthEnum.character_string)));
        String dateString = DateUtil.yyyyMMddHHmm.format(order.getGmtCreate());
        wxMsgData.setDate1(WXTemplateDataCreateUtil.createKeyValue((String)dateString));
        String shippingVendor = order.getShippingVendor();
        String shippingNo = order.getShippingNo();
        if (StringUtils.isEmpty((Object)shippingVendor)) {
            shippingVendor = "\u5176\u4ed6\u516c\u53f8";
        } else {
            CourierPO courierPO = this.courierPOMapper.selectByPrimaryKey(Integer.valueOf(shippingVendor));
            shippingVendor = courierPO.getName();
        }
        if (StringUtils.isEmpty((Object)shippingNo)) {
            shippingNo = "NONumber";
        }
        wxMsgData.setPhrase4(WXTemplateDataCreateUtil.createKeyValue((String)WXTemplateDataCreateUtil.lengthCheck((String)shippingVendor, (WXMsgTemplateStrLengthEnum)WXMsgTemplateStrLengthEnum.phrase)));
        wxMsgData.setCharacter_string3(WXTemplateDataCreateUtil.createKeyValue((String)WXTemplateDataCreateUtil.lengthCheck((String)shippingNo, (WXMsgTemplateStrLengthEnum)WXMsgTemplateStrLengthEnum.character_string)));
        String addressDetail = order.getShippingProvince() + order.getShippingCity() + order.getShippingDistrict() + order.getShippingAddress();
        wxMsgData.setThing8(WXTemplateDataCreateUtil.createKeyValue((String)WXTemplateDataCreateUtil.lengthCheck((String)addressDetail, (WXMsgTemplateStrLengthEnum)WXMsgTemplateStrLengthEnum.thing)));
        log.info("wxMsgData:{}", (Object)wxMsgData);
        String replace = JSON.toJSONString((Object)wxMsgData).replace("\\", "");
        Map dataMap = (Map)JSON.parseObject((String)replace, Map.class);
        wxMsgTemplate.setData(dataMap);
        wxMsgTemplate.setTouser(touser);
        wxMsgTemplate.setPage(WXTemplateJumpPages.sendGoodsPre + order.getId() + WXTemplateJumpPages.sendGoodsLater);
        wxMsgTemplate.setTemplate_id(templateId);
        ResponseEntity responseEntity = this.wxSubscribeSendUtil.wxSubscribeMessageSend(wxMsgTemplate, accessToken);
        log.info("\u8fd4\u56de\u7ed3\u679c\u4e3a responseEntity\uff1a{}", (Object)responseEntity);
        WxMsgResult result = new WxMsgResult();
        if (responseEntity.getBody() != null) {
            log.info("\u8fd4\u56debody\uff1a{}", responseEntity.getBody());
            result = (WxMsgResult)JSON.parseObject((String)responseEntity.getBody().toString(), WxMsgResult.class);
            if (SysResponseEnum.SUCCESS.getCode() == result.getErrcode().intValue()) {
                log.info("\u8fd4\u56de\u6570\u636e\u6210\u529f");
                return ResponseUtil.getSuccessData((Object)"");
            }
            log.info("\u8fd4\u56de\u6570\u636e\u5931\u8d25");
            return ResponseUtil.getFailedMsg((String)result.getErrmsg());
        }
        return ResponseUtil.getFailedMsg((String)"\u8c03\u7528\u5fae\u4fe1\u6d88\u606f\u8ba2\u9605\u63a5\u53e3\u5931\u8d25");
    }

    public ResponseData checkMsgTemplateAvailable() {
        return null;
    }

    public ResponseData selectAvailableWXMsgTemplate(WXMsgTemplateSelectAvailableRequestVO vo) {
        WXMsgTemplateSelectAvailableResponseVO responseVO = new WXMsgTemplateSelectAvailableResponseVO();
        ArrayList responsePos = new ArrayList();
        StringBuilder errorMsg = new StringBuilder();
        MsgWxTemplatePOExample sendGoodsMsgWxTemplatePOExample = new MsgWxTemplatePOExample();
        sendGoodsMsgWxTemplatePOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andTemplateTypeEqualTo(WXMsgTemplateTypeEnum.SENDGOOD_NOTICE.getCode()).andMerchantIdEqualTo(vo.getMerchantId());
        List sendGoodsMsgWxTemplatePOS = this.msgWxTemplatePOMapper.selectByExample(sendGoodsMsgWxTemplatePOExample);
        log.info("sendGoodsMsgWxTemplatePOS:{}", (Object)JSON.toJSONString((Object)sendGoodsMsgWxTemplatePOS));
        this.checkEmpty(sendGoodsMsgWxTemplatePOS, errorMsg, WXMsgTemplateTypeEnum.SENDGOOD_NOTICE, responsePos);
        MsgWxTemplatePOExample addOrderMsgWxTemplatePOExample = new MsgWxTemplatePOExample();
        addOrderMsgWxTemplatePOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andTemplateTypeEqualTo(WXMsgTemplateTypeEnum.ADDORDER_NOTICE.getCode()).andMerchantIdEqualTo(vo.getMerchantId());
        List addOrderMsgWxTemplatePOS = this.msgWxTemplatePOMapper.selectByExample(addOrderMsgWxTemplatePOExample);
        log.info("addOrderMsgWxTemplatePOS:{}", (Object)JSON.toJSONString((Object)addOrderMsgWxTemplatePOS));
        this.checkEmpty(addOrderMsgWxTemplatePOS, errorMsg, WXMsgTemplateTypeEnum.ADDORDER_NOTICE, responsePos);
        responseVO.setPos(responsePos);
        responseVO.setErrorMsg(String.valueOf(errorMsg));
        return ResponseUtil.getSuccessData((Object)responseVO);
    }

    @Transactional
    public ResponseData activeWXMsgTemplate(WXMsgTemplateActiveAndDeactivateRequestVO vo) {
        MsgWxTemplatePO updatePo = new MsgWxTemplatePO();
        BeanUtils.copyProperties((Object)vo, (Object)updatePo);
        log.info("updatePo:{}", (Object)JSON.toJSONString((Object)updatePo));
        int i = this.msgWxTemplatePOMapper.updateByPrimaryKeySelective(updatePo);
        return ResponseUtil.getSuccessData((Object)"");
    }

    @Transactional
    public ResponseData sendGoodsNoticePre(WXMsgTemplateNoticeVO vo) {
        log.info("WXMsgNoticeServiceImpl#sendGoodsNoticePre vo:{}", (Object)vo);
        MsgWxTemplatePOExample msgWxTemplateCheckExample = new MsgWxTemplatePOExample();
        msgWxTemplateCheckExample.createCriteria().andMerchantIdEqualTo(vo.getMerchantId()).andValidEqualTo(Boolean.TRUE).andTemplateTypeEqualTo(vo.getTemplateType().getCode());
        List msgWxTemplatePOS = this.msgWxTemplatePOMapper.selectByExample(msgWxTemplateCheckExample);
        log.info("msgWxTemplatePOS{}", (Object)JSON.toJSONString((Object)msgWxTemplatePOS));
        if (CollectionUtils.isEmpty((Collection)msgWxTemplatePOS)) {
            log.info("\u672a\u914d\u7f6e\u8ba2\u9605\u6d88\u606f\u5230\u6570\u636e\u5e93\u4e2d");
            return ResponseUtil.getFailedMsg((String)"\u672a\u914d\u7f6e\u8ba2\u9605\u6d88\u606f\u5230\u6570\u636e\u5e93\u4e2d");
        }
        if (msgWxTemplatePOS.size() > 1) {
            log.info("\u6570\u636e\u5e93\u4e2d\u8ba2\u9605\u6d88\u606f\u8fc7\u591a");
            return ResponseUtil.getFailedMsg((String)"\u6570\u636e\u5e93\u4e2d\u8ba2\u9605\u6d88\u606f\u8fc7\u591a");
        }
        MsgWxTemplatePO msgWxTemplatePO = (MsgWxTemplatePO)msgWxTemplatePOS.get(0);
        if (StringUtils.isEmpty((Object)msgWxTemplatePO.getTemplateId())) {
            log.info("\u6a21\u677fid\u4e3a\u7a7a");
            return ResponseUtil.getFailedMsg((String)"\u6a21\u677fid\u4e3a\u7a7a");
        }
        if (!msgWxTemplatePO.getActive().booleanValue()) {
            log.info("\u6a21\u677f\u672a\u6fc0\u6d3b");
            return ResponseUtil.getFailedMsg((String)"\u6a21\u677f\u672a\u6fc0\u6d3b");
        }
        vo.setTemplateId(msgWxTemplatePO.getTemplateId());
        ResponseData responseData = this.sendGoodsNotice(vo);
        MsgWxNoticeRecordPO insertPo = new MsgWxNoticeRecordPO();
        insertPo.setErrorMsg(responseData.getMessage());
        insertPo.setSendStatus(String.valueOf(responseData.getCode()));
        insertPo.setMerchantId(vo.getMerchantId());
        insertPo.setSendTime(new Date());
        insertPo.setUserName(vo.getUserName());
        insertPo.setUserPhone(vo.getPhone());
        insertPo.setOrderNo(vo.getOrderNo());
        insertPo.setGmtCreate(new Date());
        insertPo.setTemplateType(vo.getTemplateType().getCode());
        log.info("insertPo:{}", (Object)JSON.toJSONString((Object)insertPo));
        this.msgWxNoticeRecordPOMapper.insertSelective(insertPo);
        return ResponseUtil.getSuccessData((Object)"");
    }

    private void checkEmpty(List<MsgWxTemplatePO> msgWxTemplatePOS, StringBuilder errorMsg, WXMsgTemplateTypeEnum wxMsgTemplateTypeEnum, List<MsgWxTemplatePO> responsePos) {
        if (CollectionUtils.isEmpty(msgWxTemplatePOS)) {
            errorMsg.append(wxMsgTemplateTypeEnum.getDesc()).append("\u6a21\u677f\u672a\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406;");
        } else if (msgWxTemplatePOS.size() > 1) {
            errorMsg.append(wxMsgTemplateTypeEnum.getDesc()).append("\u6a21\u677f\u914d\u7f6e\u67e5\u51fa\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406;");
        } else if (StringUtils.isEmpty((Object)msgWxTemplatePOS.get(0).getTemplateId())) {
            errorMsg.append(wxMsgTemplateTypeEnum.getDesc()).append("\u6a21\u677f\u672a\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406;");
        } else {
            responsePos.add(msgWxTemplatePOS.get(0));
        }
    }

    public ResponseData selectWXMsgTemplateRecord(WXMsgTemplateSelectRequestVO vo) {
        log.info("WXMsgNoticeServiceImpl#selectWXMsgTemplateRecord vo:{}", (Object)JSON.toJSONString((Object)vo));
        MsgWxNoticeRecordPOExample selectRecordExample = new MsgWxNoticeRecordPOExample();
        MsgWxNoticeRecordPOExample.Criteria criteria = selectRecordExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(vo.getMerchantId());
        if (vo.getStartTime() != null && vo.getEndTime() != null) {
            if (vo.getStartTime().equals(vo.getEndTime())) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(vo.getEndTime());
                ((Calendar)calendar).add(5, 1);
                vo.setEndTime(calendar.getTime());
            }
            criteria.andSendTimeBetween(vo.getStartTime(), vo.getEndTime());
        }
        if (!StringUtils.isEmpty((Object)vo.getUserName())) {
            criteria.andUserNameLike("%" + vo.getUserName() + "%");
        }
        if (vo.getTemplateType() != null) {
            criteria.andTemplateTypeEqualTo(vo.getTemplateType());
        }
        if (!StringUtils.isEmpty((Object)vo.getUserPhone())) {
            criteria.andUserPhoneEqualTo(vo.getUserPhone());
        }
        selectRecordExample.setOrderByClause("send_time desc");
        PageHelper.startPage((int)vo.getPageNum(), (int)vo.getPageSize());
        List pageList = this.msgWxNoticeRecordPOMapper.selectByExample(selectRecordExample);
        log.info("pageList:{}", (Object)JSON.toJSONString((Object)pageList));
        PageInfo result = new PageInfo(pageList);
        return ResponseUtil.getSuccessData((Object)result);
    }

    public ResponseData insertWXMsgTemplate(MsgWxTemplatePO vo) {
        int i = this.msgWxTemplatePOMapper.insertSelective(vo);
        return ResponseUtil.getSuccessData((Object)i);
    }
}

