/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.skyworth;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.autoconfigure.wechat.WechatProperties;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralCouponPayRecordPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralWechatMchPOMapper;
import com.wmeimob.fastboot.bizvane.po.IntegralCouponPayRecordPO;
import com.wmeimob.fastboot.bizvane.po.IntegralCouponPayRecordPOExample;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersPO;
import com.wmeimob.fastboot.bizvane.po.IntegralWechatMchPO;
import com.wmeimob.fastboot.bizvane.po.IntegralWechatMchPOExample;
import com.wmeimob.fastboot.bizvane.service.Integralstore.IntegralOrdersNewService;
import com.wmeimob.fastboot.bizvane.service.skyworth.IntegralWeChatMchService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.utils.response.SysResponseEnum;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.IntegralCouponPayVO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.IntegralOrderWrapperVO;
import com.wmeimob.fastboot.bizvane.vo.skyworth.IntegralWeChatMchVO;
import com.wmeimob.fastboot.starter.wechat.dto.WechatJsPayDTO;
import com.wmeimob.fastboot.starter.wechat.service.WechatService;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.web.IpAddressHelper;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLConnection;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import me.hao0.wechat.model.base.WechatMch;
import me.hao0.wechat.model.base.WechatMp;
import me.hao0.wepay.core.Wepay;
import me.hao0.wepay.model.pay.JsPayRequest;
import me.hao0.wepay.model.pay.JsPayResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class IntegralWeChatMchServiceImpl
implements IntegralWeChatMchService {
    private static final Logger log = LoggerFactory.getLogger(IntegralWeChatMchServiceImpl.class);
    @Resource
    private IntegralWechatMchPOMapper integralWechatMchPOMapper;
    @Resource
    private IntegralCouponPayRecordPOMapper integralCouponPayRecordPOMapper;
    @Autowired
    private IntegralOrdersNewService integralOrdersNewService;
    @Resource
    private WechatProperties wechatProperties;
    @Autowired
    private WechatService wechatService;

    public ResponseData addMch(IntegralWeChatMchVO integralWeChatMchVO) {
        ResponseData responseData = new ResponseData();
        Integer id = integralWeChatMchVO.getId();
        if (id != null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u65b0\u589e\u5546\u6237\u914d\u7f6e\u65f6\u4e0d\u80fd\u4f20id\u5b57\u6bb5!");
            return responseData;
        }
        String mchNo = integralWeChatMchVO.getMchNo();
        String mchKey = integralWeChatMchVO.getMchKey();
        String p12FileUrl = integralWeChatMchVO.getP12FileUrl();
        if (StringUtils.isEmpty((Object)mchNo) || StringUtils.isEmpty((Object)mchKey) || StringUtils.isEmpty((Object)p12FileUrl)) {
            responseData.setCode(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode());
            responseData.setMessage(SysResponseEnum.MODEL_FAILED_VALIDATION.getMessage());
            return responseData;
        }
        String fileUrl = integralWeChatMchVO.getP12FileUrl();
        if (!StringUtils.isEmpty((Object)fileUrl)) {
            fileUrl = fileUrl.replace("https", "http");
            try {
                URL url = new URL(fileUrl);
                URLConnection urlConnection = url.openConnection();
                InputStream inputStream = urlConnection.getInputStream();
                byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                integralWeChatMchVO.setP12(bytes);
                integralWeChatMchVO.setP12SetFlag(Boolean.valueOf(bytes != null));
            }
            catch (Exception e) {
                log.error("\u8fdc\u7a0b\u8bfb\u53d6\u6587\u4ef6\u6d41\u8f6c\u6362byte[]\u5931\u8d25:{}", (Throwable)e);
            }
        }
        IntegralWechatMchPO integralWechatMchPO = new IntegralWechatMchPO();
        BeanUtils.copyProperties((Object)integralWeChatMchVO, (Object)integralWechatMchPO);
        int i = this.integralWechatMchPOMapper.insertSelective(integralWechatMchPO);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)i);
        return responseData;
    }

    public ResponseData modifyMch(IntegralWeChatMchVO integralWeChatMchVO) {
        ResponseData responseData = new ResponseData();
        Integer id = integralWeChatMchVO.getId();
        if (id == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u4fee\u6539\u5546\u6237\u914d\u7f6e\u65f6\u5fc5\u987b\u4f20id\u5b57\u6bb5!");
            return responseData;
        }
        String mchNo = integralWeChatMchVO.getMchNo();
        String mchKey = integralWeChatMchVO.getMchKey();
        String p12FileUrl = integralWeChatMchVO.getP12FileUrl();
        if (StringUtils.isEmpty((Object)mchNo) || StringUtils.isEmpty((Object)mchKey)) {
            responseData.setCode(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode());
            responseData.setMessage(SysResponseEnum.MODEL_FAILED_VALIDATION.getMessage());
            return responseData;
        }
        String fileUrl = integralWeChatMchVO.getP12FileUrl();
        if (!StringUtils.isEmpty((Object)fileUrl)) {
            fileUrl = fileUrl.replace("https", "http");
            try {
                URL url = new URL(fileUrl);
                URLConnection urlConnection = url.openConnection();
                InputStream inputStream = urlConnection.getInputStream();
                byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                integralWeChatMchVO.setP12(bytes);
                integralWeChatMchVO.setP12SetFlag(Boolean.valueOf(bytes != null));
            }
            catch (Exception e) {
                log.error("\u8fdc\u7a0b\u8bfb\u53d6\u6587\u4ef6\u6d41\u8f6c\u6362byte[]\u5931\u8d25:{}", (Throwable)e);
            }
        }
        IntegralWechatMchPO integralWechatMchPO = new IntegralWechatMchPO();
        BeanUtils.copyProperties((Object)integralWeChatMchVO, (Object)integralWechatMchPO);
        this.integralWechatMchPOMapper.updateByPrimaryKeySelective(integralWechatMchPO);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public IntegralWechatMchPO findByBrandId(Integer brandId) {
        IntegralWechatMchPOExample weChatMchPOExample = new IntegralWechatMchPOExample();
        weChatMchPOExample.createCriteria().andMerchantIdEqualTo(brandId).andValidEqualTo(Boolean.TRUE);
        List IntegralWechatMchPOS = this.integralWechatMchPOMapper.selectByExampleWithBLOBs(weChatMchPOExample);
        if (CollectionUtils.isEmpty((Collection)IntegralWechatMchPOS)) {
            return null;
        }
        return (IntegralWechatMchPO)IntegralWechatMchPOS.get(0);
    }

    public IntegralWechatMchPO findByAppId(String appId) {
        IntegralWechatMchPOExample weChatMchPOExample = new IntegralWechatMchPOExample();
        weChatMchPOExample.createCriteria().andAppIdEqualTo(appId).andValidEqualTo(Boolean.TRUE);
        List IntegralWechatMchPOS = this.integralWechatMchPOMapper.selectByExample(weChatMchPOExample);
        if (CollectionUtils.isEmpty((Collection)IntegralWechatMchPOS)) {
            return null;
        }
        return (IntegralWechatMchPO)IntegralWechatMchPOS.get(0);
    }

    public ResponseData<JsPayResponse> payment(Integer orderId) {
        IntegralOrderWrapperVO integralOrderWrapperVO = this.integralOrdersNewService.queryOrderWrapper(orderId);
        IntegralOrdersPO integralOrdersPO = integralOrderWrapperVO.getIntegralOrdersPO();
        Integer merchantId = integralOrdersPO.getMerchantId();
        IntegralWechatMchPO IntegralWechatMchPO2 = this.findByBrandId(merchantId);
        BigDecimal totalFee = integralOrderWrapperVO.getTotalFee();
        if (totalFee.compareTo(BigDecimal.ZERO) == 0) {
            ResponseData objectResponseData = new ResponseData();
            objectResponseData.setCode(SysResponseEnum.INTEGRAL_ORDER_NOT_NEED_PAY.getCode());
            objectResponseData.setMessage(SysResponseEnum.INTEGRAL_ORDER_NOT_NEED_PAY.getMessage());
            return objectResponseData;
        }
        WechatJsPayDTO wechatJsPayDTO = WechatJsPayDTO.builder().appid(IntegralWechatMchPO2.getAppId()).isTest(Boolean.valueOf(this.wechatProperties.isTest())).body(this.wechatProperties.getPay().getBody()).notifyUrl((String)this.wechatProperties.getUrls().get("pay-integral-notify")).openid(integralOrdersPO.getOpenId()).orderNo(integralOrdersPO.getOrderNo()).totalFee(totalFee).build();
        log.info("\u83b7\u53d6\u5fae\u4fe1\u652f\u4ed8\u7b7e\u540d====>{}", (Object)JSONObject.toJSONString((Object)wechatJsPayDTO));
        JsPayResponse jsPayResponse = this.prePay(wechatJsPayDTO, merchantId);
        return ResponseUtil.getSuccessData((Object)jsPayResponse);
    }

    private JsPayResponse prePay(WechatJsPayDTO wechatJsPayDTO, Integer merchantId) {
        IntegralWechatMchPO IntegralWechatMchPO2 = this.findByBrandId(merchantId);
        WechatMp wechatMp = new WechatMp();
        wechatMp.setAppid(IntegralWechatMchPO2.getAppId());
        WechatMch wechatMch = new WechatMch();
        wechatMch.setMchKey(IntegralWechatMchPO2.getMchKey());
        wechatMch.setMchNo(IntegralWechatMchPO2.getMchNo());
        wechatMch.setP12(IntegralWechatMchPO2.getP12());
        Wepay wepay = this.wechatService.getWepay(wechatMp, wechatMch);
        JsPayRequest jsPayRequest = new JsPayRequest();
        jsPayRequest.setBody(wechatJsPayDTO.getBody());
        jsPayRequest.setOutTradeNo(wechatJsPayDTO.getOrderNo());
        jsPayRequest.setTotalFee(Integer.valueOf(wechatJsPayDTO.getTotalFee().multiply(new BigDecimal("100")).intValue()));
        jsPayRequest.setOpenId(wechatJsPayDTO.getOpenid());
        jsPayRequest.setClientIp(IpAddressHelper.getRemoteHost((HttpServletRequest)((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest()));
        jsPayRequest.setNotifyUrl(wechatJsPayDTO.getNotifyUrl());
        jsPayRequest.setTimeStart(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        log.info("\u5fae\u4fe1\u652f\u4ed8\u7b7e\u540d\u53c2\u6570===>{}", (Object)JSONObject.toJSONString((Object)jsPayRequest));
        log.info("\u5fae\u4fe1\u652f\u4ed8\u7b7e\u540d\u7684\u5fae\u4fe1\u4f53===>{}", (Object)JSONObject.toJSONString((Object)wepay));
        return wepay.pay().jsPay(jsPayRequest);
    }

    private void checkOrdersShippingInfo(IntegralOrders integralOrders) {
        if (integralOrders.getOrderType().equals(0)) {
            InputValidator.checkEmpty((Object)integralOrders.getShippingName(), (String)"\u6536\u8d27\u4eba\u59d3\u540d");
            InputValidator.checkEmpty((Object)integralOrders.getShippingMobile(), (String)"\u624b\u673a\u53f7\u7801");
            InputValidator.checkEmpty((Object)integralOrders.getShippingProvince(), (String)"\u7701\u4efd");
            InputValidator.checkEmpty((Object)integralOrders.getShippingCity(), (String)"\u57ce\u5e02");
            InputValidator.checkEmpty((Object)integralOrders.getShippingDistrict(), (String)"\u5730\u533a");
            InputValidator.checkEmpty((Object)integralOrders.getShippingAddress(), (String)"\u8be6\u7ec6\u5730\u5740");
        } else {
            InputValidator.checkEmpty((Object)integralOrders.getStoreId(), (String)"\u81ea\u63d0\u95e8\u5e97ID");
            InputValidator.checkEmpty((Object)integralOrders.getStoreName(), (String)"\u81ea\u63d0\u95e8\u5e97\u540d\u79f0");
        }
    }

    public ResponseData paymentWithCoupon(IntegralCouponPayVO integralCouponPayVO) {
        Integer merchantId = integralCouponPayVO.getMerchantId();
        String openId = integralCouponPayVO.getOpenId();
        String convertCouponRecordCode = integralCouponPayVO.getConvertCouponRecordCode();
        Long convertCouponRecordId = integralCouponPayVO.getConvertCouponRecordId();
        BigDecimal price = integralCouponPayVO.getPrice();
        IntegralWechatMchPO IntegralWechatMchPO2 = this.findByBrandId(merchantId);
        IntegralCouponPayRecordPOExample integralCouponPayRecordPOExample = new IntegralCouponPayRecordPOExample();
        integralCouponPayRecordPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andOrderNoEqualTo(convertCouponRecordCode).andValidEqualTo(Boolean.TRUE);
        List integralCouponPayRecordPOS = this.integralCouponPayRecordPOMapper.selectByExample(integralCouponPayRecordPOExample);
        if (CollectionUtils.isEmpty((Collection)integralCouponPayRecordPOS)) {
            IntegralCouponPayRecordPO integralCouponPayRecordPO = new IntegralCouponPayRecordPO();
            integralCouponPayRecordPO.setMerchantId(merchantId);
            integralCouponPayRecordPO.setOrderNo(convertCouponRecordCode);
            integralCouponPayRecordPO.setOrderId(Integer.valueOf(convertCouponRecordId.intValue()));
            int n = this.integralCouponPayRecordPOMapper.insertSelective(integralCouponPayRecordPO);
        }
        log.info("\u652f\u4ed8\u91d1\u989d\u4e3a:{}", (Object)price);
        WechatJsPayDTO wechatJsPayDTO = WechatJsPayDTO.builder().appid(IntegralWechatMchPO2.getAppId()).isTest(Boolean.valueOf(this.wechatProperties.isTest())).body(this.wechatProperties.getPay().getBody()).notifyUrl((String)this.wechatProperties.getUrls().get("payCoupon-integral-notify")).openid(openId).orderNo(convertCouponRecordCode).totalFee(price).build();
        log.info("\u83b7\u53d6\u5fae\u4fe1\u652f\u4ed8\u7b7e\u540d====>{}", (Object)JSONObject.toJSONString((Object)wechatJsPayDTO));
        JsPayResponse jsPayResponse = this.prePay(wechatJsPayDTO, merchantId);
        return ResponseUtil.getSuccessData((Object)jsPayResponse);
    }
}

