/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.skyworth;

import com.alibaba.fastjson.JSON;
import com.bizvane.base.common.bean.ErrorInfo;
import com.bizvane.base.common.bean.PayPackageResult;
import com.bizvane.base.common.bean.ResultBean;
import com.bizvane.base.remote.dto.ChannelConfigDto;
import com.wmeimob.fastboot.autoconfigure.wechat.WechatProperties;
import com.wmeimob.fastboot.bizvane.enums.paygateway.PayGatewayChannelTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.paygateway.PayGatewaySyncStatusEnum;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralCouponPayRecordPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralUnionPayMchPOMapper;
import com.wmeimob.fastboot.bizvane.po.IntegralCouponPayRecordPO;
import com.wmeimob.fastboot.bizvane.po.IntegralCouponPayRecordPOExample;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersPO;
import com.wmeimob.fastboot.bizvane.po.IntegralUnionPayMchPO;
import com.wmeimob.fastboot.bizvane.po.IntegralUnionPayMchPOExample;
import com.wmeimob.fastboot.bizvane.service.Integralstore.IntegralOrdersNewService;
import com.wmeimob.fastboot.bizvane.service.paygateway.PayGatewayChannelService;
import com.wmeimob.fastboot.bizvane.service.paygateway.PayGatewayPayService;
import com.wmeimob.fastboot.bizvane.service.skyworth.IntegralUnionPayService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.utils.response.SysResponseEnum;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.IntegralCouponPayVO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.IntegralOrderWrapperVO;
import com.wmeimob.fastboot.bizvane.vo.paygateway.IntegralPayGatewayOrderVO;
import com.wmeimob.fastboot.bizvane.vo.skyworth.IntegralUnionPayMchVO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import me.hao0.wepay.model.pay.JsPayResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IntegralUnionPayServiceImpl
implements IntegralUnionPayService {
    private static final Logger log = LoggerFactory.getLogger(IntegralUnionPayServiceImpl.class);
    @Resource
    private IntegralUnionPayMchPOMapper integralUnionPayMchPOMapper;
    @Autowired
    private PayGatewayChannelService payGatewayChannelService;
    @Resource
    private WechatProperties wechatProperties;
    @Autowired
    @Lazy
    private IntegralOrdersNewService integralOrdersNewService;
    @Autowired
    private PayGatewayPayService payGatewayPayService;
    @Resource
    private IntegralCouponPayRecordPOMapper integralCouponPayRecordPOMapper;

    public ResponseData<IntegralUnionPayMchPO> addMch(IntegralUnionPayMchVO integralUnionPayMchVO) {
        ResponseData responseData = new ResponseData();
        Integer id = integralUnionPayMchVO.getId();
        if (id != null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u65b0\u589e\u5546\u6237\u94f6\u8054\u914d\u7f6e\u65f6\u4e0d\u80fd\u4f20id\u5b57\u6bb5!");
            return responseData;
        }
        IntegralUnionPayMchPO integralUnionPayMchPO = new IntegralUnionPayMchPO();
        BeanUtils.copyProperties((Object)integralUnionPayMchVO, (Object)integralUnionPayMchPO);
        integralUnionPayMchPO.setGmtCreate(new Date());
        int i = this.integralUnionPayMchPOMapper.insertSelective(integralUnionPayMchPO);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)integralUnionPayMchPO);
        return responseData;
    }

    public ResponseData modifyMch(IntegralUnionPayMchVO integralUnionPayMchVO) {
        ResponseData responseData = new ResponseData();
        Integer id = integralUnionPayMchVO.getId();
        if (id == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u65b0\u589e\u5546\u6237\u94f6\u8054\u914d\u7f6e\u65f6\u5fc5\u987b\u4f20id\u5b57\u6bb5!");
            return responseData;
        }
        IntegralUnionPayMchPO integralUnionPayMchPO = new IntegralUnionPayMchPO();
        BeanUtils.copyProperties((Object)integralUnionPayMchVO, (Object)integralUnionPayMchPO);
        integralUnionPayMchPO.setGmtModified(new Date());
        this.integralUnionPayMchPOMapper.updateByPrimaryKeySelective(integralUnionPayMchPO);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public IntegralUnionPayMchPO findByBrandId(Integer brandId) {
        IntegralUnionPayMchPOExample integralUnionPayMchPOExample = new IntegralUnionPayMchPOExample();
        integralUnionPayMchPOExample.createCriteria().andMerchantIdEqualTo(brandId).andValidEqualTo(Boolean.TRUE);
        List integralUnionPayMchPOS = this.integralUnionPayMchPOMapper.selectByExample(integralUnionPayMchPOExample);
        if (!CollectionUtils.isEmpty((Collection)integralUnionPayMchPOS)) {
            return (IntegralUnionPayMchPO)integralUnionPayMchPOS.get(0);
        }
        return null;
    }

    public ResponseData<JsPayResponse> payment(Integer orderId) {
        IntegralOrderWrapperVO integralOrderWrapperVO = this.integralOrdersNewService.queryOrderWrapper(orderId);
        BigDecimal totalFee = integralOrderWrapperVO.getTotalFee();
        if (totalFee.compareTo(BigDecimal.ZERO) == 0) {
            ResponseData objectResponseData = new ResponseData();
            objectResponseData.setCode(SysResponseEnum.INTEGRAL_ORDER_NOT_NEED_PAY.getCode());
            objectResponseData.setMessage(SysResponseEnum.INTEGRAL_ORDER_NOT_NEED_PAY.getMessage());
            return objectResponseData;
        }
        IntegralOrdersPO integralOrdersPO = integralOrderWrapperVO.getIntegralOrdersPO();
        Integer merchantId = integralOrdersPO.getMerchantId();
        ChannelConfigDto remotePayGatewayChannelUnion = this.payGatewayChannelService.getRemotePayGatewayChannelUnion(merchantId);
        if (remotePayGatewayChannelUnion == null) {
            return ResponseUtil.getFailedMsg((String)"\u83b7\u53d6\u94f6\u8054\u652f\u4ed8\u914d\u7f6e\u5931\u8d25,\u65e0\u6cd5\u652f\u4ed8");
        }
        String bizvaneMid = remotePayGatewayChannelUnion.getBizvaneMid();
        String orderNo = integralOrdersPO.getOrderNo();
        String openId = integralOrdersPO.getOpenId();
        IntegralPayGatewayOrderVO integralPayGatewayOrderVo = new IntegralPayGatewayOrderVO();
        integralPayGatewayOrderVo.setBizvaneMid(bizvaneMid);
        integralPayGatewayOrderVo.setOutTradeNo(orderNo);
        integralPayGatewayOrderVo.setBody(this.wechatProperties.getPay().getBody());
        integralPayGatewayOrderVo.setBuyerUserId(openId);
        integralPayGatewayOrderVo.setTotalFee(Integer.valueOf(totalFee.intValue()));
        integralPayGatewayOrderVo.setPayType(PayGatewayChannelTypeEnum.UNION_TYPE.getType());
        String cryptData = this.payGatewayPayService.cryptData(bizvaneMid, PayGatewayChannelTypeEnum.UNION_TYPE.getType());
        integralPayGatewayOrderVo.setCryptData(cryptData);
        ResultBean payPackageResultResultBean = this.payGatewayPayService.prePay(integralPayGatewayOrderVo);
        Boolean success = payPackageResultResultBean.getSuccess();
        if (!success.booleanValue()) {
            ErrorInfo errorInfo = payPackageResultResultBean.getErrorInfo();
            return ResponseUtil.getFailedMsg((String)JSON.toJSONString((Object)errorInfo));
        }
        PayPackageResult result = (PayPackageResult)payPackageResultResultBean.getResult();
        String bizvaneTradeNo = result.getBizvaneTradeNo();
        this.integralOrdersNewService.modifyOrderBizvaneTradeNo(orderId, bizvaneTradeNo);
        String appId = result.getAppid();
        String nonceStr = result.getNonceStr();
        String sign = result.getSign();
        String prepayId = result.getPrepayId();
        String signType = "MD5";
        String timeStamp = result.getTimeStamp();
        JsPayResponse jsPayResponse = new JsPayResponse(appId, timeStamp, nonceStr, prepayId, signType, sign);
        return ResponseUtil.getSuccessData((Object)jsPayResponse);
    }

    public ResponseData paymentWithCoupon(IntegralCouponPayVO integralCouponPayVO) {
        ChannelConfigDto remotePayGatewayChannelUnion;
        Integer merchantId = integralCouponPayVO.getMerchantId();
        String openId = integralCouponPayVO.getOpenId();
        String convertCouponRecordCode = integralCouponPayVO.getConvertCouponRecordCode();
        Long convertCouponRecordId = integralCouponPayVO.getConvertCouponRecordId();
        BigDecimal price = integralCouponPayVO.getPrice();
        IntegralCouponPayRecordPOExample integralCouponPayRecordPOExample = new IntegralCouponPayRecordPOExample();
        integralCouponPayRecordPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andOrderNoEqualTo(convertCouponRecordCode).andValidEqualTo(Boolean.TRUE);
        List integralCouponPayRecordPOS = this.integralCouponPayRecordPOMapper.selectByExample(integralCouponPayRecordPOExample);
        if (CollectionUtils.isEmpty((Collection)integralCouponPayRecordPOS)) {
            IntegralCouponPayRecordPO integralCouponPayRecordPO = new IntegralCouponPayRecordPO();
            integralCouponPayRecordPO.setMerchantId(merchantId);
            integralCouponPayRecordPO.setOrderNo(convertCouponRecordCode);
            integralCouponPayRecordPO.setOrderId(Integer.valueOf(convertCouponRecordId.intValue()));
            int n = this.integralCouponPayRecordPOMapper.insertSelective(integralCouponPayRecordPO);
        }
        if ((remotePayGatewayChannelUnion = this.payGatewayChannelService.getRemotePayGatewayChannelUnion(merchantId)) == null) {
            return ResponseUtil.getFailedMsg((String)"\u83b7\u53d6\u94f6\u8054\u652f\u4ed8\u914d\u7f6e\u5931\u8d25,\u65e0\u6cd5\u652f\u4ed8");
        }
        String bizvaneMid = remotePayGatewayChannelUnion.getBizvaneMid();
        IntegralPayGatewayOrderVO integralPayGatewayOrderVo = new IntegralPayGatewayOrderVO();
        integralPayGatewayOrderVo.setBizvaneMid(bizvaneMid);
        integralPayGatewayOrderVo.setOutTradeNo(convertCouponRecordCode);
        integralPayGatewayOrderVo.setBody(this.wechatProperties.getPay().getBody());
        integralPayGatewayOrderVo.setBuyerUserId(openId);
        integralPayGatewayOrderVo.setTotalFee(Integer.valueOf(price.intValue()));
        integralPayGatewayOrderVo.setPayType(PayGatewayChannelTypeEnum.UNION_TYPE.getType());
        String cryptData = this.payGatewayPayService.cryptData(bizvaneMid, PayGatewayChannelTypeEnum.UNION_TYPE.getType());
        integralPayGatewayOrderVo.setCryptData(cryptData);
        ResultBean payPackageResultResultBean = this.payGatewayPayService.prePay(integralPayGatewayOrderVo);
        Boolean success = payPackageResultResultBean.getSuccess();
        if (!success.booleanValue()) {
            ErrorInfo errorInfo = payPackageResultResultBean.getErrorInfo();
            return ResponseUtil.getFailedMsg((String)JSON.toJSONString((Object)errorInfo));
        }
        PayPackageResult result = (PayPackageResult)payPackageResultResultBean.getResult();
        String bizvaneTradeNo = result.getBizvaneTradeNo();
        IntegralCouponPayRecordPO integralCouponPayRecordPO = new IntegralCouponPayRecordPO();
        integralCouponPayRecordPO.setBizvaneTradeNo(bizvaneTradeNo);
        integralCouponPayRecordPO.setGmtModified(new Date());
        IntegralCouponPayRecordPOExample integralCouponPayRecordPOExampleUpdate = new IntegralCouponPayRecordPOExample();
        integralCouponPayRecordPOExampleUpdate.createCriteria().andMerchantIdEqualTo(merchantId).andOrderIdEqualTo(Integer.valueOf(convertCouponRecordId.intValue())).andValidEqualTo(Boolean.TRUE);
        this.integralCouponPayRecordPOMapper.updateByExampleSelective(integralCouponPayRecordPO, integralCouponPayRecordPOExampleUpdate);
        String appId = result.getAppid();
        String nonceStr = result.getNonceStr();
        String sign = result.getSign();
        String prepayId = result.getPrepayId();
        String signType = "MD5";
        String timeStamp = result.getTimeStamp();
        JsPayResponse jsPayResponse = new JsPayResponse(appId, timeStamp, nonceStr, prepayId, signType, sign);
        return ResponseUtil.getSuccessData((Object)jsPayResponse);
    }

    public int modifyMchStatus(Integer id, PayGatewaySyncStatusEnum payGatewaySyncStatusEnum) {
        IntegralUnionPayMchPO integralUnionPayMchPO = new IntegralUnionPayMchPO();
        integralUnionPayMchPO.setId(id);
        integralUnionPayMchPO.setStatus(payGatewaySyncStatusEnum.getStatus());
        integralUnionPayMchPO.setGmtModified(new Date());
        int i = this.integralUnionPayMchPOMapper.updateByPrimaryKeySelective(integralUnionPayMchPO);
        return i;
    }
}

