/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.selfmentionorder.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.OrdersCommission;
import com.wmeimob.fastboot.bizvane.entity.selfMention.SelfMentionReceivedRequestVO;
import com.wmeimob.fastboot.bizvane.enums.LogisticsStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.PayStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.ShippingModeEnum;
import com.wmeimob.fastboot.bizvane.mapper.OrdersCommissionMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CompanyBrandRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.RefundOrderPOMapper;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPO;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPOExample;
import com.wmeimob.fastboot.bizvane.po.RefundOrderPOExample;
import com.wmeimob.fastboot.bizvane.service.selfmentionorder.SelfMentionOrderService;
import com.wmeimob.fastboot.config.MallAdminException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service
public class SelfMentionOrderServiceImpl
implements SelfMentionOrderService {
    private static final Logger log = LoggerFactory.getLogger(SelfMentionOrderServiceImpl.class);
    @Resource
    private OrdersMapper ordersMapper;
    @Resource
    private RefundOrderPOMapper refundOrderPOMapper;
    @Resource
    private CompanyBrandRelationPOMapper companyBrandRelationPOMapper;
    @Resource
    private OrdersCommissionMapper ordersCommissionMapper;

    @Transactional
    public void confirm(SelfMentionReceivedRequestVO vo) {
        log.info("\u786e\u8ba4\u6536\u8d27\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)vo));
        Assert.notNull((Object)vo.getId(), (String)"\u8ba2\u5355ID");
        Example example = new Example(Orders.class);
        example.createCriteria().andEqualTo("id", (Object)vo.getId());
        Orders orders = this.ordersMapper.selectByIdAndUserId(vo.getUserId(), vo.getId());
        if (orders == null) {
            throw new MallAdminException("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (!PayStatusEnum.SUCCESS.equals((Object)orders.getPayStatus())) {
            throw new MallAdminException("\u8ba2\u5355\u672a\u652f\u4ed8\uff0c\u4e0d\u80fd\u786e\u8ba4\u6536\u8d27");
        }
        if (!Integer.valueOf(ShippingModeEnum.SELF_MENTION.getCode()).equals(orders.getShippingMode())) {
            throw new MallAdminException("\u975e\u81ea\u63d0\u8ba2\u5355\u4e0d\u80fd\u786e\u8ba4\u6536\u8d27");
        }
        RefundOrderPOExample refundOrderPOExample = new RefundOrderPOExample();
        refundOrderPOExample.createCriteria().andValidEqualTo(Integer.valueOf(1)).andOrderNoEqualTo(orders.getOrderNo()).andAuditStatusEqualTo(new Byte("0"));
        List refundOrderPOS = this.refundOrderPOMapper.selectByExample(refundOrderPOExample);
        if (LogisticsStatusEnum.RECEIVED.equals((Object)orders.getLogisticsStatus())) {
            throw new MallAdminException("\u6b64\u8ba2\u5355\u5df2\u7ecf\u786e\u8ba4\u6536\u8d27\uff0c\u4e0d\u80fd\u91cd\u590d\u81ea\u63d0");
        }
        log.info("\u65b0\u8ba2\u5355\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)orders));
        Date date = new Date();
        orders.setLogisticsStatus(LogisticsStatusEnum.RECEIVED);
        orders.setOrderStatus(OrdersStatusEnum.SUCCESS);
        orders.setReceiptAt(date);
        orders.setShippingAt(date);
        orders.setGmtModified(date);
        orders.setPickErpGuideId(vo.getPickErpGuideId());
        orders.setPickErpGuideName(vo.getPickErpGuideName());
        log.info("\u786e\u8ba4\u6536\u8d27\u4e4b\u524d:{}", (Object)orders.getCommission());
        log.info("\u786e\u8ba4\u6536\u83b7\u662f\u5426\u7ed3\u7b97:{}", (Object)orders.getIsSettleCommission());
        int result = this.ordersMapper.updateByExampleSelective((Object)orders, (Object)example);
        if (result == 0) {
            log.error("\u786e\u8ba4\u6536\u8d27\u5931\u8d25 => {}", (Object)JSONObject.toJSONString((Object)orders));
            throw new MallAdminException("\u786e\u8ba4\u6536\u8d27\u5931\u8d25");
        }
        OrdersCommission ordersCommission = new OrdersCommission();
        ordersCommission.setOrderId(Long.valueOf(orders.getId().longValue()));
        ordersCommission.setVersion(Integer.valueOf(0));
        ordersCommission.setCreateDate(new Date());
        this.ordersCommissionMapper.insert((Object)ordersCommission);
    }

    public List<Integer> getMerchantIdByCompanyId(Integer sysCompanyId) {
        log.info("SelfMentionOrderServiceImpl#getMerchantIdByCompanyId:{}", (Object)sysCompanyId);
        ArrayList<Integer> result = new ArrayList<Integer>();
        CompanyBrandRelationPOExample brandRelationPOExample = new CompanyBrandRelationPOExample();
        brandRelationPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andCompanyIdEqualTo(sysCompanyId);
        List companyBrandRelationPOS = this.companyBrandRelationPOMapper.selectByExample(brandRelationPOExample);
        log.info("getMerchantIdByCompanyId_companyBrandRelationPOS\uff1a{}", (Object)JSON.toJSONString((Object)companyBrandRelationPOS));
        if (CollectionUtils.isEmpty((Collection)companyBrandRelationPOS)) {
            return null;
        }
        for (CompanyBrandRelationPO po : companyBrandRelationPOS) {
            result.add(po.getMerchantId());
        }
        return result;
    }
}

