/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.seckill.impl;

import com.wmeimob.fastboot.bizvane.dto.seckill.BrandUserDTO;
import com.wmeimob.fastboot.bizvane.enums.MarketActivityEnum;
import com.wmeimob.fastboot.bizvane.enums.seckill.MarketActivitySecKillStatusEnum;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityMomentPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityPOMapper;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityMomentPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityPOExample;
import com.wmeimob.fastboot.bizvane.service.seckill.MarketActivitySecKillBuilderService;
import com.wmeimob.fastboot.bizvane.utils.DateUtil;
import com.wmeimob.fastboot.bizvane.utils.StringUtil;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillAddRequestVO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MarketActivitySecKillBuilderServiceImpl
implements MarketActivitySecKillBuilderService {
    private static final Logger log = LoggerFactory.getLogger(MarketActivitySecKillBuilderServiceImpl.class);
    @Resource
    private MarketActivityPOMapper marketActivityPOMapper;
    @Resource
    private MarketActivityMomentPOMapper marketActivityMomentPOMapper;

    public MarketActivityPO marketActivityPOBuilder(MarketActivitySecKillAddRequestVO requestVO, BrandUserDTO brandUserDTO) throws Exception {
        CompanyBrandRelationPO companyBrandRelationPO = brandUserDTO.getCompanyBrandRelationPO();
        String marketActivityType = MarketActivityEnum.SEC_KILL.getType().toString();
        MarketActivityPOExample marketActivityPOExample = new MarketActivityPOExample();
        marketActivityPOExample.createCriteria().andMerchantIdEqualTo(companyBrandRelationPO.getMerchantId()).andActivityTypeEqualTo(marketActivityType).andValidEqualTo(Boolean.TRUE);
        List marketActivityPOS = this.marketActivityPOMapper.selectByExample(marketActivityPOExample);
        Integer number = 1;
        if (!CollectionUtils.isEmpty((Collection)marketActivityPOS)) {
            number = number + marketActivityPOS.size();
        }
        Date marketActivityStartTime = requestVO.getMarketActivityStartTime();
        Date marketActivityEndTime = requestVO.getMarketActivityEndTime();
        Integer marketActivityMomentId = requestVO.getMarketActivityMomentId();
        int dateCompare = marketActivityStartTime.compareTo(marketActivityEndTime);
        if (dateCompare != -1) {
            throw new Exception("\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4!");
        }
        MarketActivityMomentPO marketActivityMomentPO = this.marketActivityMomentPOMapper.selectByPrimaryKey(marketActivityMomentId);
        String marketActivityMomentDate = marketActivityMomentPO.getMarketActivityMomentDate();
        Calendar startCalendar = Calendar.getInstance();
        Date time = startCalendar.getTime();
        startCalendar.setTime(marketActivityStartTime);
        Date startCalendarTime = startCalendar.getTime();
        String startHour = startCalendar.get(11) + "";
        int startCompare = startHour.compareTo(marketActivityMomentDate);
        if (startCompare != 0) {
            throw new Exception("\u60a8\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e3a:" + DateUtil.format((Date)marketActivityStartTime, (String)DateUtil.ymdhms) + ",\u53ea\u80fd\u9009\u62e9" + startHour + "\u70b9\u573a,\u8bf7\u91cd\u65b0\u9009\u62e9\u573a\u6b21\u6216\u4fee\u6539\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4!");
        }
        if (time.compareTo(startCalendarTime) > 0) {
            throw new Exception("\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
        ArrayList<Integer> integers = new ArrayList<Integer>();
        integers.add(MarketActivitySecKillStatusEnum.HAVE_NOT_START.getCode());
        integers.add(MarketActivitySecKillStatusEnum.ON_GOING.getCode());
        MarketActivityPOExample marketActivityPOExample1 = new MarketActivityPOExample();
        marketActivityPOExample1.createCriteria().andActivityBeginTimeBetween(DateUtil.getStartDateOfDay((Date)marketActivityStartTime), DateUtil.getEndDateOfDay((Date)marketActivityStartTime)).andMarketActivityMomentIdEqualTo(marketActivityMomentId).andActivityStatusValueIn(integers).andValidEqualTo(Boolean.TRUE);
        List marketActivityPOList = this.marketActivityPOMapper.selectByExample(marketActivityPOExample1);
        if (!CollectionUtils.isEmpty((Collection)marketActivityPOList)) {
            throw new Exception("\u65e0\u6cd5\u65b0\u589e\u591a\u4e2a\u540c\u4e00\u5929\u540c\u4e00\u573a\u6b21\u79d2\u6740\u6d3b\u52a8");
        }
        String marketActivityCode = MarketActivityEnum.SEC_KILL.getCode() + DateUtil.getNow((String)DateUtil.yymmddHHmmss) + StringUtil.leftAppendZero((int)number, (int)4);
        MarketActivityPO marketActivityPO = new MarketActivityPO();
        marketActivityPO.setMerchantId(companyBrandRelationPO.getMerchantId());
        marketActivityPO.setSysBrandId(companyBrandRelationPO.getBrandId());
        marketActivityPO.setActivityNo(marketActivityCode);
        marketActivityPO.setActivityName(requestVO.getMarketActivityName());
        marketActivityPO.setActivityBeginTime(marketActivityStartTime);
        marketActivityPO.setActivityEndTime(marketActivityEndTime);
        marketActivityPO.setActivityTermValidity(Integer.valueOf(0));
        marketActivityPO.setActivityType(marketActivityType);
        marketActivityPO.setActivityStatus(Boolean.TRUE);
        marketActivityPO.setGmtCreate(new Date());
        marketActivityPO.setMarketActivityMomentId(marketActivityMomentId);
        marketActivityPO.setMarketActivityBuyNum(requestVO.getMarketActivityBuyNum());
        marketActivityPO.setMarketActivityAwaitOrderClose(requestVO.getMarketActivityAwaitOrderClose());
        marketActivityPO.setMarketActivityAwaitMessageSend(requestVO.getMarketActivityAwaitMessageSend());
        marketActivityPO.setActivityStatusValue(MarketActivitySecKillStatusEnum.HAVE_NOT_START.getCode());
        int i = this.marketActivityPOMapper.insertSelective(marketActivityPO);
        return marketActivityPO;
    }
}

