/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.qdqm;

import com.wmeimob.fastboot.bizvane.entity.LoginUser;
import com.wmeimob.fastboot.bizvane.entity.MerchantImportTask;
import com.wmeimob.fastboot.bizvane.mapper.MerchantImportTaskMapper;
import com.wmeimob.fastboot.bizvane.service.qdqm.ImportTaskService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.qdqm.ImportGoodsVO;
import com.wmeimob.fastboot.bizvane.vo.qdqm.ImportTaskRequestVO;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ImportTaskServiceImpl
implements ImportTaskService {
    private static final Logger log = LoggerFactory.getLogger(ImportTaskServiceImpl.class);
    @Resource
    private MerchantImportTaskMapper merchantImportTaskMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseData<MerchantImportTask> addTask(ImportTaskRequestVO requestVO, LoginUser loginUser) throws Exception {
        String accountCode = loginUser.getAccountCode();
        String fileUrl = requestVO.getFileUrl();
        if (StringUtils.isEmpty((Object)fileUrl)) {
            return ResponseUtil.getFailedMsg((String)"\u8bf7\u8f93\u5165\u6b63\u786eurl");
        }
        URL url = new URL(fileUrl = fileUrl.replace("https", "http").replace("http", "https"));
        InputStream is = url.openConnection().getInputStream();
        if (is == null) {
            return ResponseUtil.getFailedMsg((String)"\u65e0\u5185\u5bb9,\u5bfc\u5165\u5904\u7406\u5931\u8d25!");
        }
        Workbook wb = null;
        try {
            wb = WorkbookFactory.create((InputStream)is);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u6587\u4ef6\u5931\u8d25:", (Throwable)e);
            ResponseData responseData = ResponseUtil.getFailedMsg((String)"\u89e3\u6790\u6587\u4ef6\u5931\u8d25,\u8bf7\u786e\u5b9a\u4e0a\u4f20\u4e86\u6b63\u786e\u6587\u4ef6!");
            return responseData;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        Sheet firstSheet = wb.getSheetAt(0);
        int lastRowNum = firstSheet.getLastRowNum();
        log.info("\u6700\u540e\u4e00\u884c\u884c\u53f7:{}", (Object)lastRowNum);
        if (lastRowNum > 50001) {
            return ResponseUtil.getFailedMsg((String)"\u6587\u6863\u5185\u5bb9\u8d85\u8fc750000\u6761,\u8bf7\u624b\u52a8\u62c6\u5206\u6587\u6863\u540e\u518d\u4e0a\u4f20");
        }
        MerchantImportTask merchantImportTask = new MerchantImportTask();
        merchantImportTask.setMerchantId(requestVO.getMerchantId());
        merchantImportTask.setFileName(requestVO.getFileName());
        merchantImportTask.setFileUrl(fileUrl);
        merchantImportTask.setGmtCreate(new Date());
        merchantImportTask.setValid(Boolean.TRUE);
        merchantImportTask.setType(requestVO.getType());
        merchantImportTask.setAccountcode(accountCode);
        merchantImportTask.setTrace(MDC.get((String)"traceId"));
        int i = this.merchantImportTaskMapper.insertSelective(merchantImportTask);
        return ResponseUtil.getSuccessData((Object)merchantImportTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportGoodsVO getTaskInfo(Integer taskId) throws Exception {
        if (taskId == null) {
            return null;
        }
        MerchantImportTask merchantImportTask = this.merchantImportTaskMapper.selectByPrimaryKey(taskId);
        String fileUrl = merchantImportTask.getFileUrl();
        if (StringUtils.isEmpty((Object)fileUrl)) {
            return null;
        }
        URL url = new URL(fileUrl);
        InputStream is = url.openConnection().getInputStream();
        if (is == null) {
            log.info("\u65e0\u5185\u5bb9,\u5bfc\u5165\u5904\u7406\u5931\u8d25!");
            return null;
        }
        Workbook wb = null;
        try {
            wb = WorkbookFactory.create((InputStream)is);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u6587\u4ef6\u5931\u8d25:", (Throwable)e);
            ImportGoodsVO importGoodsVO = null;
            return importGoodsVO;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        Sheet firstSheet = wb.getSheetAt(0);
        int lastRowNum = firstSheet.getLastRowNum();
        log.info("\u6700\u540e\u4e00\u884c\u884c\u53f7:{}", (Object)lastRowNum);
        if (lastRowNum > 50001) {
            log.error("\u6587\u6863\u5185\u5bb9\u8d85\u8fc750000\u6761,\u8bf7\u624b\u52a8\u62c6\u5206\u6587\u6863\u540e\u518d\u4e0a\u4f20");
            return null;
        }
        ArrayList<String> goodsNoList = new ArrayList<String>();
        for (int i = 0; i < lastRowNum; ++i) {
            Row row = firstSheet.getRow(i);
            String goodsNo = this.getValue(row.getCell(0)).trim();
            goodsNoList.add(goodsNo);
        }
        ImportGoodsVO importGoodsVO = new ImportGoodsVO();
        importGoodsVO.setGoodsNoList(goodsNoList);
        return importGoodsVO;
    }

    private String getValue(Cell cell) {
        String value = "";
        if (cell == null) {
            return value;
        }
        int cellType = cell.getCellType();
        switch (cellType) {
            case 0: {
                value = cell.getNumericCellValue() + "";
                break;
            }
            case 1: {
                value = cell.getStringCellValue();
            }
        }
        return value;
    }
}

