/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.jobhandler.integral;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.service.api.integaralstore.ErpOrderApiService;
import com.wmeimob.fastboot.bizvane.service.api.integaralstore.IntegralLogisticsService;
import com.wmeimob.fastboot.bizvane.utils.DateUtil;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.thirdpartyapi.constants.Constants361;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.vo361.ErpOrderInfo361;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.vo361.Get361IntegralOrdersFromErpRequestVO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.vo361.InterfaceResponse361DTO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.vo361.InterfaceResponseResult361DTO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.vo361.SaleAfterSpecInfo;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.vo361.UpdateIntegralOrderLogisticsInfoRequestVO;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import com.xxl.job.core.log.XxlJobLogger;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@JobHandler(value="IntegralOrderSyncEprLogistics361Job")
public class IntegralOrderSyncEprLogistics361Handler
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(IntegralOrderSyncEprLogistics361Handler.class);
    private static final String EXECUTE_BY_ORDER_NO = "EXECUTE_BY_ORDER_NO";
    private static final String EXECUTE_BY_TIME = "EXECUTE_BY_TIME";
    @Autowired
    @Lazy
    private ErpOrderApiService erpOrderApiService;
    @Autowired
    private IntegralLogisticsService integralLogisticsService;

    public ReturnT<String> execute(String s) {
        log.info("IntegralOrderSyncEprLogisticsHandler#execute===>:{}", (Object)s);
        return this.integralOrderSyncEprLogistics361Method(s);
    }

    private ReturnT<String> integralOrderSyncEprLogistics361Method(String params) {
        try {
            ReturnT returnT = new ReturnT();
            returnT.setCode(100);
            returnT.setContent((Object)("\u53c2\u6570:" + params));
            if (StringUtils.isEmpty((String)params)) {
                returnT.setMsg("\u53c2\u6570\u7a7a");
                return returnT;
            }
            Get361IntegralOrdersFromErpRequestVO request = new Get361IntegralOrdersFromErpRequestVO();
            JSONObject jsonParams = JSON.parseObject((String)params);
            log.info("jsonParams:{}", (Object)JSON.toJSONString((Object)jsonParams));
            String merchantIdStr = jsonParams.getString("merchantId");
            if (StringUtils.isEmpty((String)merchantIdStr)) {
                returnT.setMsg("merchantId\u4e3a\u7a7a");
                return returnT;
            }
            String executeType = jsonParams.getString("executeType");
            if (StringUtils.isEmpty((String)executeType)) {
                returnT.setMsg("executeType\u4e3a\u7a7a");
                return returnT;
            }
            if (EXECUTE_BY_ORDER_NO.equals(executeType)) {
                String orderNo = jsonParams.getString("orderNo");
                if (StringUtils.isEmpty((String)orderNo)) {
                    returnT.setMsg("orderNo\u4e3a\u7a7a");
                    return returnT;
                }
                request.setOrderNo(orderNo);
            }
            if (EXECUTE_BY_TIME.equals(executeType)) {
                int beforeTime = jsonParams.getIntValue("beforeTime");
                if (beforeTime >= 0) {
                    beforeTime = -15;
                }
                Date date = new Date();
                Date beginTime = DateUtils.addMinutes((Date)date, (int)beforeTime);
                request.setStartTime(DateUtil.format((Date)beginTime, (String)DateUtil.ymdhms));
                request.setEndTime(DateUtil.format((Date)date, (String)DateUtil.ymdhms));
                request.setPageSize(String.valueOf(50));
                request.setOrderStatus("6");
            }
            Integer merchantId = Integer.parseInt(merchantIdStr);
            request.setMerchantId(merchantId);
            ResponseData integralOrdersFromErp = this.erpOrderApiService.get361IntegralOrdersFromErp(request);
            int code = integralOrdersFromErp.getCode();
            if (0 == code) {
                String resultData;
                List erpOrderInfo361s;
                InterfaceResponse361DTO data = (InterfaceResponse361DTO)integralOrdersFromErp.getData();
                InterfaceResponseResult361DTO result = data.getResult();
                if (Constants361.INTERFACE_SUCCESS.equals(result.getCode()) && !CollectionUtils.isEmpty((Collection)(erpOrderInfo361s = JSONObject.parseArray((String)(resultData = result.getResult()), ErpOrderInfo361.class)))) {
                    for (ErpOrderInfo361 erpOrder : erpOrderInfo361s) {
                        UpdateIntegralOrderLogisticsInfoRequestVO requestVo = this.convertUpdateIntegralOrderLogisticsInfo(merchantId, erpOrder);
                        ResponseData booleanResponseData = this.integralLogisticsService.updateIntegralOrderLogisticsInfo(requestVo);
                        if (!((Boolean)booleanResponseData.getData()).booleanValue()) {
                            log.info(erpOrder.getOrderNo() + "\u540c\u6b65\u7269\u6d41\u5931\u8d25");
                            continue;
                        }
                        log.info(erpOrder.getOrderNo() + "\u540c\u6b65\u7269\u6d41\u6210\u529f");
                    }
                }
                return ReturnT.SUCCESS;
            }
            log.info("\u7269\u6d41\u540c\u6b65\u6267\u884c\u6709\u8bef:{}", (Object)JSON.toJSONString((Object)integralOrdersFromErp));
            XxlJobLogger.log((String)("\u7269\u6d41\u540c\u6b65\u6267\u884c\u6709\u8bef" + JSON.toJSONString((Object)integralOrdersFromErp)), (Object[])new Object[0]);
        }
        catch (Exception e) {
            log.warn("IntegralOrderSyncEprLogistics361Handler#integralOrderSyncEprLogistics361Method\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            XxlJobLogger.log((String)"\u7269\u6d41\u540c\u6b65\u6267\u884c\u5f02\u5e38", (Object[])new Object[]{e});
        }
        return ReturnT.FAIL;
    }

    private UpdateIntegralOrderLogisticsInfoRequestVO convertUpdateIntegralOrderLogisticsInfo(Integer merchantId, ErpOrderInfo361 erpOrder) {
        log.info("IntegralOrderSyncEprLogistics361Handler#convertUpdateIntegralOrderLogisticsInfo:{},{}", (Object)merchantId, (Object)JSON.toJSONString((Object)erpOrder));
        UpdateIntegralOrderLogisticsInfoRequestVO params = new UpdateIntegralOrderLogisticsInfoRequestVO();
        params.setMerchantId(merchantId);
        params.setOrderNo(erpOrder.getOrderNo());
        params.setCourierCompanyName(erpOrder.getExp_Name());
        List saleAfterSpec = erpOrder.getSaleAfterSpec();
        if (!CollectionUtils.isEmpty((Collection)saleAfterSpec)) {
            SaleAfterSpecInfo saleAfterSpecInfo = (SaleAfterSpecInfo)saleAfterSpec.get(0);
            String expNum = saleAfterSpecInfo.getExpNum();
            params.setCourierNo(expNum);
        }
        params.setSendGoodTime(DateUtil.parse((String)erpOrder.getExpTime(), (String)DateUtil.ymdhms));
        params.setShippingName(erpOrder.getC_Name());
        params.setShippingMobile(erpOrder.getMobiTel());
        String address = erpOrder.getAddress();
        if (!StringUtils.isEmpty((String)address)) {
            String[] s = address.split(" ");
            params.setShippingProvince(s[0]);
            params.setShippingCity(s[1]);
            params.setShippingDistrict(s[2]);
            params.setShippingAddress(address);
        }
        params.setUserComments(StringUtils.isEmpty((String)erpOrder.getC_Remark()) ? "\u65e0" : erpOrder.getC_Remark());
        return params;
    }
}

