/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.jobhandler;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityOrdersPOMapper;
import com.wmeimob.fastboot.bizvane.po.MarketActivityOrdersPO;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.vo.admin.OrderCancelVO;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@JobHandler(value="orderCancel")
@Component
public class OrderCancelJobHandler
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(OrderCancelJobHandler.class);
    @Autowired
    private MarketActivityOrdersPOMapper marketActivityOrdersPOMapper;
    @Autowired
    private OrdersService ordersService;

    public ReturnT<String> execute(String param) throws Exception {
        log.info("OrderCancelJobHandler#execute param:{}", (Object)param);
        Integer activityTermValidity = null;
        if (!StringUtils.isEmpty((Object)param)) {
            activityTermValidity = Integer.valueOf(param);
        }
        OrderCancelVO orderCancelVO = new OrderCancelVO();
        orderCancelVO.setActivityTermValidity(activityTermValidity);
        orderCancelVO.setActivityOrdersType("1");
        List assembleOrdersList = this.marketActivityOrdersPOMapper.selectCancelOrders(orderCancelVO);
        for (MarketActivityOrdersPO assembleOrders : assembleOrdersList) {
            log.info("OrderCancelJobHandler#execute assembleOrders:{}", (Object)assembleOrders.getOrdersNo());
            this.ordersService.autoCancelAssembleOrder(assembleOrders);
        }
        orderCancelVO.setActivityOrdersType("0");
        List reduceOrdersList = this.marketActivityOrdersPOMapper.selectCancelOrders(orderCancelVO);
        for (MarketActivityOrdersPO reduceOrders : reduceOrdersList) {
            log.info("OrderCancelJobHandler#execute reduceOrders:{}", (Object)JSON.toJSONString((Object)reduceOrders));
            this.ordersService.autoCancelReduceOrder(reduceOrders);
        }
        return ReturnT.SUCCESS;
    }
}

