/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.fegin.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoods;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrdersDetails;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsSkuMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralOrdersDetailsMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralOrdersMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.fegin.IntegralApiService;
import com.wmeimob.fastboot.bizvane.service.huairen.vo.BaseResponse;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.utils.response.SysResponseEnum;
import com.wmeimob.fastboot.bizvane.vo.fegin.IntegralOrderDetailRequestVo;
import com.wmeimob.fastboot.bizvane.vo.fegin.IntegralOrderRequestVo;
import com.wmeimob.fastboot.bizvane.vo.fegin.MemberInfoModel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class IntegralApiServiceImpl
implements IntegralApiService {
    private static final Logger log = LoggerFactory.getLogger(IntegralApiServiceImpl.class);
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Resource
    private IntegralOrdersMapper integralOrdersMapper;
    @Resource
    private IntegralOrdersDetailsMapper integralOrdersDetailsMapper;
    @Resource
    private CompanyBrandRelationMapper companyBrandRelationMapper;
    @Resource
    private IntegralGoodsMapper integralGoodsMapper;
    @Resource
    private IntegralGoodsSkuMapper integralGoodsSkuMapper;

    public ResponseData pushOrderToConnector(String orderNo) {
        log.info("IntegralApiServiceImpl_pushOrderToConnector\u53c2\u6570:{}", (Object)orderNo);
        Example integralOrdersExample = new Example(IntegralOrders.class);
        integralOrdersExample.createCriteria().andEqualTo("orderNo", (Object)orderNo);
        IntegralOrders integralOrders = (IntegralOrders)this.integralOrdersMapper.selectOneByExample((Object)integralOrdersExample);
        if (integralOrders == null) {
            log.info("pustIntegralOrder IntegralOrders\u4e3a\u7a7a,\u76f4\u63a5return");
            return ResponseUtil.getFailedMsg((String)("\u8ba2\u5355:" + orderNo + "\u4e0d\u5b58\u5728!"));
        }
        log.info("IntegralOrders:{}", (Object)JSON.toJSONString((Object)integralOrders));
        Example integralOrdersDetailsExample = new Example(IntegralOrdersDetails.class);
        integralOrdersDetailsExample.createCriteria().andEqualTo("orderNo", (Object)orderNo);
        List integralOrdersDetails = this.integralOrdersDetailsMapper.selectByExample((Object)integralOrdersDetailsExample);
        IntegralOrderRequestVo integralOrderRequestVo = new IntegralOrderRequestVo();
        integralOrderRequestVo.setConsigneeName(integralOrders.getShippingName());
        integralOrderRequestVo.setConsigneePhone(integralOrders.getShippingMobile());
        integralOrderRequestVo.setConsigneeProvince(integralOrders.getShippingProvince());
        integralOrderRequestVo.setConsigneeCity(integralOrders.getShippingCity());
        integralOrderRequestVo.setConsigneeArea(integralOrders.getShippingDistrict());
        integralOrderRequestVo.setConsigneeDetailed(integralOrders.getShippingAddress());
        integralOrderRequestVo.setOrderNo(integralOrders.getOrderNo());
        integralOrderRequestVo.setOrderTime(integralOrders.getOrderTime());
        integralOrderRequestVo.setStoreCode(integralOrders.getStoreCode());
        integralOrderRequestVo.setBrandId(integralOrders.getMerchantId());
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setBrandId(Long.valueOf(integralOrders.getMerchantId().longValue()));
        memberInfoModel.setCardNo(integralOrders.getMemberCardNo());
        BaseResponse memberInfoByCardNo = this.bizvaneInterface.getMemberInfoByCardNo(memberInfoModel);
        int singleMemberModelCode = memberInfoByCardNo.getCode();
        if (SysResponseEnum.SUCCESS.getCode() != singleMemberModelCode) {
            return ResponseUtil.getFailedMsg((String)"\u8c03\u7528\u4f1a\u5458\u63a5\u53e3\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u5931\u8d25!");
        }
        MemberInfoModel data = (MemberInfoModel)JSON.parseObject((String)JSON.toJSONString((Object)memberInfoByCardNo.getData()), MemberInfoModel.class);
        integralOrderRequestVo.setErpId(data.getErpId());
        IntegralGoods integralGoods = (IntegralGoods)this.integralGoodsMapper.selectByPrimaryKey((Object)integralOrders.getGoodId());
        Integer costPoints = 0;
        ArrayList<IntegralOrderDetailRequestVo> integralOrderDetailRequestVos = new ArrayList<IntegralOrderDetailRequestVo>();
        for (IntegralOrdersDetails integralOrdersDetail : integralOrdersDetails) {
            Integer saleIntegral = integralOrdersDetail.getSaleIntegral();
            Integer saleQuantity = integralOrdersDetail.getSaleQuantity();
            costPoints = costPoints + (saleIntegral + saleQuantity);
            IntegralOrderDetailRequestVo integralOrderDetailRequestVo = new IntegralOrderDetailRequestVo();
            integralOrderDetailRequestVo.setGoodsName(integralGoods.getGoodsName());
            integralOrderDetailRequestVo.setGoodsSkuNo(integralGoods.getGoodsNo());
            integralOrderDetailRequestVo.setSaleQuantity(saleQuantity);
            integralOrderDetailRequestVo.setSaleIntegral(saleIntegral);
            integralOrderDetailRequestVos.add(integralOrderDetailRequestVo);
        }
        integralOrderRequestVo.setCostPoints(costPoints);
        integralOrderRequestVo.setOrderDetail(integralOrderDetailRequestVos);
        log.info("\u8c03\u7528ConnectorServiceFeign.addIntegralOrder-->param:{}", (Object)JSON.toJSONString((Object)integralOrderRequestVo));
        BaseResponse memberInfoModelBaseResponse = null;
        try {
            memberInfoModelBaseResponse = this.bizvaneInterface.pushOrderToConnector(integralOrderRequestVo);
            log.info("\u8c03\u7528ConnectorServiceFeign.addIntegralOrder-->result:{}", (Object)JSON.toJSONString((Object)memberInfoModelBaseResponse));
        }
        catch (Exception e) {
            log.info("\u8c03\u7528ConnectorServiceFeign.addIntegralOrder-->error:{}", (Throwable)e);
            return ResponseUtil.getFailedMsg((String)"\u8c03\u7528yzwConnectorServiceFeign.addIntegralOrder-->error");
        }
        int code = memberInfoModelBaseResponse.getCode();
        if (code == 0) {
            return ResponseUtil.getSuccessData((Object)orderNo, (String)"\u63a8\u9001\u6210\u529f!");
        }
        return ResponseUtil.getFailedMsg((String)memberInfoModelBaseResponse.getMessage());
    }
}

