/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.api;

import com.wmeimob.fastboot.bizvane.api.vo.ApiModifyStockRequestVO;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.service.api.ApiStockService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service
public class ApiStockServiceImpl
implements ApiStockService {
    private static final Logger log = LoggerFactory.getLogger(ApiStockServiceImpl.class);
    @Resource
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Resource
    private GoodsMapper goodsMapper;

    public ResponseData updateStock(ApiModifyStockRequestVO requestVO) {
        String skuNo = requestVO.getSkuNo();
        Example example = new Example(GoodsSkuDetail.class);
        example.createCriteria().andEqualTo("skuNo", (Object)skuNo).andEqualTo("isDel", (Object)false);
        List goodsSkuDetailList = this.goodsSkuDetailMapper.selectByExample((Object)example);
        if (CollectionUtils.isEmpty((Collection)goodsSkuDetailList)) {
            return ResponseUtil.getFailedData((Object)skuNo, (String)"\u6b64sku\u4e0d\u5b58\u5728!");
        }
        GoodsSkuDetail goodsSkuDetailThis = null;
        for (GoodsSkuDetail goodsSkuDetail : goodsSkuDetailList) {
            Integer goodsId = goodsSkuDetail.getGoodsId();
            Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey((Object)goodsId);
            if (goods == null) continue;
            Integer merchantId = goods.getMerchantId();
            if (!Integer.valueOf(requestVO.getMerchantId()).equals(merchantId)) continue;
            goodsSkuDetailThis = goodsSkuDetail;
            break;
        }
        if (goodsSkuDetailThis == null) {
            return ResponseUtil.getFailedData((Object)skuNo, (String)"\u6b64\u5546\u6237sku\u4e0d\u5b58\u5728");
        }
        GoodsSkuDetail param = new GoodsSkuDetail();
        param.setId(goodsSkuDetailThis.getId());
        param.setStock(Integer.valueOf(requestVO.getStock()));
        param.setGmtModified(new Date());
        int count = this.goodsSkuDetailMapper.updateByPrimaryKeySelective((Object)param);
        if (count > 0) {
            log.info("\u66f4\u65b0\u5e93\u5b58\u6210\u529f,\u539f\u5e93\u5b58\u6570:{},\u65b0\u5e93\u5b58\u6570:{}", (Object)goodsSkuDetailThis.getStock(), (Object)requestVO.getStock());
        }
        return ResponseUtil.getSuccessData((Object)count, (String)"\u66f4\u65b0\u5e93\u5b58\u6210\u529f!");
    }
}

