/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.activity.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.newmapper.custommapper.ActivityPlusPOMapper;
import com.wmeimob.fastboot.bizvane.po.ActivityPO;
import com.wmeimob.fastboot.bizvane.po.ActivityPOExample;
import com.wmeimob.fastboot.bizvane.service.activity.ActivityDiscountService;
import com.wmeimob.fastboot.bizvane.vo.activity.discount.ActivityDiscountInfoResponseVO;
import com.wmeimob.fastboot.bizvane.vo.activity.discount.GetActivityListRequestVO;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ActivityDiscountServiceImpl
implements ActivityDiscountService {
    private static final Logger log = LoggerFactory.getLogger(ActivityDiscountServiceImpl.class);
    @Resource
    private ActivityPlusPOMapper activityPlusPoMapper;

    public ActivityDiscountInfoResponseVO findById(Integer id) {
        return this.activityPlusPoMapper.queryActivityInfoById(id);
    }

    public List<ActivityPO> queryActivityList(GetActivityListRequestVO getActivityListRequestVO) {
        log.info("ActivityDiscountServiceImpl # queryActivityList \u6d3b\u52a8\u5217\u8868\u67e5\u8be2:{}", (Object)JSON.toJSONString((Object)getActivityListRequestVO));
        ActivityPOExample getActivityListExample = new ActivityPOExample();
        getActivityListExample.setOrderByClause("end_date desc");
        ActivityPOExample.Criteria criteria = getActivityListExample.createCriteria().andMerchantIdEqualTo(getActivityListRequestVO.getMerchantId()).andTypeEqualTo(getActivityListRequestVO.getType()).andValidEqualTo(Boolean.TRUE);
        if (!StringUtils.isEmpty((Object)getActivityListRequestVO.getActivityName())) {
            criteria.andNameLike("%" + getActivityListRequestVO.getActivityName() + "%");
        }
        if (!StringUtils.isEmpty((Object)getActivityListRequestVO.getStatus())) {
            criteria.andStatusEqualTo(getActivityListRequestVO.getStatus());
        }
        List activityPoList = this.activityPlusPoMapper.selectByExample(getActivityListExample);
        log.info("\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)activityPoList));
        return activityPoList;
    }
}

