/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.entity.IntegralGoods;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoodsSku;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrdersDetails;
import com.wmeimob.fastboot.bizvane.entity.IntegralRefundOrder;
import com.wmeimob.fastboot.bizvane.enums.IntegralOrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsSkuMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralOrdersDetailsMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralOrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralRefundOrderMapper;
import com.wmeimob.fastboot.bizvane.service.IntegralOrdersService;
import com.wmeimob.fastboot.bizvane.service.StoreGetGoodsService;
import com.wmeimob.fastboot.bizvane.util.IntegralOrderNoUtil;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
public class StoreGetGoodsServiceImpl
implements StoreGetGoodsService {
    private static final Logger log = LoggerFactory.getLogger(StoreGetGoodsServiceImpl.class);
    @Autowired
    private IntegralOrdersMapper integralOrdersMapper;
    @Autowired
    private IntegralOrdersService integralOrdersService;
    @Autowired
    private IntegralRefundOrderMapper integralRefundOrderMapper;
    @Autowired
    private IntegralOrdersDetailsMapper integralOrdersDetailsMapper;
    @Autowired
    private IntegralGoodsMapper integralGoodsMapper;
    @Autowired
    private IntegralGoodsSkuMapper integralGoodsSkuMapper;

    public IntegralOrders getOrder(String orderNo) {
        log.info("\u67e5\u8be2\u8ba2\u5355 \u5165\u53c2:{}", (Object)orderNo);
        IntegralOrders integralOrders = new IntegralOrders();
        integralOrders.setOrderNo(orderNo);
        List list = this.integralOrdersMapper.getOrders(integralOrders);
        if (list.size() > 0) {
            IntegralOrders order = (IntegralOrders)list.get(0);
            Example exampleDetail = new Example(IntegralOrdersDetails.class);
            exampleDetail.createCriteria().andEqualTo("orderNo", (Object)order.getOrderNo());
            List details = this.integralOrdersDetailsMapper.selectByExample((Object)exampleDetail);
            if (details.size() > 0) {
                details.forEach(detail -> {
                    Integer goodId = detail.getGoodId();
                    Example exampleGood = new Example(IntegralGoods.class);
                    exampleGood.createCriteria().andEqualTo("id", (Object)goodId);
                    IntegralGoods good = (IntegralGoods)this.integralGoodsMapper.selectOneByExample((Object)exampleGood);
                    detail.setGoodsName(good == null ? "" : good.getGoodsName());
                    detail.setCoverImg(good == null ? "" : good.getCoverImg());
                    String skuNo = detail.getGoodsSkuNo();
                    Example exampleSku = new Example(IntegralGoodsSku.class);
                    exampleSku.createCriteria().andEqualTo("skuNo", (Object)skuNo);
                    IntegralGoodsSku sku = (IntegralGoodsSku)this.integralGoodsSkuMapper.selectOneByExample((Object)exampleSku);
                    detail.setIntegralGoodsSku(sku);
                });
            }
            order.setOrdersDetails(details);
            return order;
        }
        return null;
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public RestResult updateOrder(String orderNo, String staffName, String storeName) {
        IntegralOrders integralOrders = new IntegralOrders();
        integralOrders.setOrderNo(orderNo);
        List list = this.integralOrdersMapper.getOrders(integralOrders);
        if (list.size() > 0) {
            IntegralOrders order = (IntegralOrders)list.get(0);
            String status = order.getOrderStatus();
            IntegralOrders upOrder = new IntegralOrders();
            upOrder.setId(order.getId());
            upOrder.setSendGoodTime(new Date());
            int state = 0;
            if (IntegralOrdersStatusEnum.UN_SHIPPED.getCode().equals(status)) {
                upOrder.setOrderStatus(IntegralOrdersStatusEnum.SIGN.getCode());
                upOrder.setGmtModified(new Date());
                upOrder.setStaffName(staffName);
                upOrder.setStoreName(storeName);
                state = this.integralOrdersMapper.updateByPrimaryKeySelective((Object)upOrder);
            } else if (IntegralOrdersStatusEnum.SIGN.getCode().equals(status)) {
                IntegralRefundOrder integralRefundOrder = new IntegralRefundOrder();
                integralRefundOrder.setMemberCode(order.getMemberCode());
                integralRefundOrder.setMerchantId(order.getMerchantId());
                integralRefundOrder.setOrderNo(order.getOrderNo());
                integralRefundOrder.setRefundNo(IntegralOrderNoUtil.getRefundOrderNo());
                integralRefundOrder.setAuditStatus("1");
                Example detailExa = new Example(IntegralOrdersDetails.class);
                detailExa.createCriteria().andEqualTo("orderNo", (Object)order.getOrderNo());
                IntegralOrdersDetails details = (IntegralOrdersDetails)this.integralOrdersDetailsMapper.selectOneByExample((Object)detailExa);
                integralRefundOrder.setOrderDetailId(details.getId());
                integralRefundOrder.setRefundIntegral(order.getPrice());
                integralRefundOrder.setRefundQuantity(order.getSaleQuantity());
                integralRefundOrder.setRefundCash(order.getCashPrice());
                integralRefundOrder.setRefundStatus("0");
                integralRefundOrder.setAuditStatus("1");
                integralRefundOrder.setRefundType("2");
                integralRefundOrder.setRefundTime(new Date());
                integralRefundOrder.setAuditTime(new Date());
                integralRefundOrder.setRefundReason("\u95e8\u5e97\u9000\u8d27");
                integralRefundOrder.setGmtCreate(new Date());
                integralRefundOrder.setGmtModified(new Date());
                integralRefundOrder.setValid(Boolean.valueOf(true));
                state = this.integralRefundOrderMapper.insertSelective((Object)integralRefundOrder);
                this.integralOrdersService.refund(order.getOrderNo(), order.getMerchantId(), staffName, storeName, Boolean.FALSE);
            }
            if (state == 1) {
                return RestResult.success();
            }
        }
        return RestResult.fail();
    }
}

