/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSONObject;
import com.mzlion.easyokhttp.HttpClient;
import com.wmeimob.fastboot.bizvane.dto.LogisticInfoDTO;
import com.wmeimob.fastboot.bizvane.entity.LogisticCompany;
import com.wmeimob.fastboot.bizvane.mapper.LogisticInfoMapper;
import com.wmeimob.fastboot.bizvane.service.LogisticInfoService;
import com.wmeimob.fastboot.config.MallAdminException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class LogisticInfoServiceImpl
implements LogisticInfoService {
    private static final Logger log = LoggerFactory.getLogger(LogisticInfoServiceImpl.class);
    @Value(value="${kuaidi100.key}")
    private String key;
    @Value(value="${kuaidi100.customer}")
    private String customer;
    @Autowired
    private LogisticInfoMapper logisticInfoMapper;
    private static final String URL = "https://poll.kuaidi100.com/poll/query.do";

    public List<LogisticInfoDTO> queryLogisticInfo(String companyCode, String num, String phone) {
        JSONObject json = new JSONObject();
        json.put("com", (Object)companyCode);
        json.put("num", (Object)num);
        json.put("phone", (Object)phone);
        String param = json.toJSONString();
        String sign = this.buildSign(param, this.key, this.customer);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("param", param);
        params.put("sign", sign);
        params.put("customer", this.customer);
        log.info("\u5feb\u9012100\u53c2\u6570===>{}", (Object)params.toString());
        JSONObject res = (JSONObject)HttpClient.post((String)URL).param(params).asBean(JSONObject.class);
        log.info("\u5feb\u9012\u67e5\u8be2\u7ed3\u679c{}", (Object)res.toString());
        if (res.getJSONArray("data") == null) {
            throw new MallAdminException("\u67e5\u8be2\u65e0\u7ed3\u679c\uff0c\u8bf7\u9694\u6bb5\u65f6\u95f4\u518d\u67e5");
        }
        List result = null;
        try {
            result = (List)JSONObject.parseObject((String)res.getJSONArray("data").toString(), List.class);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
        return result;
    }

    public List<LogisticCompany> logisticList() {
        return this.logisticInfoMapper.selectAll();
    }

    private String buildSign(String param, String key, String customer) {
        StringBuffer sb = new StringBuffer(param);
        sb.append(key).append(customer);
        String sign = DigestUtils.md5Hex((String)sb.toString()).toUpperCase();
        log.info("\u7ec4\u88c5\u7b7e\u540d==>{}", (Object)sign);
        return sign;
    }
}

