/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.entity.GoodsSpec;
import com.wmeimob.fastboot.bizvane.entity.GoodsSpecRelation;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSpecMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSpecRelationMapper;
import com.wmeimob.fastboot.bizvane.service.GoodsSpecService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class GoodsSpecServiceImpl
implements GoodsSpecService {
    @Autowired
    private GoodsSpecMapper goodsSpecMapper;
    @Autowired
    private GoodsSpecRelationMapper goodsSpecRelationMapper;

    public GoodsSpec add(GoodsSpec goodsSpec) {
        InputValidator.checkLengthRange((Object)goodsSpec.getSpecName(), (int)1, (int)20, (String)"\u89c4\u683c\u540d\u79f0");
        InputValidator.checkEmpty((Object)goodsSpec.getSort(), (String)"\u6392\u5e8f\u503c");
        Example example = new Example(GoodsSpec.class);
        example.createCriteria().andEqualTo("specName", (Object)goodsSpec.getSpecName()).andEqualTo("merchantId", (Object)goodsSpec.getMerchantId());
        List goodsSpecs = this.goodsSpecMapper.selectByExample((Object)example);
        if (goodsSpecs.size() > 0) {
            throw new CustomException("\u89c4\u683c\u540d\u79f0\u91cd\u590d");
        }
        List specList = goodsSpec.getGoodsSpecList();
        if (specList.size() < 1) {
            throw new CustomException("\u53ef\u9009\u9879\u4e0d\u53ef\u4e3a\u7a7a");
        }
        Date date = new Date();
        goodsSpec.setGmtCreate(date);
        this.goodsSpecMapper.insertSelective((Object)goodsSpec);
        if (goodsSpec.getGoodsSpecList() != null) {
            List goodsSpecList = goodsSpec.getGoodsSpecList();
            for (GoodsSpec g : goodsSpecList) {
                g.setPid(goodsSpec.getId());
                g.setGmtCreate(date);
                g.setMerchantId(goodsSpec.getMerchantId());
            }
            this.goodsSpecMapper.insertList(goodsSpecList);
        }
        return goodsSpec;
    }

    public int update(GoodsSpec goodsSpec) {
        InputValidator.checkEmpty((Object)goodsSpec.getSpecName(), (String)"\u89c4\u683c\u540d\u79f0");
        InputValidator.checkEmpty((Object)goodsSpec.getSort(), (String)"\u6392\u5e8f\u503c");
        Example example = new Example(GoodsSpec.class);
        example.createCriteria().andEqualTo("pid", (Object)0).andEqualTo("specName", (Object)goodsSpec.getSpecName()).andEqualTo("merchantId", (Object)goodsSpec.getMerchantId()).andNotEqualTo("id", (Object)goodsSpec.getId());
        List goodsSpecs = this.goodsSpecMapper.selectByExample((Object)example);
        if (goodsSpecs.size() > 0) {
            throw new CustomException("\u89c4\u683c\u540d\u79f0\u91cd\u590d");
        }
        Date date = new Date();
        goodsSpec.setGmtModified(date);
        if (goodsSpec.getGoodsSpecList() != null) {
            List goodsSpecList = goodsSpec.getGoodsSpecList();
            ArrayList<GoodsSpec> list = new ArrayList<GoodsSpec>();
            for (GoodsSpec g : goodsSpecList) {
                if (g.getId() == null) {
                    g.setPid(goodsSpec.getId());
                    g.setGmtCreate(date);
                    g.setMerchantId(goodsSpec.getMerchantId());
                    list.add(g);
                    continue;
                }
                g.setGmtModified(date);
                this.goodsSpecMapper.updateByPrimaryKeySelective((Object)g);
            }
            if (list.size() > 0) {
                this.goodsSpecMapper.insertList(list);
            }
        }
        return this.goodsSpecMapper.updateByPrimaryKeySelective((Object)goodsSpec);
    }

    public int delete(Integer id) {
        List goodsSpecs = this.goodsSpecMapper.selectByPid(id);
        if (goodsSpecs.size() > 0) {
            throw new CustomException("\u8bf7\u5148\u5220\u9664\u5b50\u89c4\u683c");
        }
        Example example = new Example(GoodsSpecRelation.class);
        example.createCriteria().andEqualTo("specId", (Object)id);
        List list = this.goodsSpecRelationMapper.selectByExample((Object)example);
        if (list.size() > 0) {
            throw new CustomException("\u6709\u5546\u54c1\u5728\u4f7f\u7528\u6b64\u89c4\u683c\uff0c\u65e0\u6cd5\u5220\u9664\u8be5\u89c4\u683c");
        }
        return this.goodsSpecMapper.deleteByPrimaryKey((Object)id);
    }

    public List<GoodsSpec> findByCondition(GoodsSpec goodsSpec) {
        return this.goodsSpecMapper.selectList(goodsSpec);
    }

    public List<GoodsSpec> selectByPid(Integer pid) {
        Example example = new Example(GoodsSpec.class);
        example.createCriteria().andEqualTo("pid", (Object)pid);
        return this.goodsSpecMapper.selectByExample((Object)example);
    }
}

