/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.seckill;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.po.MarketActivityGoodsSecKillStatisticalListPO;
import com.wmeimob.fastboot.bizvane.service.CompanyBrandRelationService;
import com.wmeimob.fastboot.bizvane.service.seckill.MarketActivitySecKillStatisticalService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillGoodsStatisticalListSearchRequestVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillStatisticalDetailSearchRequestVO;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.excel.ExcelHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"marketActivitySecKillStatistical"})
public class MarketActivitySecKillStatisticalController {
    private static final Logger log = LoggerFactory.getLogger(MarketActivitySecKillStatisticalController.class);
    @Autowired
    private MarketActivitySecKillStatisticalService marketActivitySecKillStatisticalService;
    @Autowired
    private CompanyBrandRelationService companyBrandRelationService;

    @PostMapping(value={"searchSecKillStatisticalDetail"})
    public ResponseData findStatisticalDetail(@RequestBody MarketActivitySecKillStatisticalDetailSearchRequestVO vo, @RequestHeader Integer merchantId) {
        log.info("MarketActivitySecKillStatisticalController searchStatisticalDetail vo:{},merchantId:{}", JSON.toJSON((Object)vo), (Object)merchantId);
        vo.setMerchantId(merchantId);
        vo.setSysBrandId(this.companyBrandRelationService.getBrandIdByMerchantId(merchantId));
        if (vo.getMarketActivityId() == null) {
            return ResponseUtil.getFailedMsg((String)"\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.marketActivitySecKillStatisticalService.findStatisticalDetail(vo);
    }

    @PostMapping(value={"searchSecKillGoodsStatisticalList"})
    public ResponseData findSecKillGoodsStatisticalList(@RequestBody MarketActivitySecKillGoodsStatisticalListSearchRequestVO vo, @RequestHeader Integer merchantId) {
        log.info("MarketActivitySecKillStatisticalController findSecKillGoodsStatisticalList vo:{},merchantId:{}", JSON.toJSON((Object)vo), (Object)merchantId);
        vo.setMerchantId(merchantId);
        if (vo.getMarketActivityStatisticalId() == null) {
            return ResponseUtil.getFailedMsg((String)"\u6d3b\u52a8\u7edf\u8ba1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (vo.getPageIndex() == null || vo.getPageSize() == null) {
            return ResponseUtil.getFailedMsg((String)"\u5206\u9875\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageInfo secKillGoodsStatisticalList = this.marketActivitySecKillStatisticalService.findSecKillGoodsStatisticalListByStatisticalId(vo, Boolean.TRUE);
        return ResponseUtil.getSuccessData((Object)secKillGoodsStatisticalList);
    }

    @GetMapping(value={"secKillGoodsStatisticalExpert"})
    public void secKillGoodsStatisticalExpert(MarketActivitySecKillGoodsStatisticalListSearchRequestVO vo, HttpServletResponse res) {
        log.info("MarketActivitySecKillStatisticalController secKillGoodsStatisticalExpert vo:{}", JSON.toJSON((Object)vo));
        if (vo.getMarketActivityStatisticalId() == null) {
            throw new MallAdminException("\u5546\u54c1\u7edf\u8ba1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List secKillGoodsStatisticalList = this.marketActivitySecKillStatisticalService.findSecKillGoodsStatisticalListByStatisticalId(vo, Boolean.FALSE).getList();
        String[] heads = new String[]{"\u5546\u54c1\u7f16\u53f7", "\u5546\u54c1\u540d\u79f0", "\u5269\u4f59\u79d2\u6740\u5e93\u5b58", "\u8bbf\u95ee\u4eba\u6570", "\u652f\u4ed8\u4eba\u6570", "\u6210\u4ea4\u989d", "\u6210\u4ea4\u4ef6", "\u8bbf\u95ee\u652f\u4ed8\u8f6c\u5316\u7387"};
        String[] fields = new String[]{"goodsNo", "goodsName", "actuallyStock", "marketActivityGoodsStatisticalVisitNum", "marketActivityGoodsStatisticalPayNum", "marketActivityGoodsStatisticalOrderAmount", "marketActivityGoodsStatisticalSkuQuantity", "visitPayRate"};
        try {
            HSSFWorkbook hssfWorkbook = ExcelHelper.exportFromList((List)secKillGoodsStatisticalList, (String[])heads, (String[])fields, MarketActivityGoodsSecKillStatisticalListPO.class);
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u6d3b\u52a8\u5546\u54c1\u7edf\u8ba1\u8868.xls", "UTF-8"));
            hssfWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

