/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.qdqm;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.LoginUser;
import com.wmeimob.fastboot.bizvane.service.qdqm.GoodsSyncService;
import com.wmeimob.fastboot.bizvane.utils.LoginUtil;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.vo.qdqm.GoodsClickRequestVO;
import com.wmeimob.fastboot.bizvane.vo.qdqm.GoodsSyncConfirmResponseVO;
import com.wmeimob.fastboot.bizvane.vo.qdqm.GoodsSyncRequestVO;
import com.wmeimob.fastboot.bizvane.vo.qdqm.GoodsSyncResponseVO;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"goodsSync"})
public class GoodsSyncController {
    private static final Logger log = LoggerFactory.getLogger(GoodsSyncController.class);
    @Autowired
    private GoodsSyncService goodsSyncService;
    @Autowired
    private LoginUtil loginUtil;

    @PostMapping(value={"childSync"})
    public ResponseData<GoodsSyncResponseVO> addGoodsSyncRecordBatch(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody GoodsSyncRequestVO requestVO, HttpServletRequest request) {
        LoginUser loginUser = this.loginUtil.getLoginUser(request);
        requestVO.setMerchantId(merchantId);
        log.info("GoodsSyncController_addGoodsSyncRecordBatch_param:{}", (Object)JSON.toJSONString((Object)requestVO));
        ResponseData goodsSyncResponseVOResponseData = this.goodsSyncService.addGoodsSyncRecordBatch(requestVO, loginUser);
        log.info("GoodsSyncController_addGoodsSyncRecordBatch_response:{}", (Object)JSON.toJSONString((Object)goodsSyncResponseVOResponseData));
        return goodsSyncResponseVOResponseData;
    }

    @PostMapping(value={"childSyncConfirm"})
    public ResponseData<GoodsSyncConfirmResponseVO> childSyncConfirm(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody GoodsSyncRequestVO requestVO, HttpServletRequest request) {
        LoginUser loginUser = this.loginUtil.getLoginUser(request);
        requestVO.setMerchantId(merchantId);
        log.info("GoodsSyncController_childSyncConfirm_param:{}", (Object)JSON.toJSONString((Object)requestVO));
        ResponseData goodsSyncResponseVOResponseData = this.goodsSyncService.modifySyncRecordBatch(requestVO, loginUser);
        log.info("GoodsSyncController_childSyncConfirm_response:{}", (Object)JSON.toJSONString((Object)goodsSyncResponseVOResponseData));
        return goodsSyncResponseVOResponseData;
    }

    @PostMapping(value={"click"})
    public ResponseData<GoodsSyncResponseVO> click(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody GoodsClickRequestVO requestVO, HttpServletRequest request) {
        LoginUser loginUser = this.loginUtil.getLoginUser(request);
        requestVO.setMerchantId(merchantId);
        requestVO.setLoginUser(loginUser);
        log.info("GoodsSyncController_click_param:{}", (Object)JSON.toJSONString((Object)requestVO));
        ResponseData click = this.goodsSyncService.click(requestVO);
        log.info("GoodsSyncController_click_response:{}", (Object)JSON.toJSONString((Object)click));
        return click;
    }
}

