/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.integral;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.service.IntegralExpressTemplateService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.IntegralExpressTemplateVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/integral/express"})
public class IntegralExpressController {
    private static final Logger log = LoggerFactory.getLogger(IntegralExpressController.class);
    @Autowired
    private IntegralExpressTemplateService integralExpressTemplateService;

    @PostMapping
    public ResponseData add(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody IntegralExpressTemplateVO integralExpressTemplateVO) {
        integralExpressTemplateVO.setStatus(Boolean.valueOf(true));
        integralExpressTemplateVO.setMerchantId(merchantId);
        this.integralExpressTemplateService.add(integralExpressTemplateVO);
        return ResponseUtil.getSuccessData((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"{id}"})
    public ResponseData update(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody IntegralExpressTemplateVO integralExpressTemplateVO) {
        log.info("\u4f20\u5165\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)integralExpressTemplateVO));
        return this.integralExpressTemplateService.update(integralExpressTemplateVO);
    }

    @DeleteMapping(value={"{id}"})
    public ResponseData delete(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="id") Integer id) {
        this.integralExpressTemplateService.delete(merchantId, id);
        return ResponseUtil.getSuccessData((Object)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"list"})
    public ResponseData list(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody IntegralExpressTemplateVO expressTemplateVO) {
        expressTemplateVO.setMerchantId(merchantId);
        PageInfo pageInfo = this.integralExpressTemplateService.findByCondition(expressTemplateVO);
        return ResponseUtil.getSuccessData((Object)pageInfo);
    }

    @GetMapping(value={"{id}"})
    public ResponseData selectById(@PathVariable(value="id") Integer id) {
        IntegralExpressTemplateVO integralExpressTemplateVO = this.integralExpressTemplateService.findById(id);
        return ResponseUtil.getSuccessData((Object)integralExpressTemplateVO);
    }
}

