/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.integral;

import com.wmeimob.fastboot.bizvane.controller.integral.IntegralExcelImportUtils;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoods;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.entity.IntegralRefundOrder;
import com.wmeimob.fastboot.bizvane.entity.integralstore.IntegralGoodsCouponImport;
import com.wmeimob.fastboot.bizvane.enums.admin.ExportTempleHelp;
import com.wmeimob.fastboot.bizvane.enums.admin.IntegralGoodsCouponImportEnum;
import com.wmeimob.fastboot.bizvane.service.ExcelDisposeService;
import com.wmeimob.fastboot.bizvane.service.LogisticInfoService;
import com.wmeimob.fastboot.bizvane.service.importExcelService;
import com.wmeimob.fastboot.bizvane.utils.DateUtil;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.excel.ExcelHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/integral/excel"})
@Api(description="\u79ef\u5206\u5546\u57ceExcel\u5bfc\u5165\u5bfc\u51faAPI")
public class ExcelDisposeController {
    private static final Logger log = LoggerFactory.getLogger(ExcelDisposeController.class);
    @Autowired
    private ExcelDisposeService excelDisposeService;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private LogisticInfoService logisticInfoService;
    @Autowired
    private importExcelService importExcelService;
    public static final String UNDEFINED = "undefined";
    public static final String NULL = "null";

    @GetMapping(value={"/getGoodsCouponImportExcel"})
    public void getGoodsCouponImport(HttpServletResponse res) {
        log.info("ExcelDisposeController#getGoodsCouponImport");
        try {
            ExportTempleHelp exportTempleHelp = IntegralGoodsCouponImportEnum.getExportTempleHelp();
            String[] heads = new String[]{"\u5238\u53f7", "\u5238\u6548\u671f\u5f00\u59cb\u65f6\u95f4", "\u5238\u6548\u671f\u622a\u6b62\u65f6\u95f4"};
            String[] fields = new String[]{"couponCode", "startTime", "endTime"};
            ArrayList<IntegralGoodsCouponImport> model = new ArrayList<IntegralGoodsCouponImport>();
            IntegralGoodsCouponImport couponImportModel = new IntegralGoodsCouponImport();
            couponImportModel.setCouponCode("as785454545");
            couponImportModel.setStartTime(DateUtil.stringToDate((String)"2020-06-09 12:00:00", (String)DateUtil.ymdhms));
            couponImportModel.setEndTime(DateUtil.stringToDate((String)"2020-07-09 12:00:00", (String)DateUtil.ymdhms));
            model.add(couponImportModel);
            HSSFWorkbook hssfWorkbook = ExcelHelper.exportFromList(model, (String[])heads, (String[])fields, IntegralGoodsCouponImport.class);
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u5bfc\u5165\u6a21\u677f.xls", "UTF-8"));
            hssfWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @ApiOperation(value="\u79ef\u5206\u5546\u54c1\u5bfc\u51fa")
    @ApiImplicitParam(name="merchantId", value="\u54c1\u724cid", dataType="int", paramType="path", required=true)
    @GetMapping(value={"/integralGoodsExport"})
    public void integralGoodsExport(Integer merchantId, HttpServletResponse res) {
        List list = this.excelDisposeService.integralGoodsExport(merchantId);
        String[] heads = new String[]{"\u5546\u54c1\u7f16\u53f7", "\u5546\u54c1\u540d\u79f0", "\u5546\u54c1\u72b6\u6001", "\u79ef\u5206\u4ef7", "\u603b\u5e93\u5b58", "\u5df2\u552e\u6570\u91cf"};
        String[] fields = new String[]{"goodsNo", "goodsName", "shelfName", "price", "totalStock", "actualSales"};
        try {
            HSSFWorkbook hssfWorkbook = ExcelHelper.exportFromList((List)list, (String[])heads, (String[])fields, IntegralGoods.class);
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u79ef\u5206\u5546\u54c1\u5217\u8868.xls", "UTF-8"));
            hssfWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    @ApiOperation(value="\u79ef\u5206\u8ba2\u5355\u5bfc\u51fa")
    @GetMapping(value={"/integralOrdersExport"})
    public void integralOrdersExport(IntegralOrders integralOrders, HttpServletResponse res) {
        if (UNDEFINED.equals(integralOrders.getOrderNo()) || NULL.equals(integralOrders.getOrderNo())) {
            integralOrders.setOrderNo(null);
        }
        if (UNDEFINED.equals(integralOrders.getGoodNo()) || NULL.equals(integralOrders.getGoodNo())) {
            integralOrders.setGoodNo(null);
        }
        if (UNDEFINED.equals(integralOrders.getMemberName()) || NULL.equals(integralOrders.getMemberName())) {
            integralOrders.setMemberName(null);
        }
        if (UNDEFINED.equals(integralOrders.getMemberCardNo()) || NULL.equals(integralOrders.getMemberCardNo())) {
            integralOrders.setMemberCardNo(null);
        }
        if (UNDEFINED.equals(integralOrders.getMemberPhone()) || NULL.equals(integralOrders.getMemberPhone())) {
            integralOrders.setMemberPhone(null);
        }
        if (UNDEFINED.equals(integralOrders.getBeginTime()) || NULL.equals(integralOrders.getBeginTime())) {
            integralOrders.setBeginTime(null);
        }
        if (UNDEFINED.equals(integralOrders.getEndTime()) || NULL.equals(integralOrders.getEndTime())) {
            integralOrders.setEndTime(null);
        }
        if (UNDEFINED.equals(integralOrders.getOrderStatus()) || NULL.equals(integralOrders.getOrderStatus())) {
            integralOrders.setOrderStatus(null);
        }
        if (UNDEFINED.equals(integralOrders.getGoodsName()) || NULL.equals(integralOrders.getGoodsName())) {
            integralOrders.setGoodsName(null);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String format = sdf.format(new Date());
        if (UNDEFINED.equals(integralOrders.getBeginTime()) || NULL.equals(integralOrders.getBeginTime())) {
            integralOrders.setBeginTime(format + " 00:00:00");
        }
        if (UNDEFINED.equals(integralOrders.getEndTime()) || NULL.equals(integralOrders.getEndTime())) {
            integralOrders.setEndTime(format + " 23:59:59");
        }
        List list = this.excelDisposeService.integralOrdersExport(integralOrders);
        String[] heads = new String[]{"\u79ef\u5206\u8ba2\u5355\u53f7", "\u7f16\u53f7", "\u4f1a\u5458\u540d\u79f0", "\u4f1a\u5458\u5361\u53f7", "\u8ba2\u5355\u72b6\u6001", "\u5546\u54c1\u540d\u79f0", "\u5546\u54c1SKU", "\u79ef\u5206\u5151\u6362\u4ef7\u683c", "\u5151\u6362\u6570\u91cf", "\u603b\u5151\u6362\u79ef\u5206\u6570", "\u73b0\u91d1\u652f\u4ed8\u91d1\u989d", "\u5151\u6362\u65f6\u95f4", "\u6536\u8d27\u4eba", "\u6536\u8d27\u5730\u5740", "\u624b\u673a\u53f7", "\u914d\u9001\u65b9\u5f0f", "\u81ea\u63d0\u95e8\u5e97\u7f16\u53f7", "\u7ecf\u9500\u5546"};
        String[] fields = new String[]{"orderNo", "goodNo", "memberName", "memberCardNo", "orderStatus", "goodsName", "goodsSkuSpecNames", "price", "saleQuantity", "saleIntegral", "salePrice", "gmtCreate", "shippingName", "showAddress", "shippingMobile", "shippingModeDetail", "storeCode", "distributorName"};
        for (IntegralOrders orders : list) {
            orders.setSaleIntegral(Integer.valueOf(orders.getSaleQuantity() * orders.getSaleIntegral()));
        }
        try {
            HSSFWorkbook hssfWorkbook = ExcelHelper.exportFromList((List)list, (String[])heads, (String[])fields, IntegralOrders.class);
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u79ef\u5206\u8ba2\u5355\u5217\u8868.xls", "UTF-8"));
            hssfWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    @ApiOperation(value="\u6a21\u677f\u5bfc\u51fa")
    @GetMapping(value={"/templateExport"})
    public void templateExport(HttpServletResponse res) {
        try {
            HSSFWorkbook hssfWorkbook = new HSSFWorkbook();
            HSSFSheet sheet = hssfWorkbook.createSheet("sheet1");
            HSSFCellStyle cellStyle = hssfWorkbook.createCellStyle();
            HSSFFont font = hssfWorkbook.createFont();
            font.setBoldweight((short)700);
            cellStyle.setFont(font);
            cellStyle.setAlignment((short)2);
            Row row = sheet.createRow(0);
            String[] heads = new String[]{"\u8ba2\u5355\u7f16\u53f7", "\u7269\u6d41\u516c\u53f8", "\u7269\u6d41\u7f16\u53f7"};
            for (int i = 0; i < heads.length; ++i) {
                Cell cell = row.createCell(i);
                cell.setCellStyle((CellStyle)cellStyle);
                cell.setCellValue(heads[i]);
            }
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("template.xls", "UTF-8"));
            hssfWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @ApiOperation(value="\u7269\u6d41\u4fe1\u606f\u5bfc\u5165")
    @PostMapping(value={"/importExcel"})
    public RestResult importExcel(String qiniuUrl) throws IOException {
        return this.excelDisposeService.importExcel(qiniuUrl);
    }

    @ApiOperation(value="\u8ba2\u5355\u5904\u7406\u5bfc\u51fa")
    @GetMapping(value={"/orderDisposeExport"})
    public void orderDisposeExport(IntegralOrders integralOrders, HttpServletResponse res) {
        if (UNDEFINED.equals(integralOrders.getOrderStatus()) || NULL.equals(integralOrders.getOrderStatus())) {
            integralOrders.setOrderStatus(null);
        }
        if (UNDEFINED.equals(integralOrders.getSearchForm()) || NULL.equals(integralOrders.getSearchForm())) {
            integralOrders.setSearchForm(null);
        }
        List list = this.excelDisposeService.integralOrdersExport(integralOrders);
        String[] heads = new String[]{"\u4f1a\u5458\u540d\u79f0", "\u4f1a\u5458\u624b\u673a", "\u8ba2\u5355\u7f16\u53f7", "\u8ba2\u5355\u72b6\u6001", "\u5546\u54c1\u540d\u79f0", "\u89c4\u683c\u63cf\u8ff0", "\u8d2d\u4e70\u6570\u91cf", "\u4e0b\u5355\u65f6\u95f4", "\u624b\u673a\u53f7", "\u7269\u6d41\u516c\u53f8", "\u914d\u9001\u65b9\u5f0f", "\u81ea\u63d0\u95e8\u5e97\u7f16\u53f7", "\u7ecf\u9500\u5546", "\u6536\u8d27\u5730\u5740"};
        String[] fields = new String[]{"memberName", "memberPhone", "orderNo", "orderStatus", "goodsName", "goodsSkuSpecNames", "saleQuantity", "gmtCreate", "shippingMobile", "courierCompanyName", "shippingModeDetail", "storeCode", "distributorName", "showAddress"};
        try {
            HSSFWorkbook hssfWorkbook = ExcelHelper.exportFromList((List)list, (String[])heads, (String[])fields, IntegralOrders.class);
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u8ba2\u5355\u5904\u7406\u5217\u8868.xls", "UTF-8"));
            hssfWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    @ApiOperation(value="\u552e\u540e\u5904\u7406\u5bfc\u51fa")
    @GetMapping(value={"/refundDisposeExport"})
    public void refundDisposeExport(IntegralRefundOrder integralRefundOrder, HttpServletResponse res) {
        if (UNDEFINED.equals(integralRefundOrder.getOrderType()) || NULL.equals(integralRefundOrder.getOrderType())) {
            integralRefundOrder.setOrderType(null);
        }
        if (UNDEFINED.equals(integralRefundOrder.getOrderNo()) || NULL.equals(integralRefundOrder.getOrderNo())) {
            integralRefundOrder.setOrderNo(null);
        }
        if (UNDEFINED.equals(integralRefundOrder.getAuditTimeStr()) || NULL.equals(integralRefundOrder.getAuditTimeStr())) {
            integralRefundOrder.setAuditTimeStr(null);
        }
        List list = this.excelDisposeService.refundDisposeExport(integralRefundOrder);
        String[] heads = new String[]{"\u8ba2\u5355\u7f16\u53f7", "\u8d2d\u4e70\u4eba", "\u9000\u6b3e\u91d1\u989d", "\u9000\u6b3e\u539f\u56e0", "\u9000\u6b3e\u5355\u53f7", "\u7533\u8bf7\u65f6\u95f4", "\u5ba1\u6838\u4eba", "\u5ba1\u6838\u65f6\u95f4", "\u5ba1\u6838\u53cd\u9988", "\u5b9e\u9645\u9000\u6b3e\u91d1\u989d", "\u72b6\u6001"};
        String[] fields = new String[]{"orderNo", "buyerName", "refundIntegral", "refundReason", "refundNo", "createTime", "auditor", "auditTimeStr", "auditReback", "refundIntegral", "orderType"};
        try {
            HSSFWorkbook hssfWorkbook = ExcelHelper.exportFromList((List)list, (String[])heads, (String[])fields, IntegralRefundOrder.class);
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u552e\u540e\u5904\u7406\u5217\u8868.xls", "UTF-8"));
            hssfWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    @GetMapping(value={"/imports"})
    public void imports(MultipartFile file) throws IOException, ParseException {
        List list = IntegralExcelImportUtils.parseExcel((InputStream)file.getInputStream());
        this.importExcelService.importExcel(list);
    }

    @GetMapping(value={"/importChangeStatus"})
    public void importChangeStatus(MultipartFile file) throws IOException, ParseException {
        List list = IntegralExcelImportUtils.parseExcelChangeStatus((MultipartFile)file);
        System.out.println(list.size());
        this.importExcelService.importChangeStatus(list);
    }
}

