/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.customization;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.po.CustomizationDetailPO;
import com.wmeimob.fastboot.bizvane.service.customization.CustomizationService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.customization.CustomizationCategoryAddRequestVO;
import com.wmeimob.fastboot.bizvane.vo.customization.CustomizationCategoryDetailListAddRequestVO;
import com.wmeimob.fastboot.bizvane.vo.customization.CustomizationCategoryDetailListSearchRequestVO;
import com.wmeimob.fastboot.bizvane.vo.customization.CustomizationCategoryListSearchRequestVO;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"customization"})
public class CustomizationController {
    private static final Logger log = LoggerFactory.getLogger(CustomizationController.class);
    @Autowired
    private CustomizationService customizationService;

    @PostMapping(value={"searchAvailableCustomizationList"})
    public ResponseData searchAvailableCustomizationList(@RequestHeader Integer merchantId) {
        log.info("CustomizationController#searchAvailableCustomizationList:{}", (Object)merchantId);
        return this.customizationService.searchAvailableCustomizationList(merchantId);
    }

    @PostMapping(value={"searchCategoryList"})
    public ResponseData searchCategoryList(@RequestHeader Integer merchantId, @RequestBody CustomizationCategoryListSearchRequestVO vo) {
        log.info("CustomizationController#searchCategoryList merchantId:{},vo:{}", (Object)merchantId, (Object)JSON.toJSONString((Object)vo));
        if (vo.getCustomizationRelationId() == null) {
            return ResponseUtil.getFailedMsg((String)"\u4f20\u5165\u7684\u5b9a\u5236\u670d\u52a1\u5173\u8054\u5173\u7cfbid\u4e3a\u7a7a");
        }
        if (vo.getPageJudge() == null) {
            vo.setPageJudge(Boolean.FALSE);
        }
        vo.setMerchantId(merchantId);
        return this.customizationService.searchCategoryList(vo);
    }

    @PostMapping(value={"updateCategory"})
    public ResponseData updateCategory(@RequestHeader Integer merchantId, @RequestBody CustomizationCategoryAddRequestVO vo) {
        vo.setMerchantId(merchantId);
        log.info("CustomizationController#updateCategory vo:{}", (Object)JSON.toJSONString((Object)vo));
        if (vo.getCustomizationRelationId() == null) {
            return ResponseUtil.getFailedMsg((String)"\u8be5\u5546\u6237\u5b9a\u5236\u5173\u7cfbid\u672a\u4f20\u5165");
        }
        if (StringUtils.isEmpty((Object)vo.getCustomizationCategoryName())) {
            return ResponseUtil.getFailedMsg((String)"\u4fee\u6539\u6216\u65b0\u589e\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.customizationService.checkCategoryName(vo)) {
            return ResponseUtil.getFailedMsg((String)"\u5206\u7c7b\u540d\u79f0\u91cd\u590d");
        }
        return this.customizationService.updateCategory(vo);
    }

    @GetMapping(value={"checkCategory"})
    public ResponseData checkCategory(@RequestParam Integer customizationCategoryId) {
        log.info("CustomizationController#checkCategory:{}", (Object)customizationCategoryId);
        return this.customizationService.checkCategoryInUsed(customizationCategoryId);
    }

    @GetMapping(value={"deleteCategory"})
    public ResponseData deleteCategory(@RequestParam Integer customizationCategoryId) {
        log.info("CustomizationController#deleteCategory:{}", (Object)customizationCategoryId);
        return this.customizationService.deleteCategory(customizationCategoryId);
    }

    @PostMapping(value={"searchCategoryDetailList"})
    public ResponseData searchCategoryDetailList(@RequestHeader Integer merchantId, @RequestBody CustomizationCategoryDetailListSearchRequestVO vo) {
        log.info("CustomizationController#searchCategoryDetailList vo:{}", (Object)JSON.toJSONString((Object)vo));
        if (vo.getCustomizationCategoryId() == null) {
            return ResponseUtil.getFailedMsg((String)"\u76ee\u5f55\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.customizationService.searchCategoryDetailList(vo);
    }

    @PostMapping(value={"searchAllCategoryDetailList"})
    public ResponseData searchAllCategoryDetailList(@RequestHeader Integer merchantId, @RequestBody CustomizationCategoryDetailListSearchRequestVO vo) {
        log.info("CustomizationController#searchCategoryDetailList vo:{}", (Object)JSON.toJSONString((Object)vo));
        if (vo.getCustomizationRelationId() == null) {
            return ResponseUtil.getFailedMsg((String)"\u5b9a\u5236\u670d\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (vo.getPageJudge() == null) {
            vo.setPageJudge(Boolean.valueOf(true));
        }
        if (vo.getPageJudge().booleanValue() && (vo.getPageNum() == null || vo.getPageSize() == null)) {
            return ResponseUtil.getFailedMsg((String)"\u5206\u9875\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.customizationService.searchAllCategoryDetailList(vo);
    }

    @PostMapping(value={"updateCategoryDetail"})
    public ResponseData updateCategoryDetail(@RequestHeader Integer merchantId, @RequestBody CustomizationCategoryDetailListAddRequestVO vo) {
        log.info("CustomizationController#updateCategoryDetail");
        if (vo.getCustomizationCategoryId() == null) {
            return ResponseUtil.getFailedMsg((String)"\u5206\u7c7bid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)vo.getDetailPOS())) {
            return ResponseUtil.getSuccessData((Object)"");
        }
        return this.customizationService.updateCategoryDetail(vo);
    }

    @GetMapping(value={"deleteCategoryDetail"})
    public ResponseData deleteCategoryDetail(@RequestParam Integer customizationDetailId) {
        log.info("CustomizationController#deleteCategoryDetail:{}", (Object)customizationDetailId);
        CustomizationCategoryDetailListAddRequestVO vo = new CustomizationCategoryDetailListAddRequestVO();
        CustomizationDetailPO po = new CustomizationDetailPO();
        po.setCustomizationDetailId(customizationDetailId);
        po.setValid(Boolean.FALSE);
        ArrayList<CustomizationDetailPO> pos = new ArrayList<CustomizationDetailPO>();
        pos.add(po);
        vo.setDetailPOS(pos);
        log.info("deleteCategoryDetail pos:{}", (Object)JSON.toJSONString(pos));
        return this.customizationService.updateCategoryDetail(vo);
    }
}

