/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.api;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.api.vo.ApiGetOrdersRequestVO;
import com.wmeimob.fastboot.bizvane.api.vo.ApiOrderRefundRequestVO;
import com.wmeimob.fastboot.bizvane.api.vo.ApiOrderUpSendGoodsExpandRequestVO;
import com.wmeimob.fastboot.bizvane.api.vo.ApiOrderUpSendGoodsRequestVO;
import com.wmeimob.fastboot.bizvane.api.vo.ApiPageVO;
import com.wmeimob.fastboot.bizvane.service.admin.ApiService;
import com.wmeimob.fastboot.bizvane.service.api.ApiOrdersService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.StringUtils;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"apiOrders"})
public class ApiOrderController {
    private static final Logger log = LoggerFactory.getLogger(ApiOrderController.class);
    @Resource
    private ApiService apiService;
    @Resource
    private ApiOrdersService apiOrdersService;

    @PostMapping(value={"/getUnSendOrders"})
    @ResponseBody
    public ResponseData<PageInfo> getUnPayOrders(@RequestBody ApiGetOrdersRequestVO requestVO) {
        log.info("ApiOrderController_getUnSendOrders:{}", (Object)JSON.toJSONString((Object)requestVO));
        String shopCode = requestVO.getShopCode();
        String merchantId = this.apiService.checkStoreAuth(requestVO.getToken(), shopCode, Boolean.FALSE);
        if (StringUtils.isEmpty((Object)merchantId)) {
            return ResponseUtil.getFailedMsg((String)"\u6b64\u5546\u6237\u672a\u914d\u7f6e");
        }
        requestVO.setMerchantId(merchantId);
        this.apiService.checkPage((ApiPageVO)requestVO);
        PageInfo unSendOrders = this.apiOrdersService.getUnSendOrders(requestVO);
        return ResponseUtil.getSuccessData((Object)unSendOrders, (String)"\u67e5\u8be2\u5f85\u53d1\u8d27\u8ba2\u5355\u6210\u529f");
    }

    @PostMapping(value={"/getRefundOrders"})
    @ResponseBody
    public ResponseData<PageInfo> getRefundOrders(@RequestBody ApiGetOrdersRequestVO requestVO) {
        log.info("ApiOrderController_getRefundOrders:{}", (Object)JSON.toJSONString((Object)requestVO));
        String shopCode = requestVO.getShopCode();
        String merchantId = this.apiService.checkStoreAuth(requestVO.getToken(), shopCode, Boolean.FALSE);
        if (StringUtils.isEmpty((Object)merchantId)) {
            return ResponseUtil.getFailedMsg((String)"\u6b64\u5546\u6237\u672a\u914d\u7f6e");
        }
        requestVO.setMerchantId(merchantId);
        this.apiService.checkPage((ApiPageVO)requestVO);
        PageInfo unSendOrders = this.apiOrdersService.getRefundOrders(requestVO);
        return ResponseUtil.getSuccessData((Object)unSendOrders, (String)"\u67e5\u8be2\u5f85\u9000\u8d27\u8ba2\u5355\u6210\u529f");
    }

    @PostMapping(value={"/setUpSendGoods"})
    @ResponseBody
    public ResponseData setUpSendGoods(@RequestBody ApiOrderUpSendGoodsRequestVO requestVO) {
        log.info("ApiOrderController_setUpSendGoods:{}", (Object)JSON.toJSONString((Object)requestVO));
        String orderNo = requestVO.getOrderNo();
        InputValidator.checkEmpty((Object)orderNo, (String)"orderNo");
        String shippingNo = requestVO.getShippingNo();
        InputValidator.checkEmpty((Object)shippingNo, (String)"shippingNo");
        String shippingVendor = requestVO.getShippingVendor();
        InputValidator.checkEmpty((Object)shippingVendor, (String)"shippingVendor");
        InputValidator.checkLengthRange((Object)shippingNo, (int)0, (int)20, (String)"\u5feb\u9012\u5355\u53f7");
        if (!Pattern.matches("^[a-zA-Z0-9\\-]+$", shippingNo)) {
            return ResponseUtil.getFailedMsg((String)"\u5feb\u9012\u5355\u53f7\u53c2\u6570\u5f02\u5e38");
        }
        String merchantId = this.apiService.checkStoreAuth(requestVO.getToken(), null, Boolean.FALSE);
        if (StringUtils.isEmpty((Object)merchantId)) {
            return ResponseUtil.getFailedMsg((String)"\u6b64\u5546\u6237\u672a\u914d\u7f6e");
        }
        requestVO.setMerchantId(merchantId);
        ResponseData responseData = this.apiOrdersService.setUpSendGoods(requestVO);
        return responseData;
    }

    @PostMapping(value={"/setRefund"})
    @ResponseBody
    public ResponseData setRefund(@RequestBody ApiOrderRefundRequestVO requestVO) {
        log.info("ApiOrderController_setRefund:{}", (Object)JSON.toJSONString((Object)requestVO));
        String refundNo = requestVO.getRefundNo();
        InputValidator.checkEmpty((Object)refundNo, (String)"refundNo");
        String merchantId = this.apiService.checkStoreAuth(requestVO.getToken(), null, Boolean.FALSE);
        if (StringUtils.isEmpty((Object)merchantId)) {
            return ResponseUtil.getFailedMsg((String)"\u6b64\u5546\u6237\u672a\u914d\u7f6e");
        }
        requestVO.setMerchantId(merchantId);
        ResponseData responseData = this.apiOrdersService.setRefund(requestVO);
        return responseData;
    }

    @PostMapping(value={"/setUpSendGoodsExpand"})
    @ResponseBody
    public ResponseData setUpSendGoodsExpand(@RequestBody ApiOrderUpSendGoodsExpandRequestVO requestVO) {
        log.info("ApiOrderController_setUpSendGoodsExpand:{}", (Object)JSON.toJSONString((Object)requestVO));
        String orderNo = requestVO.getOrderNo();
        InputValidator.checkEmpty((Object)orderNo, (String)"orderNo");
        String shippingNo = requestVO.getShippingNo();
        InputValidator.checkEmpty((Object)shippingNo, (String)"shippingNo");
        String shippingVendor = requestVO.getShippingVendor();
        InputValidator.checkEmpty((Object)shippingVendor, (String)"shippingVendor");
        String goodSkuNo = requestVO.getGoodSkuNo();
        InputValidator.checkEmpty((Object)goodSkuNo, (String)"goodSkuNo");
        InputValidator.checkLengthRange((Object)shippingNo, (int)0, (int)20, (String)"\u5feb\u9012\u5355\u53f7");
        if (!Pattern.matches("^[a-zA-Z0-9\\-]+$", shippingNo)) {
            return ResponseUtil.getFailedMsg((String)"\u5feb\u9012\u5355\u53f7\u53c2\u6570\u5f02\u5e38");
        }
        String merchantId = this.apiService.checkStoreAuth(requestVO.getToken(), null, Boolean.FALSE);
        if (StringUtils.isEmpty((Object)merchantId)) {
            return ResponseUtil.getFailedMsg((String)"\u6b64\u5546\u6237\u672a\u914d\u7f6e");
        }
        requestVO.setMerchantId(merchantId);
        ResponseData responseData = this.apiOrdersService.setUpSendGoodsExpand(requestVO);
        return responseData;
    }
}

