/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.admin;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.enums.admin.BatchSendExportTemplateEnum;
import com.wmeimob.fastboot.bizvane.enums.admin.ExportTempleHelp;
import com.wmeimob.fastboot.bizvane.enums.admin.ExportTempleNameEnum;
import com.wmeimob.fastboot.bizvane.enums.admin.GoodsExportTempleEnum;
import com.wmeimob.fastboot.bizvane.enums.admin.GoodsNoTempleEnum;
import com.wmeimob.fastboot.bizvane.enums.admin.SkusExportTempleEnum;
import com.wmeimob.fastboot.bizvane.vo.admin.BatchSendExportTempleVO;
import com.wmeimob.fastboot.bizvane.vo.admin.GoodsExportHelp;
import com.wmeimob.fastboot.bizvane.vo.admin.GoodsExportTempleVO;
import com.wmeimob.fastboot.bizvane.vo.admin.GoodsNoVO;
import com.wmeimob.fastboot.bizvane.vo.admin.OrderExportHelp;
import com.wmeimob.fastboot.bizvane.vo.admin.SkusExportTempleVO;
import com.wmeimob.fastboot.excel.ExcelHelper;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"export"})
public class ExportController {
    private static final Logger log = LoggerFactory.getLogger(ExportController.class);

    @ApiOperation(value="\u5546\u54c1\u6b3e\u53f7\u6a21\u677f\u5bfc\u51fa")
    @GetMapping(value={"/goodsTemplate"})
    public void goodsTemplate(HttpServletResponse res) throws Exception {
        log.info("ExportController_goodsTemplate");
        try {
            ExportTempleHelp goodsExportTempleHelp = GoodsExportTempleEnum.getExportTempleHelp();
            String[] goodsExportFields = goodsExportTempleHelp.getFields();
            String[] goodsExportNotes = goodsExportTempleHelp.getNotes();
            ArrayList<GoodsExportTempleVO> goodsDataList = new ArrayList<GoodsExportTempleVO>();
            GoodsExportTempleVO goodsExample = GoodsExportHelp.getGoodsExample();
            goodsDataList.add(goodsExample);
            log.info("data:{}", (Object)JSON.toJSONString(goodsDataList));
            log.info("field:{}", (Object)JSON.toJSONString((Object)goodsExportFields));
            log.info("notes:{}", (Object)JSON.toJSONString((Object)goodsExportNotes));
            HSSFWorkbook goodsWorkbook = ExcelHelper.exportFromList(goodsDataList, (String[])goodsExportNotes, (String[])goodsExportFields, GoodsExportTempleVO.class);
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(ExportTempleNameEnum.GOODS_EXPORT_TEMPLE.getName(), "UTF-8"));
            goodsWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (Exception e) {
            log.info("error:{}", (Throwable)e);
            e.printStackTrace();
        }
    }

    @ApiOperation(value="\u5546\u54c1SKU\u6a21\u677f\u5bfc\u51fa")
    @GetMapping(value={"/skusTemplate"})
    public void skusTemplate(HttpServletResponse res) throws Exception {
        log.info("ExportController_skusTemplate");
        try {
            ExportTempleHelp skuExportTempleHelp = SkusExportTempleEnum.getExportTempleHelp();
            String[] skusExportFields = skuExportTempleHelp.getFields();
            String[] skusExportNotes = skuExportTempleHelp.getNotes();
            List skusDataList = GoodsExportHelp.getSkusExample();
            log.info("data:{}", (Object)JSON.toJSONString((Object)skusDataList));
            log.info("field:{}", (Object)JSON.toJSONString((Object)skusExportFields));
            log.info("notes:{}", (Object)JSON.toJSONString((Object)skusExportNotes));
            HSSFWorkbook skusWorkbook = ExcelHelper.exportFromList((List)skusDataList, (String[])skusExportNotes, (String[])skusExportFields, SkusExportTempleVO.class);
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(ExportTempleNameEnum.SKUS_EXPORT_TEMPLE.getName(), "UTF-8"));
            skusWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (Exception e) {
            log.info("error:{}", (Throwable)e);
            e.printStackTrace();
        }
    }

    @ApiOperation(value="\u5546\u54c1\u7f16\u7801\u6a21\u677f\u5bfc\u51fa")
    @GetMapping(value={"/goodsNoTemplate"})
    public void goodsNoTemplate(HttpServletResponse res) {
        log.info("ExportController_goodsNoTemplate");
        try {
            ExportTempleHelp goodsNoExportTempleHelp = GoodsNoTempleEnum.getExportTempleHelp();
            String[] goodsNoExportFields = goodsNoExportTempleHelp.getFields();
            String[] goodsNoExportNotes = goodsNoExportTempleHelp.getNotes();
            List goodsNoVOList = GoodsExportHelp.getGoodsNoExample();
            log.info("data:{}", (Object)JSON.toJSONString((Object)goodsNoVOList));
            log.info("field:{}", (Object)JSON.toJSONString((Object)goodsNoExportFields));
            log.info("notes:{}", (Object)JSON.toJSONString((Object)goodsNoExportNotes));
            HSSFWorkbook skusWorkbook = ExcelHelper.exportFromList((List)goodsNoVOList, (String[])goodsNoExportNotes, (String[])goodsNoExportFields, GoodsNoVO.class);
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(ExportTempleNameEnum.GOODS_NO_TEMPLE.getName(), "UTF-8"));
            skusWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (Exception e) {
            log.info("error:{}", (Throwable)e);
            e.printStackTrace();
        }
    }

    @ApiOperation(value="\u6279\u91cf\u53d1\u8d27\u6a21\u677f\u5bfc\u51fa")
    @GetMapping(value={"exportSendTemplate"})
    public void exportFailedSendInfo(HttpServletResponse response) {
        log.info("ExportController_exportFailedSendInfo");
        try {
            ExportTempleHelp exportTempleHelp = BatchSendExportTemplateEnum.getExportTempleHelp();
            String[] fields = exportTempleHelp.getFields();
            String[] notes = exportTempleHelp.getNotes();
            BatchSendExportTempleVO batchSendExample = OrderExportHelp.getBatchSendExample();
            ArrayList<BatchSendExportTempleVO> batchSendExampleList = new ArrayList<BatchSendExportTempleVO>();
            batchSendExampleList.add(batchSendExample);
            log.info("data:{}", (Object)JSON.toJSONString((Object)batchSendExample));
            log.info("field:{}", (Object)JSON.toJSONString((Object)fields));
            log.info("notes:{}", (Object)JSON.toJSONString((Object)notes));
            HSSFWorkbook batchSendWorkbook = ExcelHelper.exportFromList(batchSendExampleList, (String[])notes, (String[])fields, BatchSendExportTempleVO.class);
            response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(ExportTempleNameEnum.BATCH_SEND_TEMPLE.getName(), "UTF-8"));
            batchSendWorkbook.write((OutputStream)response.getOutputStream());
            response.getOutputStream().close();
        }
        catch (Exception e) {
            log.warn("\u6279\u91cf\u53d1\u8d27\u6a21\u677f\u5bfc\u51fa\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            e.printStackTrace();
        }
    }
}

