/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.entity.GoodsTag;
import com.wmeimob.fastboot.bizvane.service.GoodsTagService;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.core.annotation.Page;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"goods-tag"})
public class GoodsTagController {
    private static final Logger log = LoggerFactory.getLogger(GoodsTagController.class);
    @Autowired
    private GoodsTagService goodsTagService;

    @PostMapping
    public RestResult add(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody GoodsTag goodsTag) {
        goodsTag.setMerchantId(merchantId);
        this.goodsTagService.add((Serializable)goodsTag);
        return RestResult.success();
    }

    @PutMapping(value={"{id}"})
    public RestResult update(@PathVariable(value="id") Integer id, @RequestBody GoodsTag goodsTag) {
        int result = 0;
        try {
            result = this.goodsTagService.update((Serializable)goodsTag);
        }
        catch (Exception e) {
            log.warn("\u66f4\u65b0\u6807\u7b7e\u5931\u8d25:msg:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallAdminException(e.getMessage());
        }
        return result > 0 ? RestResult.success() : RestResult.fail();
    }

    @DeleteMapping(value={"{id}"})
    public RestResult delete(@PathVariable(value="id") Integer id) {
        int result = this.goodsTagService.delete(id);
        return result > 0 ? RestResult.success() : RestResult.fail();
    }

    @GetMapping
    @Page
    public PageInfo list(@RequestHeader(value="merchantId") Integer merchantId, GoodsTag toodsTag) {
        toodsTag.setMerchantId(merchantId);
        List list = this.goodsTagService.findByCondition((Serializable)toodsTag);
        return new PageInfo(list);
    }

    @PostMapping(value={"/getNewTags"})
    public PageInfo getNewTags(@RequestHeader(value="merchantId") Integer merchantId) {
        GoodsTag toodsTag = new GoodsTag();
        toodsTag.setMerchantId(merchantId);
        List list = this.goodsTagService.findByCondition((Serializable)toodsTag);
        return new PageInfo(list);
    }
}

