/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.dto.GoodsQueryDTO;
import com.wmeimob.fastboot.bizvane.dto.GoodsStatisticalDTO;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsCopyVO;
import com.wmeimob.fastboot.bizvane.entity.GoodsTag;
import com.wmeimob.fastboot.bizvane.entity.LoginUser;
import com.wmeimob.fastboot.bizvane.entity.UpdateSalesEntity;
import com.wmeimob.fastboot.bizvane.entity.UpdateType;
import com.wmeimob.fastboot.bizvane.mapper.GoodsTagMapper;
import com.wmeimob.fastboot.bizvane.service.GoodsService;
import com.wmeimob.fastboot.bizvane.service.admin.GoodsNewService;
import com.wmeimob.fastboot.bizvane.service.admin.ImportService;
import com.wmeimob.fastboot.bizvane.service.customization.CustomizationService;
import com.wmeimob.fastboot.bizvane.service.qdqm.GoodsSyncChildService;
import com.wmeimob.fastboot.bizvane.utils.ConvertDateUtils;
import com.wmeimob.fastboot.bizvane.utils.DateUtil;
import com.wmeimob.fastboot.bizvane.utils.LoginUtil;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.GoodsClassificationVO;
import com.wmeimob.fastboot.bizvane.vo.GoodsExpressTemplateVO;
import com.wmeimob.fastboot.bizvane.vo.GoodsGroudVO;
import com.wmeimob.fastboot.bizvane.vo.GoodsTagVO;
import com.wmeimob.fastboot.bizvane.vo.PropValueVO;
import com.wmeimob.fastboot.bizvane.vo.admin.ImportVO;
import com.wmeimob.fastboot.bizvane.vo.customization.CustomizationCategoryAndGoodRelationAddRequestVO;
import com.wmeimob.fastboot.bizvane.vo.customization.CustomizationGoodRelationAddRequestVO;
import com.wmeimob.fastboot.bizvane.vo.goods.batchModify.BatchModifyDescRequestVO;
import com.wmeimob.fastboot.bizvane.vo.goods.batchModify.BatchModifyDispatchingTypeVO;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.core.annotation.Page;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.excel.DataConvert;
import com.wmeimob.fastboot.excel.ExcelHelper;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.util.Strings;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@RestController
@RequestMapping(value={"goods"})
public class GoodsController {
    private static final Logger log = LoggerFactory.getLogger(GoodsController.class);
    @Autowired
    private GoodsService goodsService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private GoodsTagMapper goodsTagMapper;
    @Autowired
    private CustomizationService customizationService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private LoginUtil loginUtil;
    @Autowired
    private ImportService importService;
    @Autowired
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private GoodsSyncChildService goodsSyncChildService;
    @Autowired
    private GoodsNewService goodsNewService;

    @PostMapping
    public Goods insert(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody Goods goods) {
        Goods add;
        log.info("\u65b0\u589e\u5546\u54c1\u5165\u53c2:merchantId:[{}],goods:[{}]", (Object)merchantId, JSON.toJSON((Object)goods));
        goods.setAccountCode(this.loginUtil.getLoginUser(this.request).getAccountCode());
        goods.setMerchantId(merchantId);
        try {
            add = (Goods)this.goodsService.add((Serializable)goods);
            log.info("goodsInfo:{}", (Object)goods.getIsUniform());
            if (goods.getIsUniform() == null) {
                this.scheduledThreadPoolExecutor.execute(() -> {
                    log.info("startAddCategoryAndGoodRelation relation:{}", (Object)JSON.toJSONString((Object)goods.getCustomizationGoodRelation()));
                    CustomizationCategoryAndGoodRelationAddRequestVO categoryAndGoodRelationAddRequestVO = new CustomizationCategoryAndGoodRelationAddRequestVO();
                    categoryAndGoodRelationAddRequestVO.setGoodId(goods.getId());
                    categoryAndGoodRelationAddRequestVO.setCustomizationGoodRelation(goods.getCustomizationGoodRelation());
                    if (!CollectionUtils.isEmpty((Collection)goods.getCustomizationGoodRelation())) {
                        for (CustomizationGoodRelationAddRequestVO relationAddRequestVO : goods.getCustomizationGoodRelation()) {
                            categoryAndGoodRelationAddRequestVO.setCategoryIds(relationAddRequestVO.getCustomizationCategoryId());
                            categoryAndGoodRelationAddRequestVO.setCustomizationRelationId(relationAddRequestVO.getCustomizationRelationId());
                            this.customizationService.addCategoryAndGoodsRelation(categoryAndGoodRelationAddRequestVO);
                        }
                    } else {
                        this.customizationService.addCategoryAndGoodsRelation(categoryAndGoodRelationAddRequestVO);
                    }
                });
            }
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u5546\u54c1\u5931\u8d25:msg:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallAdminException(e.getMessage());
        }
        return add;
    }

    @PutMapping(value={"{id}"})
    public RestResult update(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="id") Integer id, @RequestBody Goods goods) {
        log.info("\u66f4\u65b0\u6570\u636e\u5165\u53c2:merchantId:[{}],goods:[{}]", (Object)merchantId, JSON.toJSON((Object)goods));
        LoginUser loginUser = this.loginUtil.getLoginUser(this.request);
        log.info("GoodsController#update loginUser:{}", (Object)JSON.toJSONString((Object)loginUser));
        goods.setMerchantId(merchantId);
        goods.setAccountCode(loginUser.getAccountCode());
        goods.setNickName(loginUser.getNickName());
        log.info("\u5904\u7406\u5b8c\u6210\u7684\u66f4\u65b0\u6570\u636e:[{}]", JSON.toJSON((Object)goods));
        int update = 0;
        try {
            update = this.goodsService.update((Serializable)goods);
            log.info("goodsInfo:{}", (Object)goods.getIsUniform());
            if (goods.getIsUniform() == null) {
                this.scheduledThreadPoolExecutor.execute(() -> {
                    log.info("startAddCategoryAndGoodRelation relation:{}", (Object)JSON.toJSONString((Object)goods.getCustomizationGoodRelation()));
                    CustomizationCategoryAndGoodRelationAddRequestVO categoryAndGoodRelationAddRequestVO = new CustomizationCategoryAndGoodRelationAddRequestVO();
                    categoryAndGoodRelationAddRequestVO.setGoodId(goods.getId());
                    categoryAndGoodRelationAddRequestVO.setCustomizationGoodRelation(goods.getCustomizationGoodRelation());
                    if (!CollectionUtils.isEmpty((Collection)goods.getCustomizationGoodRelation())) {
                        for (CustomizationGoodRelationAddRequestVO relationAddRequestVO : goods.getCustomizationGoodRelation()) {
                            categoryAndGoodRelationAddRequestVO.setCategoryIds(relationAddRequestVO.getCustomizationCategoryId());
                            categoryAndGoodRelationAddRequestVO.setCustomizationRelationId(relationAddRequestVO.getCustomizationRelationId());
                            this.customizationService.addCategoryAndGoodsRelation(categoryAndGoodRelationAddRequestVO);
                        }
                    } else {
                        this.customizationService.addCategoryAndGoodsRelation(categoryAndGoodRelationAddRequestVO);
                    }
                });
            }
        }
        catch (Exception e) {
            log.warn("\u66f4\u65b0\u5546\u54c1\u5931\u8d25:msg:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallAdminException(e.getMessage());
        }
        this.goodsSyncChildService.modifyChildMerchantStatus(goods);
        return update < 1 ? RestResult.fail() : RestResult.success();
    }

    @GetMapping(value={"{id}"})
    public Goods getGoodsById(@PathVariable(value="id") Integer id) {
        return (Goods)this.goodsService.findById(id);
    }

    @Page
    @GetMapping
    public PageInfo list(@RequestHeader(value="merchantId") Integer merchantId, Goods goods) {
        log.info("\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5165\u53c2:merchantId:[{}],goods:[{}] ", (Object)merchantId, JSON.toJSON((Object)goods));
        if (goods.getSecondClassifyId() != null) {
            goods.setClassifyId(goods.getSecondClassifyId());
        }
        goods.setMerchantId(merchantId);
        PageInfo goodsPageInfo = this.goodsService.selectGoodsList(goods);
        return goodsPageInfo;
    }

    @GetMapping(value={"getMainMallGoods"})
    public PageInfo listForMainMall(@RequestHeader(value="merchantId") Integer merchantId, GoodsCopyVO goods) throws Exception {
        log.info("\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5165\u53c2:merchantId:[{}],goods:[{}] ", (Object)merchantId, JSON.toJSON((Object)goods));
        goods.setMerchantId(merchantId);
        return this.goodsService.selectGoodsListByChildSync(goods);
    }

    @Page
    @GetMapping(value={"listForActivity"})
    public PageInfo listForActivity(@RequestHeader(value="merchantId") Integer merchantId, Goods goods) {
        log.info("\u6d3b\u52a8\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5165\u53c2:merchantId:[{}],goods:[{}]", (Object)merchantId, JSON.toJSON((Object)goods));
        goods.setMerchantId(merchantId);
        List list = this.goodsService.findByConditionForActivity(goods);
        PageInfo goodsPageInfo = new PageInfo(list);
        goodsPageInfo = this.goodsService.goodsAddClassifyName(goodsPageInfo);
        return goodsPageInfo;
    }

    @PutMapping(value={"updateShelved"})
    public RestResult updateShelved(@RequestBody List<Goods> goodsList, Integer checked) {
        log.info("\u6279\u91cf\u4e0a\u4e0b\u67b6\u5165\u53c2:goodsList[{}],checked:[{}]", JSON.toJSON(goodsList), (Object)checked);
        this.goodsService.updateShelved(goodsList, checked);
        return RestResult.success();
    }

    @RequestMapping(value={"/updateGoodsSales"}, method={RequestMethod.POST})
    public RestResult updateGoodsSales(@RequestBody List<UpdateSalesEntity> salesEntities, @RequestHeader(value="merchantId") Integer merchantId) {
        log.info("\u5546\u54c1\u4ef7\u683c\u6279\u91cf\u66f4\u65b0 param :{}", salesEntities);
        LoginUser loginUser = this.loginUtil.getLoginUser(this.request);
        log.info("GoodsController#updateGoodsSales loginUser:{}", (Object)JSON.toJSONString((Object)loginUser));
        ArrayList<Goods> goods = new ArrayList<Goods>();
        int roundCeiling = 0;
        int digit = 0;
        for (UpdateSalesEntity saleCheck : salesEntities) {
            Goods good = new Goods();
            log.info("param :{}", (Object)saleCheck);
            if (UpdateType.METHOD_TYPE_ZERO.equals(saleCheck.getMethodType())) {
                good.setSalePrice(saleCheck.getNewSale());
                good.setId(saleCheck.getGoodsId());
                good.setMerchantId(merchantId);
                good.setAccountCode(loginUser.getAccountCode());
                good.setNickName(loginUser.getNickName());
                goods.add(good);
                continue;
            }
            if (UpdateType.METHOD_TYPE_ONE.equals(saleCheck.getMethodType())) {
                roundCeiling = UpdateType.SALES_EVALUATION_TWO.equals(saleCheck.getSaleEvaluation()) ? 1 : (UpdateType.SALES_EVALUATION_ONE.equals(saleCheck.getSaleEvaluation()) ? 0 : 4);
                digit = UpdateType.SALES_RESERVE_DECIMAL_ONE.equals(saleCheck.getSalesReserveDecimal()) ? 1 : 2;
                good.setId(saleCheck.getGoodsId());
                BigDecimal presentPrice = saleCheck.getPresentSale() == null ? new BigDecimal(0) : saleCheck.getPresentSale();
                BigDecimal discount = saleCheck.getSaleDiscount() == null ? new BigDecimal(100) : saleCheck.getSaleDiscount();
                discount = discount.divide(new BigDecimal(100), 2, 4);
                BigDecimal addNumber = saleCheck.getSaleAdd() == null ? new BigDecimal(0) : saleCheck.getSaleAdd();
                BigDecimal subNumber = saleCheck.getSaleSubtract() == null ? new BigDecimal(0) : saleCheck.getSaleSubtract();
                good.setSalePrice(presentPrice.multiply(discount).add(addNumber).subtract(subNumber).setScale(digit, roundCeiling));
                good.setMerchantId(merchantId);
                good.setAccountCode(loginUser.getAccountCode());
                good.setNickName(loginUser.getNickName());
                goods.add(good);
                continue;
            }
            return RestResult.fail((String)"\u9519\u8bef\u7684\u4f20\u5165\u65b9\u6cd5\u7c7b\u578b");
        }
        log.info("\u4fee\u6539\u7684\u6700\u7ec8\u7ed3\u679c\u96c6\u4e3a goods\uff1a{}", (Object)JSON.toJSONString(goods));
        return this.goodsService.updateSalePrice(goods);
    }

    @DeleteMapping(value={"{id}"})
    public RestResult delete(@PathVariable(value="id") Integer id) {
        log.info("\u5220\u9664\u5546\u54c1\u5165\u53c2:{}", (Object)id);
        return this.goodsService.delete(id) < 1 ? RestResult.fail() : RestResult.success();
    }

    @Page
    @GetMapping(value={"goods-stock"})
    public PageInfo<Goods> goodsStock(@RequestHeader(value="merchantId") Integer merchantId, Goods goods) {
        log.info("\u67e5\u8be2\u5546\u54c1\u5e93\u5b58:merchantId:{},goods:{}", (Object)merchantId, (Object)goods);
        goods.setMerchantId(merchantId);
        List list = this.goodsService.goodsStock(goods);
        return new PageInfo(list);
    }

    @GetMapping(value={"gift/{goodsNo}"})
    public Goods selectGiftByGoodsNo(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="goodsNo") String goodsNo) {
        return this.goodsService.findGiftByNo(merchantId, goodsNo);
    }

    @GetMapping(value={"goodsStatistical"})
    public PageInfo<GoodsStatisticalDTO> goodsStatisticalList(@RequestHeader(value="merchantId") Integer merchantId, Goods goods) {
        goods.setMerchantId(merchantId);
        DateUtil dateUtil = new DateUtil();
        String currentTime = dateUtil.getCurrentTime();
        String strDateByDay = DateUtil.getStrDateByDay((String)"30");
        if (goods.getBeginDate() == null) {
            goods.setBeginDate(DateUtil.stringToDate((String)strDateByDay, (String)"yyyy-MM-dd"));
        }
        if (goods.getEndDate() == null) {
            goods.setEndDate(DateUtil.stringToDate((String)currentTime, (String)"yyyy-MM-dd"));
        }
        Date begin = ConvertDateUtils.getConvertDate((Date)goods.getBeginDate(), (String)" 00:00:00");
        Date end = ConvertDateUtils.getConvertDate((Date)goods.getEndDate(), (String)" 23:59:59");
        goods.setBeginDate(begin);
        goods.setEndDate(end);
        return this.goodsService.goodsStatisticalList(goods, Boolean.TRUE);
    }

    @GetMapping(value={"goodsNo/{goodsNo}"})
    public Goods selectByGoodsNo(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="goodsNo") String goodsNo) {
        log.info("\u6839\u636e\u5546\u54c1\u7f16\u53f7\u67e5\u8be2\u5546\u54c1:merchantId:[{}],goodsNo:[{}]", (Object)merchantId, (Object)goodsNo);
        Goods goods = new Goods();
        goods.setMerchantId(merchantId);
        goods.setGoodsNo(goodsNo);
        return this.goodsService.selectByGoodsNo(goods);
    }

    @GetMapping(value={"goodsListExport"})
    public void goodsListExport(String key, Goods goods, HttpServletResponse res) {
        log.info("goodsListExport key:{}Goods:{}", (Object)key, (Object)JSON.toJSONString((Object)goods));
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)("download_key:" + key));
        if (Strings.isBlank((String)value)) {
            log.info("redisKeyEmpty");
            return;
        }
        if (goods.getMerchantId() == null) {
            log.info("merchantIdEmpty");
            return;
        }
        goods.setMerchantId(goods.getMerchantId());
        List list = this.goodsService.findByCondition((Serializable)goods);
        for (Goods g : list) {
            if (g.getIsGift() == 1) {
                if (g.getIsShelved().booleanValue()) {
                    g.setOutStatus("\u4e0a\u67b6\uff08\u8d60\u54c1)");
                    continue;
                }
                g.setOutStatus("\u4e0b\u67b6\uff08\u8d60\u54c1)");
                continue;
            }
            if (g.getIsShelved().booleanValue()) {
                g.setOutStatus("\u4e0a\u67b6");
                continue;
            }
            g.setOutStatus("\u4e0b\u67b6");
        }
        String[] heads = new String[]{"\u5546\u54c1\u7f16\u53f7", "\u5546\u54c1\u540d\u79f0", "\u552e\u4ef7", "\u540a\u724c\u4ef7", "\u5546\u54c1\u6807\u7b7e", "\u5b9e\u9645\u9500\u91cf", "\u4e0a\u67b6\u72b6\u6001"};
        String[] fields = new String[]{"goodsNo", "goodsName", "salePrice", "marketPrice", "tagName", "actualSales", "outStatus"};
        try {
            HSSFWorkbook hssfWorkbook = ExcelHelper.exportFromList((List)list, (String[])heads, (String[])fields, Goods.class);
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u5546\u54c1\u5217\u8868.xls", "UTF-8"));
            hssfWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @GetMapping(value={"goodStockListExport"})
    public void goodStockListExport(String key, Goods goods, HttpServletResponse res) {
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)("download_key:" + key));
        if (Strings.isBlank((String)value)) {
            return;
        }
        goods.setMerchantId(goods.getMerchantId());
        List list = this.goodsService.goodsStock(goods);
        HashMap<String, DataConvert> map = new HashMap<String, DataConvert>();
        map.put("isShelved", (v, o) -> o.getIsShelved() != false ? "\u5df2\u4e0a\u67b6" : "\u672a\u4e0a\u67b6");
        map.put("isGift", (v, o) -> o.getIsGift() == 1 ? "\u662f" : "\u5426");
        String[] heads = new String[]{"\u5546\u54c1\u7f16\u7801", "SKU\u7f16\u7801", "\u5546\u54c1\u540d\u79f0", "\u9500\u552e\u4ef7", "\u540a\u724c\u4ef7", "\u5f53\u524d\u5e93\u5b58", "\u662f\u5426\u8d60\u54c1", "\u4e0a\u67b6\u72b6\u6001", "\u521b\u5efa\u65f6\u95f4"};
        String[] fields = new String[]{"goodsNo", "skuNo", "goodsName", "salePrice", "marketPrice", "stock", "isGift", "isShelved", "gmtCreate"};
        try {
            HSSFWorkbook hssfWorkbook = ExcelHelper.exportFromList((List)list, map, (String[])heads, (String[])fields, Goods.class);
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u5e93\u5b58\u5217\u8868.xls", "UTF-8"));
            hssfWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @GetMapping(value={"goodsStatisticalExport"})
    public void goodsStatisticalExport(String key, Goods goods, HttpServletResponse res) {
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)("download_key:" + key));
        if (Strings.isBlank((String)value)) {
            return;
        }
        goods.setMerchantId(goods.getMerchantId());
        List list = this.goodsService.goodsStatisticalList(goods, Boolean.FALSE).getList();
        String[] heads = new String[]{"\u5546\u54c1\u7f16\u53f7", "\u6210\u4ea4\u4ef6\u6570", "\u9500\u91cf\u91d1\u989d", "\u6536\u85cf\u91cf", "\u52a0\u5165\u8d2d\u7269\u8f66\u6570\u91cf", "\u552e\u4ef7\u5747\u4ef7"};
        String[] fields = new String[]{"goodsNo", "quantity", "amount", "countCollect", "countCar", "avgPrice"};
        try {
            HSSFWorkbook hssfWorkbook = ExcelHelper.exportFromList((List)list, (String[])heads, (String[])fields, GoodsStatisticalDTO.class);
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u5546\u54c1\u7edf\u8ba1.xls", "UTF-8"));
            hssfWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @GetMapping(value={"getAllTag"})
    public List<GoodsTag> getAllTag(@RequestHeader(value="merchantId") Integer merchantId) {
        Example example = new Example(GoodsTag.class);
        example.orderBy("sort").asc();
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId);
        return this.goodsTagMapper.selectByExample((Object)example);
    }

    @GetMapping(value={"classifyLookGoods"})
    public PageInfo<Goods> lookGoodsByClassifyName(@RequestHeader(value="merchantId") Integer merchantId, GoodsQueryDTO goodsQueryDTO) {
        log.info("\u6839\u636e\u4ea7\u54c1\u5206\u7c7b\u540d\u79f0\u6761\u4ef6\u67e5\u8be2 params:{}", JSON.toJSON((Object)goodsQueryDTO));
        if (goodsQueryDTO.getClassifyId() == null) {
            goodsQueryDTO.setClassifyId(goodsQueryDTO.getFirstClassifyId());
        }
        if (goodsQueryDTO.getPageIndex() == null || goodsQueryDTO.getPageSize() == null) {
            return null;
        }
        goodsQueryDTO.setMerchantId(merchantId);
        return this.goodsService.getGoodListByClassifyName((Object)goodsQueryDTO);
    }

    @ApiOperation(value="\u5bfc\u5165\u5546\u54c1\u7f16\u7801\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @ResponseBody
    public ResponseData queryGoodList(@RequestBody ImportVO importVO, @RequestHeader(value="merchantId") Integer merchantId) {
        ResponseData responseData;
        log.info("GoodsController_queryGoodList");
        importVO.setMerchantId(merchantId);
        try {
            responseData = this.importService.goodsNoImport(importVO, this.request);
        }
        catch (Exception e) {
            log.info("\u5546\u54c1\u7f16\u7801\u5bfc\u5165\u5931\u8d25:{}", (Throwable)e);
            responseData = ResponseUtil.getFailedMsg((String)"\u5546\u54c1\u7f16\u7801\u5bfc\u5165\u5931\u8d25!");
        }
        return responseData;
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u5546\u54c1\u5206\u7ec4")
    @PutMapping(value={"groud"})
    public ResponseData batchUpdateGroud(@RequestBody GoodsGroudVO goodsGroudVos, @RequestHeader(value="merchantId") Integer merchantId) {
        log.info("GoodsController_UpdateGroud\uff1a\u53c2\u6570\uff1a" + JSONArray.toJSONString((Object)goodsGroudVos));
        this.goodsService.batchUpdateGroud(goodsGroudVos, merchantId);
        return ResponseUtil.getResponseData();
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u5546\u54c1\u5206\u7c7b")
    @PutMapping(value={"classification"})
    public ResponseData batchUpdateClassification(@RequestBody GoodsClassificationVO goodsClassificationVO, @RequestHeader(value="merchantId") Integer merchantId) {
        log.info("GoodsController_batchUpdateClassification\uff1a\u53c2\u6570\uff1a" + JSONArray.toJSONString((Object)goodsClassificationVO));
        this.goodsService.batchUpdateClassification(goodsClassificationVO, merchantId);
        return ResponseUtil.getResponseData();
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u5546\u54c1\u6807\u7b7e")
    @PutMapping(value={"tag"})
    public ResponseData batchUpdateTag(@RequestBody GoodsTagVO goodsTagVO, @RequestHeader(value="merchantId") Integer merchantId) {
        log.info("GoodsController_batchUpdateTag\uff1a\u53c2\u6570\uff1a" + JSONArray.toJSONString((Object)goodsTagVO));
        this.goodsService.batchUpdateTag(goodsTagVO, merchantId);
        return ResponseUtil.getResponseData();
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u5546\u54c1\u8fd0\u8d39\u6a21\u677f")
    @PutMapping(value={"template"})
    public ResponseData batchUpdateExpressTemplate(@RequestBody GoodsExpressTemplateVO goodsExpressTemplateVO, @RequestHeader(value="merchantId") Integer merchantId) {
        log.info("GoodsController_batchUpdateExpressTemplate\uff1a\u53c2\u6570\uff1a" + JSONArray.toJSONString((Object)goodsExpressTemplateVO));
        this.goodsService.batchUpdateExpressTemplate(goodsExpressTemplateVO, merchantId);
        return ResponseUtil.getResponseData();
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u5546\u54c1\u914d\u9001\u65b9\u5f0f")
    @PutMapping(value={"batchModifyDispatchingType"})
    public ResponseData batchModifyDispatchingType(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody BatchModifyDispatchingTypeVO batchModifyDispatchingTypeVO) {
        log.info("GoodsController_batchModifyDispatchingType\uff1a\u53c2\u6570\uff1a[{}]_[{}]", (Object)merchantId, (Object)JSONArray.toJSONString((Object)batchModifyDispatchingTypeVO));
        try {
            batchModifyDispatchingTypeVO.setMerchantId(merchantId);
            this.goodsNewService.batchModifyDispatchingType(batchModifyDispatchingTypeVO);
        }
        catch (Exception e) {
            return new ResponseData(100, e.getMessage());
        }
        return ResponseUtil.getResponseData();
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u5546\u54c1\u670d\u52a1\u8bf4\u660e")
    @PutMapping(value={"batchModifyDesc"})
    public ResponseData batchModifyDesc(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody BatchModifyDescRequestVO batchModifyDescRequestVO) {
        log.info("GoodsController_batchModifyDesc\uff1a\u53c2\u6570\uff1a[{}]_[{}]", (Object)merchantId, (Object)JSONArray.toJSONString((Object)batchModifyDescRequestVO));
        try {
            batchModifyDescRequestVO.setMerchantId(merchantId);
            this.goodsNewService.batchModifyDesc(batchModifyDescRequestVO);
        }
        catch (Exception e) {
            return new ResponseData(100, e.getMessage());
        }
        return ResponseUtil.getResponseData();
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u5546\u54c1\u5c5e\u6027")
    @PutMapping(value={"batchProp"})
    public ResponseData batchProp(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody PropValueVO propValueVO) {
        log.info("GoodsController__batchProp:{}", (Object)JSON.toJSONString((Object)propValueVO));
        propValueVO.setMerchantId(merchantId);
        this.goodsNewService.batchProp(propValueVO);
        return ResponseUtil.getResponseData();
    }
}

