/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.wmeimob.fastboot.bizvane.entity.GoodsClassify;
import com.wmeimob.fastboot.bizvane.service.GoodsClassifyService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.vo.GoodsClassifyShowVO;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"goods-classify"})
public class GoodsClassifyController {
    private static final Logger log = LoggerFactory.getLogger(GoodsClassifyController.class);
    @Autowired
    private GoodsClassifyService goodsClassifyService;

    @GetMapping
    public Map<String, Object> list(@RequestHeader(value="merchantId") Integer merchantId) {
        GoodsClassify[] array = this.goodsClassifyService.findByAll(merchantId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", 0);
        map.put("msg", "ok");
        map.put("data", array);
        return map;
    }

    @GetMapping(value={"{id}"})
    public List<GoodsClassify> selectListByPid(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="id") Integer id) {
        return this.goodsClassifyService.selectListByPid(merchantId, id);
    }

    @PostMapping
    public RestResult insertGoodsClassify(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody GoodsClassify goodsClassify) {
        goodsClassify.setMerchantId(merchantId);
        try {
            GoodsClassify goodsClassify2 = (GoodsClassify)this.goodsClassifyService.add((Serializable)goodsClassify);
        }
        catch (Exception e) {
            log.warn("\u65b0\u589e\u5206\u7c7b\u5931\u8d25msg:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallAdminException(e.getMessage());
        }
        return RestResult.success();
    }

    @PutMapping
    public RestResult updateGoodsClassify(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody GoodsClassify goodsClassify) {
        goodsClassify.setMerchantId(merchantId);
        int result = 0;
        try {
            result = this.goodsClassifyService.update((Serializable)goodsClassify);
        }
        catch (Exception e) {
            log.warn("\u7f16\u8f91\u5206\u7c7b\u5931\u8d25:msg:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallAdminException(e.getMessage());
        }
        return result > 0 ? RestResult.success() : RestResult.fail();
    }

    @DeleteMapping(value={"{id}"})
    public RestResult deleteGoodsClassify(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="id") Integer id) {
        GoodsClassify goodsClassify = new GoodsClassify();
        goodsClassify.setId(id);
        int result = this.goodsClassifyService.delete(merchantId, (Serializable)goodsClassify);
        return result > 0 ? RestResult.success() : RestResult.fail();
    }

    @PostMapping(value={"modifyShow"})
    public ResponseData deleteGoodsClassify(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody GoodsClassifyShowVO request) {
        Integer id = request.getId();
        Integer isShow = request.getIsShow();
        ResponseData responseData = this.goodsClassifyService.modifyShow(merchantId, id, isShow);
        return responseData;
    }
}

