/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.service.courier.CourierNewService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.courier.AddCourierRequestVO;
import com.wmeimob.fastboot.bizvane.vo.logistics.QueryCourierCompanyListRequestVO;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.core.rest.RestResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"courier"})
public class CourierController {
    private static final Logger log = LoggerFactory.getLogger(CourierController.class);
    @Autowired
    private CourierNewService courierNewService;

    @PostMapping
    public ResponseData add(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody AddCourierRequestVO addCourierRequestVo) {
        log.info("CourierController#add:[{}]_[{}]", (Object)merchantId, (Object)JSON.toJSONString((Object)addCourierRequestVo));
        try {
            addCourierRequestVo.setMerchantId(merchantId);
            this.courierNewService.addCourierCompany(addCourierRequestVo);
            return ResponseUtil.getResponseData();
        }
        catch (Exception e) {
            log.warn("\u65b0\u589e\u5feb\u9012\u516c\u53f8\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return ResponseUtil.getFailedMsg((String)e.getMessage());
        }
    }

    @PutMapping(value={"{id}"})
    public ResponseData update(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="id") Integer id, @RequestBody AddCourierRequestVO updateCourierRequestVO) {
        log.info("CourierController#update:[{}]_[{}]", (Object)merchantId, (Object)JSON.toJSONString((Object)updateCourierRequestVO));
        try {
            updateCourierRequestVO.setId(id);
            updateCourierRequestVO.setMerchantId(merchantId);
            this.courierNewService.updateCourierCompany(updateCourierRequestVO);
            return ResponseUtil.getResponseData();
        }
        catch (Exception e) {
            log.warn("\u66f4\u65b0\u5feb\u9012\u516c\u53f8\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return ResponseUtil.getFailedMsg((String)e.getMessage());
        }
    }

    @DeleteMapping(value={"{id}"})
    public RestResult delete(@PathVariable(value="id") Integer id) {
        log.info("CourierController#delete==>id=:{}", (Object)JSON.toJSONString((Object)id));
        try {
            int deleteCount = this.courierNewService.deleteCourierCompany(id);
            return deleteCount > 0 ? RestResult.success() : RestResult.fail();
        }
        catch (Exception e) {
            log.warn("\u5220\u9664\u5feb\u9012\u516c\u53f8\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return RestResult.fail((String)e.getMessage());
        }
    }

    @GetMapping
    public PageInfo list(@RequestHeader(value="merchantId") Integer merchantId, QueryCourierCompanyListRequestVO queryCourierCompanyListRequestVo) {
        log.info("CourierController#list:{}", (Object)JSON.toJSONString((Object)queryCourierCompanyListRequestVo));
        try {
            queryCourierCompanyListRequestVo.setMerchantId(merchantId);
            return this.courierNewService.queryCourierCompanyList(queryCourierCompanyListRequestVo);
        }
        catch (Exception e) {
            log.warn("\u67e5\u8be2\u5feb\u9012\u516c\u53f8\u5217\u8868\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallAdminException("\u67e5\u8be2\u5feb\u9012\u516c\u53f8\u5217\u8868\u5f02\u5e38:" + e.getMessage());
        }
    }
}

