/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.entity.Activity;
import com.wmeimob.fastboot.bizvane.entity.CheckGood;
import com.wmeimob.fastboot.bizvane.service.ActivitySanService;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.core.annotation.Page;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"activitySan"})
public class ActivitySanController {
    private static final Logger log = LoggerFactory.getLogger(ActivitySanController.class);
    @Autowired
    private ActivitySanService activitySanService;
    @Resource(name="commonConfigService")
    private ConfigService configService;

    @GetMapping(value={"/getActivitySanList"})
    @Page
    public PageInfo getActivitySanList(@RequestHeader(value="merchantId") Integer merchantId, @RequestParam(value="type") String type) {
        List list = this.activitySanService.getActivitySanList(type, merchantId);
        return new PageInfo(list);
    }

    @PostMapping(value={"/saveActivitySan"})
    public RestResult saveActivitySan(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody Activity activity) {
        log.info("\u4fdd\u5b58\u6d3b\u52a8  param\uff1a{} \u54c1\u724cid:{}", JSON.toJSON((Object)activity), (Object)merchantId);
        InputValidator.checkEmpty((Collection)activity.getActivityRuleList(), (String)"\u6d3b\u52a8\u89c4\u5219");
        activity.setMerchantId(merchantId);
        if (activity.getId() == null) {
            log.info("\u65b0\u589e\u6d3b\u52a8\u3002\u3002\u3002");
            this.activitySanService.addActivitySan(activity);
        } else {
            if (StringUtils.isEmpty((Object)activity.getId())) {
                return RestResult.fail((String)"\u6d3b\u52a8id\u4e3a\u7a7a");
            }
            log.info("\u4fee\u6539\u6d3b\u52a8\u3002\u3002\u3002");
            this.activitySanService.updateActivity(activity);
        }
        return RestResult.success();
    }

    @GetMapping(value={"/getActivityById"})
    public Activity getActivityById(@RequestParam(value="activityId") Integer activityId) {
        log.info("\u83b7\u53d6\u6d3b\u52a8\u8be6\u60c5,id:{}", (Object)activityId);
        return this.activitySanService.getActivityById(activityId);
    }

    @GetMapping(value={"/deleteActivityById"})
    public RestResult deleteActivityById(@RequestParam(value="activityId") Integer activityId) {
        log.info("\u5220\u9664\u6d3b\u52a8,id:{}", (Object)activityId);
        if (StringUtils.isEmpty((Object)activityId)) {
            return RestResult.fail((String)"\u6d3b\u52a8id\u4e3a\u7a7a");
        }
        int result = this.activitySanService.deleteActivity(activityId);
        return result > 0 ? RestResult.success() : RestResult.fail();
    }

    @RequestMapping(value={"/checkGoodInActivity"}, method={RequestMethod.POST})
    public RestResult checkGoodInActivity(@RequestBody CheckGood goods) {
        log.info("\u8fdb\u5165\u5546\u54c1\u662f\u5426\u8fdb\u884c\u6d3b\u52a8\u68c0\u67e5 param:{}", JSON.toJSON((Object)goods));
        if (goods.getGoodsList().size() == 0) {
            return RestResult.fail();
        }
        List activityGoods = this.activitySanService.checkGoodInActivity(goods.getGoodsList());
        HashMap<String, List> result = new HashMap<String, List>();
        result.put("goodList", activityGoods);
        return RestResult.success(result);
    }
}

