/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.entity.Activity;
import com.wmeimob.fastboot.bizvane.enums.activity.ActivityDiscountEnum;
import com.wmeimob.fastboot.bizvane.service.ActivityService;
import com.wmeimob.fastboot.bizvane.service.activity.ActivityDiscountService;
import com.wmeimob.fastboot.bizvane.vo.activity.discount.ActivityDiscountInfoResponseVO;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.core.annotation.Page;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"activity"})
public class ActivityController {
    private static final Logger log = LoggerFactory.getLogger(ActivityController.class);
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivityDiscountService activityDiscountService;

    @PostMapping
    public RestResult insetActivity(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody Activity activity) {
        activity.setMerchantId(merchantId);
        this.activityService.add((Serializable)activity);
        return RestResult.success();
    }

    @PutMapping(value={"{id}"})
    public RestResult updateActivity(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="id") Integer id, @RequestBody Activity activity) {
        activity.setMerchantId(merchantId);
        int result = this.activityService.update((Serializable)activity);
        return result > 0 ? RestResult.success() : RestResult.fail();
    }

    @DeleteMapping(value={"{id}"})
    public RestResult deleteActivity(@PathVariable(value="id") Integer id) {
        int result = this.activityService.delete(id);
        return result > 0 ? RestResult.success() : RestResult.fail();
    }

    @DeleteMapping(value={"deleteGoodsById/{id}"})
    public RestResult deleteGoodsById(@PathVariable(value="id") Integer id) {
        int result = this.activityService.deleteGoodsById(id);
        return result > 0 ? RestResult.success() : RestResult.fail();
    }

    @DeleteMapping(value={"deleteStipulationById/{id}"})
    public RestResult deleteStipulationById(@PathVariable(value="id") Integer id) {
        int result = this.activityService.deleteStipulationById(id);
        return result > 0 ? RestResult.success() : RestResult.fail();
    }

    @GetMapping
    @Page
    public PageInfo listActivity(@RequestHeader(value="merchantId") Integer merchantId, Activity activity) {
        activity.setMerchantId(merchantId);
        List list = this.activityService.findByCondition((Serializable)activity);
        return new PageInfo(list);
    }

    @GetMapping(value={"findActivityById"})
    public ActivityDiscountInfoResponseVO findActivityById(Integer id) {
        if (id == null) {
            throw new MallAdminException(ActivityDiscountEnum.EROOR_PARAMETER_ID_NULL.getMessage());
        }
        return this.activityDiscountService.findById(id);
    }
}

