/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.Activity;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.activity.PostActivityDataContainer;
import com.wmeimob.fastboot.bizvane.enums.ActivitySanEnum;
import com.wmeimob.fastboot.bizvane.po.ActivityPO;
import com.wmeimob.fastboot.bizvane.service.activity.ActivityNewService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.CombinationActivityVO;
import com.wmeimob.fastboot.bizvane.vo.activity.CombinationActivityListVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"combination"})
public class CombinationActivityController {
    private static final Logger log = LoggerFactory.getLogger(CombinationActivityController.class);
    @Autowired
    private ActivityNewService activityNewService;

    @PostMapping(value={"activity/add-update"})
    public ResponseData addOrupdateCombinationActivity(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody CombinationActivityVO combinationActivityVO) {
        log.info("CombinationActivityController_addOrupdateCombinationActivity:{}", (Object)JSON.toJSONString((Object)combinationActivityVO));
        combinationActivityVO.getActivityPO().setMerchantId(merchantId);
        combinationActivityVO.getActivityPO().setType(ActivitySanEnum.COMBINATION.getCode());
        PostActivityDataContainer dataContainer = PostActivityDataContainer.of((ActivityPO)combinationActivityVO.getActivityPO()).putWithClassKey((Object)combinationActivityVO);
        this.activityNewService.addOrupdateCombinationActivity(dataContainer);
        return ResponseUtil.getSuccessData((Object)"\u521b\u5efa\u6d3b\u52a8\u6210\u529f");
    }

    @GetMapping(value={"activity/detail/{id}"})
    public ResponseData getActivitybyId(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="id") Integer id) {
        return this.activityNewService.getActivitybyId(merchantId, id);
    }

    @DeleteMapping(value={"activity/{id}"})
    public ResponseData deleteActivity(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="id") Integer id) {
        return this.activityNewService.deleteActivity(id);
    }

    @PostMapping(value={"activity/list"})
    public ResponseData getActivityList(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody CombinationActivityListVO activityPO) {
        activityPO.setMerchantId(merchantId);
        PageInfo pageInfo = this.activityNewService.getActivityList(activityPO);
        return ResponseUtil.getSuccessData((Object)pageInfo);
    }
}

