/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.seckill.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.WxMsgResult;
import com.wmeimob.fastboot.bizvane.entity.WxMsgTemplate;
import com.wmeimob.fastboot.bizvane.enums.seckill.MarketActivitySecKillStatusEnum;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MsgWxSubScribePOMapper;
import com.wmeimob.fastboot.bizvane.po.MarketActivityPO;
import com.wmeimob.fastboot.bizvane.po.MsgWxSubScribePO;
import com.wmeimob.fastboot.bizvane.po.MsgWxSubScribePOExample;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.seckill.MarketActivitySecKillSendWxSubscribeService;
import com.wmeimob.fastboot.bizvane.utils.response.SysResponseEnum;
import com.wmeimob.fastboot.bizvane.utils.wxsubscribe.WxSubscribeSendUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MarketActivitySecKillSendWxSubscribeServiceImpl
implements MarketActivitySecKillSendWxSubscribeService {
    private static final Logger log = LoggerFactory.getLogger(MarketActivitySecKillSendWxSubscribeServiceImpl.class);
    @Resource
    private MarketActivityPOMapper marketActivityPOMapper;
    @Resource
    private MsgWxSubScribePOMapper msgWxSubScribePOMapper;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private WxSubscribeSendUtil wxSubscribeSendUtil;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public WxMsgResult sendWxSubscribe(Integer marketActivityId) {
        log.info("sendWxSubscribe marketActivityId:{}", (Object)marketActivityId);
        WxMsgResult result = new WxMsgResult();
        MarketActivityPO marketActivityPO = this.marketActivityPOMapper.selectByPrimaryKey(marketActivityId);
        log.info("marketActivityPO :{}", JSON.toJSON((Object)marketActivityPO));
        if (MarketActivitySecKillStatusEnum.HAVE_NOT_START.getCode().equals(marketActivityPO.getActivityStatusValue())) {
            log.info("\u6ee1\u8db3\u6d3b\u52a8\u672a\u5f00\u59cb,\u8fdb\u5165\u53d1\u9001\u5224\u65ad");
            MsgWxSubScribePOExample example = new MsgWxSubScribePOExample();
            example.createCriteria().andMarketActivityIdEqualTo(marketActivityId).andValidEqualTo(Boolean.TRUE);
            List msgWxSubScribePOS = this.msgWxSubScribePOMapper.selectByExample(example);
            log.info("msgWxSubScribePOS \u5217\u8868\u7ed3\u679c:{}", JSON.toJSON((Object)msgWxSubScribePOS));
            if (msgWxSubScribePOS == null || msgWxSubScribePOS.size() == 0) {
                result.setErrcode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
                result.setErrmsg("success \u65e0\u4eba\u8ba2\u9605\u6d3b\u52a8");
                return result;
            }
            for (MsgWxSubScribePO po : msgWxSubScribePOS) {
                MsgWxSubScribePO newPo;
                String accessToken;
                if (po.getSendTime() != null) continue;
                WxMsgTemplate wxMsgTemplate = new WxMsgTemplate();
                log.info("\u8be5\u8ba2\u9605\u6d88\u606f\u6ca1\u6709\u53d1\u9001\u8fc7\uff0c\u5f00\u59cb\u53d1\u9001");
                try {
                    accessToken = this.bizvaneInterface.obtainToken(po.getAppid());
                    log.info("\u83b7\u53d6\u5230\u7684\u5f53\u524dtoken\u4e3a accessToken\uff1a{}", JSON.toJSON((Object)accessToken));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.setErrmsg("accessToken is null");
                    result.setErrcode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
                    return result;
                }
                wxMsgTemplate.setPage(po.getPage());
                wxMsgTemplate.setTouser(po.getTouser());
                Map data = (Map)JSON.parseObject((String)po.getData(), Map.class);
                wxMsgTemplate.setData(data);
                wxMsgTemplate.setTemplate_id(po.getTemplateId());
                ResponseEntity responseEntity = this.wxSubscribeSendUtil.wxSubscribeMessageSend(wxMsgTemplate, accessToken);
                log.info("\u8fd4\u56de\u7ed3\u679c\u4e3a responseEntity\uff1a{}", (Object)responseEntity);
                if (responseEntity.getBody() == null) continue;
                log.info("\u8fd4\u56debody\uff1a{}", responseEntity.getBody());
                result = (WxMsgResult)JSON.parseObject((String)responseEntity.getBody().toString(), WxMsgResult.class);
                if (SysResponseEnum.SUCCESS.getCode() == result.getErrcode().intValue()) {
                    log.info("\u8fd4\u56de\u6570\u636e\u6210\u529f");
                    po.setSendTime(new Date());
                    newPo = this.createUpdate(po, result);
                } else {
                    log.info("\u8fd4\u56de\u6570\u636e\u5931\u8d25");
                    newPo = this.createUpdate(po, result);
                }
                log.info("\u66f4\u65b0\u8ba2\u9605\u6570\u636e:{}", (Object)newPo);
                this.msgWxSubScribePOMapper.updateByPrimaryKeySelective(newPo);
            }
        }
        return result;
    }

    private MsgWxSubScribePO createUpdate(MsgWxSubScribePO po, WxMsgResult wxResult) {
        MsgWxSubScribePO newPo = new MsgWxSubScribePO();
        newPo.setMsgWxSubscribeId(po.getMsgWxSubscribeId());
        newPo.setSendTime(po.getSendTime());
        newPo.setErrcode(wxResult.getErrcode().toString());
        newPo.setErrmsg(wxResult.getErrmsg());
        return newPo;
    }
}

