/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.activity.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.activity.PostActivityDataContainer;
import com.wmeimob.fastboot.bizvane.activity.PostActivityProcessorRouter;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.enums.ActivitySanEnum;
import com.wmeimob.fastboot.bizvane.enums.activity.ActivityCombinationJobStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.activity.ActivityStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.seckill.MarketActivitySecKillStatusEnum;
import com.wmeimob.fastboot.bizvane.exception.MallCommonException;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ActivityCombinationGoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ActivityPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsPOMapper;
import com.wmeimob.fastboot.bizvane.po.ActivityCombinationGoodsPO;
import com.wmeimob.fastboot.bizvane.po.ActivityCombinationGoodsPOExample;
import com.wmeimob.fastboot.bizvane.po.ActivityPO;
import com.wmeimob.fastboot.bizvane.po.GoodsPO;
import com.wmeimob.fastboot.bizvane.service.activity.ActivityNewService;
import com.wmeimob.fastboot.bizvane.utils.jobutils.XxlJobUtil;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.CombinationActivityGoodsVO;
import com.wmeimob.fastboot.bizvane.vo.CombinationActivityVO;
import com.wmeimob.fastboot.bizvane.vo.activity.CombinationActivityListVO;
import com.wmeimob.fastboot.config.MallAdminException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityNewServiceImpl
implements ActivityNewService {
    private static final Logger log = LoggerFactory.getLogger(ActivityNewServiceImpl.class);
    @Autowired
    private PostActivityProcessorRouter postActivityProcessorRouter;
    @Autowired
    private ActivityPOMapper activityPOMapper;
    @Autowired
    private ActivityCombinationGoodsPOMapper activityCombinationGoodsPOMapper;
    @Autowired
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Autowired
    private GoodsPOMapper goodsPOMapper;
    @Value(value="${spring.application.name}")
    private String appName;
    @Autowired
    private XxlJobUtil xxlJobUtil;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrupdateCombinationActivity(PostActivityDataContainer dataContainer) throws MallCommonException {
        log.info("ActivityNewServiceImpl_addOrupdateCombinationActivity:{}", (Object)JSON.toJSONString((Object)dataContainer));
        if (dataContainer.getActivityPO().getId() == null) {
            this.addCombinationActivity(dataContainer);
        } else {
            this.updateCombinationActivity(dataContainer);
        }
    }

    @Override
    public ResponseData getActivitybyId(Integer merchantId, Integer id) {
        CombinationActivityVO combinationActivityVO = new CombinationActivityVO();
        ActivityPO activityPO = this.activityPOMapper.selectByPrimaryKey(id);
        combinationActivityVO.setActivityPO(activityPO);
        ActivityCombinationGoodsPOExample activityCombinationGoodsPOExample = new ActivityCombinationGoodsPOExample();
        activityCombinationGoodsPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andActivityIdEqualTo(id).andMerchantIdEqualTo(merchantId);
        ArrayList goodsList = new ArrayList();
        List activityCombinationGoodsPOList = this.activityCombinationGoodsPOMapper.selectByExample(activityCombinationGoodsPOExample);
        activityCombinationGoodsPOList.stream().forEach(e -> {
            GoodsPO goodsPO = this.goodsPOMapper.selectByPrimaryKey(e.getGoodsId());
            List goodsSkuDetailPOList = this.goodsSkuDetailMapper.findByGoodsId(goodsPO.getId());
            CombinationActivityGoodsVO combinationActivityGoodsVO = new CombinationActivityGoodsVO();
            combinationActivityGoodsVO.setGoodsId(e.getGoodsId());
            combinationActivityGoodsVO.setGoodsName(goodsPO.getGoodsName());
            combinationActivityGoodsVO.setGoodsNo(goodsPO.getGoodsNo());
            combinationActivityGoodsVO.setImage(goodsPO.getCoverImg());
            combinationActivityGoodsVO.setCombinationPrice(e.getSalePrice());
            combinationActivityGoodsVO.setIsMainGoods(e.getIsMainGoods());
            combinationActivityGoodsVO.setIsMustSale(e.getIsMustBuy());
            combinationActivityGoodsVO.setMarketPrice(goodsPO.getSalePrice());
            if (CollectionUtils.isNotEmpty((Collection)goodsSkuDetailPOList)) {
                BigDecimal minPrice = goodsSkuDetailPOList.stream().filter(o -> o.getSalesPrice() != null).map(GoodsSkuDetail::getSalesPrice).min(BigDecimal::compareTo).get();
                combinationActivityGoodsVO.setMarketPrice(minPrice);
            }
            goodsList.add(combinationActivityGoodsVO);
        });
        combinationActivityVO.setGoodsList(goodsList);
        return ResponseUtil.getSuccessData((Object)combinationActivityVO);
    }

    @Override
    public ResponseData deleteActivity(Integer id) {
        ActivityPO activityPO = this.activityPOMapper.selectByPrimaryKey(id);
        if (MarketActivitySecKillStatusEnum.ON_GOING.getCode().equals(activityPO.getActivityStatusValue())) {
            throw new MallAdminException("\u5df2\u5f00\u59cb\u7684\u6d3b\u52a8\u4e0d\u80fd\u5220\u9664\uff01");
        }
        activityPO.setValid(Boolean.FALSE);
        this.activityPOMapper.updateByPrimaryKeySelective(activityPO);
        ActivityCombinationGoodsPOExample activityCombinationGoodsPOExample = new ActivityCombinationGoodsPOExample();
        activityCombinationGoodsPOExample.createCriteria().andMerchantIdEqualTo(activityPO.getMerchantId()).andValidEqualTo(Boolean.TRUE).andActivityIdEqualTo(activityPO.getId());
        ActivityCombinationGoodsPO activityCombinationGoodsPO = new ActivityCombinationGoodsPO();
        activityCombinationGoodsPO.setValid(Boolean.FALSE);
        activityCombinationGoodsPO.setIsDel(Boolean.TRUE);
        activityCombinationGoodsPO.setGmtModified(new Date());
        this.activityCombinationGoodsPOMapper.updateByExampleSelective(activityCombinationGoodsPO, activityCombinationGoodsPOExample);
        return ResponseUtil.getSuccessData((Object)"\u5220\u9664\u6210\u529f");
    }

    public PageInfo<CombinationActivityListVO> getActivityList(CombinationActivityListVO activityPO) {
        PageHelper.startPage((int)activityPO.getPage(), (int)activityPO.getPageSize());
        List activityPOList = this.activityPOMapper.getActivityList((ActivityPO)activityPO);
        PageInfo pageInfo = new PageInfo(activityPOList);
        log.info("\u67e5\u51fa\u7684\u7ec4\u5408\u6d3b\u52a8\u5217\u8868\uff1a{}", (Object)JSON.toJSONString((Object)pageInfo));
        return pageInfo;
    }

    @Transactional(rollbackFor={Exception.class})
    void addCombinationActivity(PostActivityDataContainer dataContainer) throws MallCommonException {
        this.postActivityProcessorRouter.beforeAddActivity(dataContainer);
        ActivityPO activityPO = this.addActvity(dataContainer);
        this.postActivityProcessorRouter.afterAddActivity(dataContainer);
        this.createCombinationActivityJob(activityPO, ActivityCombinationJobStatusEnum.ACTIVITY_COMBINATION_START_JOB, activityPO.getBeginDate());
        this.createCombinationActivityJob(activityPO, ActivityCombinationJobStatusEnum.ACTIVITY_COMBINATION_ENDED_JOB, activityPO.getEndDate());
    }

    private ActivityPO addActvity(PostActivityDataContainer dataContainer) throws MallCommonException {
        ActivityPO activityPO = dataContainer.getActivityPO();
        activityPO.setGmtCreate(new Date());
        activityPO.setValid(Boolean.TRUE);
        activityPO.setType(ActivitySanEnum.COMBINATION.getCode());
        activityPO.setActivityStatusValue(MarketActivitySecKillStatusEnum.HAVE_NOT_START.getCode());
        this.activityPOMapper.insertSelective(activityPO);
        return activityPO;
    }

    private void createCombinationActivityJob(ActivityPO activityPO, ActivityCombinationJobStatusEnum activityCombinationJobStatusEnum, Date jobTime) {
        log.info("createCombinationActivityJob merchantId:{}", (Object)JSON.toJSONString((Object)activityPO));
        String id = String.valueOf(activityPO.getId() == null ? "" : activityPO.getId());
        String jobHandler = activityCombinationJobStatusEnum.getJobHandler();
        String jobDesc = activityCombinationJobStatusEnum.getPrefix() + id + activityCombinationJobStatusEnum.getLastNameCn();
        String author = activityCombinationJobStatusEnum.getAuthor();
        String param = id;
        String appName = this.appName;
        int businessType = ActivitySanEnum.COMBINATION.getCode();
        String bizCode = id + activityCombinationJobStatusEnum.getLastName();
        this.xxlJobUtil.addJob(jobTime, jobDesc, param, author, jobHandler, businessType, bizCode, appName);
    }

    @Transactional(rollbackFor={Exception.class})
    void updateCombinationActivity(PostActivityDataContainer dataContainer) {
        this.postActivityProcessorRouter.beforeUpdateActivity(dataContainer);
        ActivityPO activityPO = this.updateActivity(dataContainer);
        this.postActivityProcessorRouter.afterUpdateActivity(dataContainer);
    }

    private ActivityPO updateActivity(PostActivityDataContainer dataContainer) {
        ActivityPO activityPO = dataContainer.getActivityPO();
        if (activityPO.getId() == null) {
            throw new MallCommonException("\u6d3b\u52a8id\u4e3a\u7a7a");
        }
        if (ActivityStatusEnum.ON.getCode().equals(activityPO.getStatus()) && MarketActivitySecKillStatusEnum.HAS_BEEN_STOP.getCode().equals(activityPO.getActivityStatusValue())) {
            activityPO.setActivityStatusValue(MarketActivitySecKillStatusEnum.ON_GOING.getCode());
        }
        if (ActivityStatusEnum.OFF.getCode().equals(activityPO.getStatus()) && MarketActivitySecKillStatusEnum.ON_GOING.getCode().equals(activityPO.getActivityStatusValue())) {
            activityPO.setActivityStatusValue(MarketActivitySecKillStatusEnum.HAS_BEEN_STOP.getCode());
        }
        this.activityPOMapper.updateByPrimaryKeySelective(activityPO);
        return this.activityPOMapper.selectByPrimaryKey(activityPO.getId());
    }
}

