/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.entity.CompanyBrandRelation;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.service.UnderLineService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.util.StringUtils;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class UnderLineServiceImpl
implements UnderLineService {
    private static final Logger log = LoggerFactory.getLogger(UnderLineServiceImpl.class);
    private final String keyStr = "bizvaneEncrypKey";
    @Autowired
    private CompanyBrandRelationMapper companyBrandRelationMapper;

    public String encode(String content) {
        try {
            byte[] keyBytes = "bizvaneEncrypKey".getBytes("utf-8");
            SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, key);
            byte[] encodeResult = cipher.doFinal(content.getBytes("utf-8"));
            return this.parseByte2HexStr(encodeResult);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String decrypt(String content) {
        try {
            byte[] raw = "bizvaneEncrypKey".getBytes("utf-8");
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, skeySpec);
            byte[] contentByte = this.parseHexStr2Byte(content);
            byte[] decodeResult = cipher.doFinal(contentByte);
            String result = new String(decodeResult, "utf-8");
            log.info("\u89e3\u5bc6\u540e\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)result);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String parseByte2HexStr(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    private byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    public static void main(String[] args) {
        UnderLineServiceImpl un = new UnderLineServiceImpl();
        String encode = un.encode("003,6717ad29-4399-475f-8493-92764b0eb70b");
        System.out.println(encode);
    }

    public void validate(String token) {
        String decrypt = this.validateToken(token);
        this.validateBrand(decrypt);
    }

    private String validateToken(String token) {
        String decrypt = this.decrypt(token);
        if (StringUtils.isEmpty((Object)decrypt) || !decrypt.contains(",")) {
            throw new CustomException("token\u9519\u8bef");
        }
        String brandCode = decrypt.split(",")[0];
        String key = decrypt.split(",")[1];
        if (StringUtils.isEmpty((Object)brandCode)) {
            throw new CustomException("\u53c2\u6570\u6709\u8bef\uff01");
        }
        if (StringUtils.isEmpty((Object)key)) {
            throw new CustomException("\u53c2\u6570\u6709\u8bef\uff01");
        }
        return decrypt;
    }

    private void validateBrand(String decrypt) {
        String brandCode = decrypt.split(",")[0];
        String key = decrypt.split(",")[1];
        if (StringUtils.isEmpty((Object)brandCode)) {
            throw new CustomException("\u53c2\u6570\u6709\u8bef\uff01");
        }
        if (StringUtils.isEmpty((Object)key)) {
            throw new CustomException("\u53c2\u6570\u6709\u8bef\uff01");
        }
        log.info("\u6821\u9a8c\u54c1\u724c\u6570\u636e\uff0cbrandCode:{}", (Object)brandCode);
        Example comExample = new Example(CompanyBrandRelation.class);
        comExample.createCriteria().andEqualTo("merchantCode", (Object)brandCode).andEqualTo("authenticationKey", (Object)key);
        CompanyBrandRelation companyBrandRelation = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOneByExample((Object)comExample);
        if (companyBrandRelation == null) {
            throw new CustomException("\u6b64\u54c1\u724c\u672a\u5728\u5fae\u5546\u57ce\u8bbe\u7f6e");
        }
        if (!companyBrandRelation.getAuthenticationKey().equals(key)) {
            throw new CustomException("key\u65e0\u6743\u9650");
        }
    }
}

