/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.CommonUtil;
import com.wmeimob.fastboot.bizvane.dto.integral.GoodSkuSpecDTO;
import com.wmeimob.fastboot.bizvane.entity.IntegralClassify;
import com.wmeimob.fastboot.bizvane.entity.IntegralConfig;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoods;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoodsSku;
import com.wmeimob.fastboot.bizvane.entity.IntegralSpec;
import com.wmeimob.fastboot.bizvane.mapper.IntegralClassifyMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralConfigMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsSkuMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralSpecMapper;
import com.wmeimob.fastboot.bizvane.service.IntegralGoodsService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service
public class IntegralGoodsServiceImpl
implements IntegralGoodsService {
    private static final Logger log = LoggerFactory.getLogger(IntegralGoodsServiceImpl.class);
    @Autowired
    private IntegralGoodsMapper integralGoodsMapper;
    @Autowired
    private IntegralGoodsSkuMapper integralGoodsSkuMapper;
    @Autowired
    private IntegralClassifyMapper integralClassifyMapper;
    @Autowired
    private IntegralSpecMapper integralSpecMapper;
    @Autowired
    private IntegralConfigMapper integralConfigMapper;

    @Transactional
    public IntegralGoods addGoods(IntegralGoods integralGoods) {
        log.info("\u5546\u54c1\u65b0\u589e\u3002\u3002\u3002  \u5165\u53c2={}", (Object)JSON.toJSONString((Object)integralGoods));
        InputValidator.checkEmpty((Object)integralGoods.getCoverImg(), (String)"\u5217\u8868\u7f29\u7565\u56fe\u5730\u5740");
        InputValidator.checkEmpty((Object)integralGoods.getBannerImgPaths(), (String)"\u5546\u54c1\u9996\u9875\u8f6e\u64ad\u56fe\u5730\u5740");
        InputValidator.checkEmpty((Collection)integralGoods.getSkus(), (String)"\u5546\u54c1sku\u5217\u8868");
        InputValidator.checkEmpty((Object)integralGoods.getUpperShelfTimeStr(), (String)"\u4e0a\u67b6\u65f6\u95f4");
        if (integralGoods.getRestrictedNum() != null) {
            InputValidator.checkNaturalNumber((Integer)integralGoods.getRestrictedNum(), (String)"\u9650\u5151\u6570\u91cf");
        }
        if (integralGoods.getExchangeStatus() == 1) {
            InputValidator.checkNaturalNumber((Integer)integralGoods.getExchangeCount(), (String)"\u6bcf\u4eba\u9650\u8d2d\u6570\u91cf");
        }
        Example example = new Example(IntegralGoods.class);
        example.createCriteria().andEqualTo("goodsNo", (Object)integralGoods.getGoodsNo()).andEqualTo("merchantId", (Object)integralGoods.getMerchantId()).andEqualTo("valid", (Object)true);
        List goodsList = this.integralGoodsMapper.selectByExample((Object)example);
        if (goodsList.size() > 0) {
            throw new CustomException("\u5546\u54c1\u7f16\u53f7\u91cd\u590d");
        }
        integralGoods.setGmtCreate(new Date());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date uppTime = sdf.parse(integralGoods.getUpperShelfTimeStr());
            integralGoods.setUpperShelfTime(uppTime);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.integralGoodsMapper.insertSelective((Object)integralGoods);
        List goodsSkuList = integralGoods.getSkus();
        for (IntegralGoodsSku sku : goodsSkuList) {
            Example skuExample = new Example(IntegralGoodsSku.class);
            skuExample.createCriteria().andEqualTo("skuNo", (Object)sku.getSkuNo()).andEqualTo("valid", (Object)Boolean.TRUE);
            IntegralGoodsSku goodsSku = (IntegralGoodsSku)this.integralGoodsSkuMapper.selectOneByExample((Object)skuExample);
            log.info("sku\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)goodsSku));
            if (goodsSku != null) {
                throw new CustomException("skuNo:" + sku.getSkuNo() + "\u91cd\u590d");
            }
            if (CommonUtil.hasChinese((String)sku.getSkuNo())) {
                throw new CustomException("\u5546\u54c1sku\u7f16\u7801\u4e0d\u80fd\u5b58\u5728\u4e2d\u6587\uff01");
            }
            sku.setGoodsId(integralGoods.getId());
            sku.setGmtCreate(new Date());
            this.integralGoodsSkuMapper.insertSelective((Object)sku);
        }
        return integralGoods;
    }

    @Transactional
    public IntegralGoods updateGoods(IntegralGoods integralGoods) {
        log.info("\u5546\u54c1\u4fee\u6539\u3002\u3002\u3002 \u5165\u53c2={}", (Object)JSON.toJSONString((Object)integralGoods));
        InputValidator.checkEmpty((Object)integralGoods.getCoverImg(), (String)"\u5217\u8868\u7f29\u7565\u56fe\u5730\u5740");
        InputValidator.checkEmpty((Object)integralGoods.getBannerImgPaths(), (String)"\u5546\u54c1\u9996\u9875\u8f6e\u64ad\u56fe\u5730\u5740");
        InputValidator.checkEmpty((Collection)integralGoods.getSkus(), (String)"\u5546\u54c1sku\u5217\u8868");
        InputValidator.checkEmpty((Object)integralGoods.getUpperShelfTimeStr(), (String)"\u4e0a\u67b6\u65f6\u95f4");
        if (integralGoods.getRestrictedNum() != null) {
            InputValidator.checkNaturalNumber((Integer)integralGoods.getRestrictedNum(), (String)"\u9650\u5151\u6570\u91cf");
        }
        if (integralGoods.getExchangeStatus() == 1) {
            InputValidator.checkNaturalNumber((Integer)integralGoods.getExchangeCount(), (String)"\u6bcf\u4eba\u9650\u8d2d\u6570\u91cf");
        }
        Example example = new Example(IntegralGoods.class);
        example.createCriteria().andEqualTo("goodsNo", (Object)integralGoods.getGoodsNo()).andEqualTo("merchantId", (Object)integralGoods.getMerchantId()).andEqualTo("valid", (Object)true).andNotEqualTo("id", (Object)integralGoods.getId());
        List goodsList = this.integralGoodsMapper.selectByExample((Object)example);
        if (goodsList.size() > 0) {
            throw new CustomException("\u5546\u54c1\u7f16\u53f7\u91cd\u590d");
        }
        integralGoods.setGmtModified(new Date());
        if (integralGoods.getSort() == null || StringUtils.isEmpty((Object)integralGoods.getSort())) {
            integralGoods.setSort(Integer.valueOf(0));
        }
        this.integralGoodsMapper.updateByPrimaryKeySelective((Object)integralGoods);
        this.integralGoodsSkuMapper.deleteSkuByGoodId(integralGoods.getId());
        List goodsSkuList = integralGoods.getSkus();
        for (IntegralGoodsSku sku : goodsSkuList) {
            Example skuExample = new Example(IntegralGoodsSku.class);
            skuExample.createCriteria().andEqualTo("skuNo", (Object)sku.getSkuNo()).andEqualTo("valid", (Object)Boolean.TRUE);
            IntegralGoodsSku goodsSku = (IntegralGoodsSku)this.integralGoodsSkuMapper.selectOneByExample((Object)skuExample);
            log.info("sku\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)goodsSku));
            if (goodsSku != null) {
                throw new CustomException("skuNo:[" + sku.getSkuNo() + "]\u91cd\u590d");
            }
            sku.setGmtCreate(new Date());
            sku.setGoodsId(integralGoods.getId());
            this.integralGoodsSkuMapper.insertSelective((Object)sku);
        }
        return integralGoods;
    }

    public List<IntegralGoods> getGoods(Integer merchantId, String column, String orderBy, String searchValue, String fromType, IntegralGoods IntegralGoods2) {
        List list;
        InputValidator.checkEmpty((Object)merchantId, (String)"\u54c1\u724cid");
        String desc = "desc";
        String pc = "pc";
        Example example = new Example(IntegralGoods.class);
        if (!StringUtils.isEmpty((Object)column) && !StringUtils.isEmpty((Object)orderBy)) {
            if (desc.equals(orderBy)) {
                example.orderBy(column).desc();
            } else {
                example.orderBy(column).asc();
            }
        } else {
            example.orderBy("sort").desc();
            example.orderBy("gmtCreate").desc();
        }
        Example.Criteria criteria = example.createCriteria();
        if (pc.equals(fromType)) {
            criteria.andEqualTo("merchantId", (Object)merchantId).andEqualTo("valid", (Object)Boolean.TRUE);
        } else {
            criteria.andEqualTo("merchantId", (Object)merchantId).andEqualTo("valid", (Object)Boolean.TRUE).andEqualTo("shelf", (Object)Boolean.TRUE);
        }
        if (!StringUtils.isEmpty((Object)searchValue)) {
            example.and().andLike("goodsNo", "%" + searchValue + "%").orLike("goodsName", "%" + searchValue + "%");
        }
        if (!StringUtils.isEmpty((Object)IntegralGoods2.getShelf())) {
            criteria.andEqualTo("shelf", (Object)IntegralGoods2.getShelf());
        }
        if (!StringUtils.isEmpty((Object)IntegralGoods2.getClassifyId())) {
            example.and().andLike("classifyId", "%" + IntegralGoods2.getClassifyId() + "%");
        }
        if (!StringUtils.isEmpty((Object)IntegralGoods2.getHot())) {
            criteria.andEqualTo("hot", (Object)IntegralGoods2.getHot());
        }
        if ((list = this.integralGoodsMapper.selectByExample((Object)example)).size() > 0) {
            for (IntegralGoods goods : list) {
                Example skuExample = new Example(IntegralGoodsSku.class);
                skuExample.createCriteria().andEqualTo("goodsId", (Object)goods.getId()).andEqualTo("valid", (Object)Boolean.TRUE);
                List skuList = this.integralGoodsSkuMapper.selectByExample((Object)skuExample);
                if (skuList.size() > 0) {
                    int stock = 0;
                    for (IntegralGoodsSku sku : skuList) {
                        stock += sku.getStock().intValue();
                    }
                    goods.setTotalStock(Integer.valueOf(stock));
                    continue;
                }
                goods.setTotalStock(Integer.valueOf(0));
            }
        }
        return list;
    }

    public IntegralGoods getGoodsById(Integer id, String type) {
        log.info("\u83b7\u53d6\u5546\u54c1\u8be6\u60c5\u3002\u3002\u3002===\u4f20\u5165\u7684id:{}", (Object)id);
        InputValidator.checkEmpty((Object)id, (String)"\u5546\u54c1id");
        String pc = "pc";
        String wx = "wx";
        Example example = new Example(IntegralGoods.class);
        example.createCriteria().andEqualTo("id", (Object)id);
        IntegralGoods integralGoods = (IntegralGoods)this.integralGoodsMapper.selectOneByExample((Object)example);
        Integer merchantId = integralGoods.getMerchantId();
        log.info("\u67e5\u8be2\u5230\u7684\u5546\u54c1\uff1a{}", (Object)JSONObject.toJSONString((Object)integralGoods));
        if (integralGoods != null) {
            Example skuExample = new Example(IntegralGoodsSku.class);
            if (pc.equals(type)) {
                skuExample.createCriteria().andEqualTo("goodsId", (Object)id).andEqualTo("valid", (Object)Boolean.TRUE);
            } else if (wx.equals(type)) {
                skuExample.createCriteria().andEqualTo("goodsId", (Object)id).andEqualTo("valid", (Object)Boolean.TRUE).andEqualTo("enabled", (Object)Boolean.TRUE);
            }
            List skuList = this.integralGoodsSkuMapper.selectByExample((Object)skuExample);
            if (skuList.size() > 0) {
                for (IntegralGoodsSku sku : skuList) {
                    ArrayList<GoodSkuSpecDTO> list = new ArrayList<GoodSkuSpecDTO>();
                    List specMainList = this.integralSpecMapper.getPidList(sku.getSpecIds());
                    for (IntegralSpec mainSpec : specMainList) {
                        GoodSkuSpecDTO goodSkuSpecDTO = new GoodSkuSpecDTO();
                        IntegralSpec specMain = (IntegralSpec)this.integralSpecMapper.selectByPrimaryKey((Object)mainSpec.getPid());
                        goodSkuSpecDTO.setMainSpec(specMain);
                        list.add(goodSkuSpecDTO);
                    }
                    for (GoodSkuSpecDTO dto : list) {
                        ArrayList<IntegralSpec> child = new ArrayList<IntegralSpec>();
                        Example specExample = new Example(IntegralSpec.class);
                        specExample.createCriteria().andCondition("id in (" + sku.getSpecIds() + ")");
                        List specList = this.integralSpecMapper.selectByExample((Object)specExample);
                        for (IntegralSpec childSpec : specList) {
                            if (!childSpec.getPid().equals(dto.getMainSpec().getId())) continue;
                            child.add(childSpec);
                        }
                        dto.setChilds(child);
                    }
                    sku.setGoodSkuSpecDetails(list);
                }
            }
            integralGoods.setSkus(skuList);
            ArrayList<IntegralClassify> integralClassifyList = new ArrayList<IntegralClassify>();
            String classifyStr = integralGoods.getClassifyId();
            if (classifyStr.contains(",")) {
                String[] classifyArray;
                for (String classify : classifyArray = classifyStr.split(",")) {
                    IntegralClassify integralClassify = (IntegralClassify)this.integralClassifyMapper.selectByPrimaryKey((Object)classify);
                    if (integralClassify == null) continue;
                    integralClassifyList.add(integralClassify);
                }
            } else {
                IntegralClassify integralClassify = (IntegralClassify)this.integralClassifyMapper.selectByPrimaryKey((Object)classifyStr);
                if (integralClassify != null) {
                    integralClassifyList.add(integralClassify);
                }
            }
            integralGoods.setClassifyList(integralClassifyList);
            if (integralGoods.getUpperShelfTime() != null) {
                String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(integralGoods.getUpperShelfTime());
                integralGoods.setUpperShelfTimeStr(time);
            }
        }
        Example example1 = new Example(IntegralConfig.class);
        example1.createCriteria().andEqualTo("merchantId", (Object)merchantId);
        List integralConfigs = this.integralConfigMapper.selectByExample((Object)example1);
        if (CollectionUtils.isEmpty((Collection)integralConfigs)) {
            log.info("\u672a\u521d\u59cb\u5316\u79ef\u5206\u5546\u57ce\u914d\u7f6e");
            return null;
        }
        Integer isWholeStore = ((IntegralConfig)integralConfigs.get(0)).getIsWholeStore();
        log.info("\u662f\u5426\u67e5\u8be2\u5168\u90e8\u95e8\u5e97\uff1a{}", (Object)isWholeStore);
        integralGoods.setIsWholeStore(isWholeStore);
        log.info("\u5546\u54c1\u8be6\u60c5\u8fd4\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)integralGoods));
        return integralGoods;
    }

    public void deleteGoods(Integer id) {
        log.info("\u5220\u9664\u5546\u54c1\u3002\u3002\u3002");
        InputValidator.checkEmpty((Object)id, (String)"\u5546\u54c1id");
        Example example = new Example(IntegralGoods.class);
        example.createCriteria().andEqualTo("id", (Object)id);
        IntegralGoods integralGoods = (IntegralGoods)this.integralGoodsMapper.selectOneByExample((Object)example);
        if (integralGoods != null) {
            if (Boolean.TRUE.equals(integralGoods.getShelf())) {
                throw new CustomException("\u4e0a\u67b6\u5546\u54c1\u4e0d\u80fd\u5220\u9664!");
            }
            Example skuExample = new Example(IntegralGoodsSku.class);
            skuExample.createCriteria().andEqualTo("goodsId", (Object)id).andEqualTo("valid", (Object)Boolean.TRUE);
            List skuList = this.integralGoodsSkuMapper.selectByExample((Object)skuExample);
            if (skuList.size() > 0) {
                for (IntegralGoodsSku sku : skuList) {
                    sku.setValid(Boolean.FALSE);
                    this.integralGoodsSkuMapper.updateByPrimaryKey((Object)sku);
                }
            }
            integralGoods.setValid(Boolean.FALSE);
            this.integralGoodsMapper.updateByPrimaryKey((Object)integralGoods);
        }
    }

    public List<IntegralGoods> getLowerGoods() {
        Example example = new Example(IntegralGoods.class);
        example.createCriteria().andEqualTo("shelf", (Object)Boolean.FALSE).andEqualTo("valid", (Object)Boolean.TRUE).andIsNotNull("upperShelfTime");
        List goods = this.integralGoodsMapper.selectByExample((Object)example);
        return goods;
    }

    public List<IntegralGoods> getHotGoods(Integer merchantId) {
        Example example = new Example(IntegralGoods.class);
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("valid", (Object)true).andEqualTo("hot", (Object)Boolean.TRUE).andEqualTo("shelf", (Object)Boolean.TRUE);
        example.setOrderByClause("sort desc");
        List list = this.integralGoodsMapper.selectByExample((Object)example);
        return list;
    }

    public List<IntegralGoods> getGoodsByClassifyId(Integer classifyId, Integer merchantId, String column, String orderBy) {
        String desc = "desc";
        Example example = new Example(IntegralGoods.class);
        if (!StringUtils.isEmpty((Object)column) && !StringUtils.isEmpty((Object)orderBy)) {
            if (desc.equals(orderBy)) {
                example.orderBy(column).desc();
            } else {
                example.orderBy(column).asc();
            }
        }
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("valid", (Object)true).andEqualTo("shelf", (Object)Boolean.TRUE).andCondition(" FIND_IN_SET(" + classifyId + ",classify_id)");
        List list = this.integralGoodsMapper.selectByExample((Object)example);
        return list;
    }

    public Integer getSkuStock(Integer skuId) {
        IntegralGoodsSku sku = (IntegralGoodsSku)this.integralGoodsSkuMapper.selectByPrimaryKey((Object)skuId);
        if (sku == null) {
            return 0;
        }
        return sku.getStock();
    }

    public int upperOrlower(Integer goodId, Boolean shelf) {
        Example example = new Example(IntegralGoods.class);
        example.createCriteria().andEqualTo("id", (Object)goodId);
        IntegralGoods goods = new IntegralGoods();
        goods.setShelf(shelf);
        if (Boolean.TRUE.equals(shelf)) {
            goods.setUpperShelfTime(new Date());
        } else {
            goods.setLowerShelfTime(new Date());
        }
        return this.integralGoodsMapper.updateByExampleSelective((Object)goods, (Object)example);
    }
}

