/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.seckill;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.dto.seckill.MarketActivitySecKillAddDTO;
import com.wmeimob.fastboot.bizvane.entity.LoginUser;
import com.wmeimob.fastboot.bizvane.enums.seckill.MarketActivitySecKillJobStatusEnum;
import com.wmeimob.fastboot.bizvane.idempotent.Idempotent;
import com.wmeimob.fastboot.bizvane.po.MarketActivityPO;
import com.wmeimob.fastboot.bizvane.service.GoodsSkuDetailService;
import com.wmeimob.fastboot.bizvane.service.admin.GoodsNewService;
import com.wmeimob.fastboot.bizvane.service.seckill.MarketActivityGoodsSecKillBuilderService;
import com.wmeimob.fastboot.bizvane.service.seckill.MarketActivitySecKillJobService;
import com.wmeimob.fastboot.bizvane.service.seckill.MarketActivitySecKillService;
import com.wmeimob.fastboot.bizvane.utils.LoginUtil;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.admin.GoodsCashSearchRequestVO;
import com.wmeimob.fastboot.bizvane.vo.admin.GoodsCashSearchResponseVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillAddRequestVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillGoodsResponseVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillModifyRequestVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillResponseVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillSearchRequestVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillSearchResponseVO;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"marketActivitySecKill"})
public class MarketActivitySecKillController {
    private static final Logger log = LoggerFactory.getLogger(MarketActivitySecKillController.class);
    @Autowired
    private LoginUtil loginUtil;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private MarketActivitySecKillService marketActivitySecKillService;
    @Autowired
    private MarketActivityGoodsSecKillBuilderService marketActivityGoodsSecKillBuilderService;
    @Autowired
    private GoodsNewService goodsNewService;
    @Autowired
    private GoodsSkuDetailService goodsSkuDetailService;
    @Autowired
    private MarketActivitySecKillJobService jobService;

    @PostMapping(value={"queryMarketActivitySecKillList"})
    public ResponseData<MarketActivitySecKillSearchResponseVO> queryMarketActivitySecKillList(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody MarketActivitySecKillSearchRequestVO requestVO) {
        log.info("MarketActivitySecKillController_queryMarketActivitySecKillList_request:{}", (Object)JSON.toJSONString((Object)requestVO));
        PageInfo<MarketActivityPO> marketActivityPOPageInfo = this.marketActivitySecKillService.queryMarketActivitySecKillListByCondition(requestVO, merchantId);
        ResponseData responseData = ResponseUtil.getSuccessData(marketActivityPOPageInfo);
        log.info("MarketActivitySecKillController_queryMarketActivitySecKillList_response:{}", (Object)JSON.toJSONString((Object)responseData));
        return responseData;
    }

    @PostMapping(value={"stopMarketActivitySecKill"})
    public ResponseData stopMarketActivitySecKill(@RequestHeader(value="merchantId") Integer merchantId, Integer marketActivityId) {
        log.info("MarketActivitySecKillController_stopMarketActivitySecKill_request:{}", (Object)JSON.toJSONString((Object)marketActivityId));
        Integer count = this.marketActivitySecKillService.stopMarketActivitySecKill(marketActivityId, merchantId);
        ResponseData responseData = ResponseUtil.getSuccessData((Object)count);
        log.info("MarketActivitySecKillController_stopMarketActivitySecKill_response:{}", (Object)JSON.toJSONString((Object)responseData));
        return responseData;
    }

    @PostMapping(value={"addMarketActivitySecKill"})
    @Idempotent(value="/addMarketActivitySecKill", expireMillis=5000L, type="ResponseData")
    public ResponseData addMarketActivitySecKill(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody MarketActivitySecKillAddRequestVO requestVO, HttpServletRequest request1) {
        MarketActivitySecKillAddDTO marketActivitySecKillAddDTO = new MarketActivitySecKillAddDTO();
        LoginUser loginUser = this.loginUtil.getLoginUser(this.request);
        marketActivitySecKillAddDTO.setRequestVO(requestVO);
        log.info("MarketActivitySecKillController_addMarketActivitySecKill_request:{}", (Object)JSON.toJSONString((Object)marketActivitySecKillAddDTO));
        ResponseData marketActivityPOResponseData = null;
        try {
            marketActivityPOResponseData = this.marketActivitySecKillService.addMarketActivitySecKill(marketActivitySecKillAddDTO, loginUser, merchantId);
            MarketActivityPO data = (MarketActivityPO)marketActivityPOResponseData.getData();
            this.jobService.createActivityJob(merchantId, data, MarketActivitySecKillJobStatusEnum.ACTIVITY_ENDED_JOB);
            this.jobService.createActivityJob(merchantId, data, MarketActivitySecKillJobStatusEnum.ACTIVITY_REMIND_JOB);
            this.jobService.createActivityJob(merchantId, data, MarketActivitySecKillJobStatusEnum.ACTIVITY_START_JOB);
        }
        catch (Exception e) {
            log.info("MarketActivitySecKillController_addMarketActivitySecKill_error:{}", (Throwable)e);
            marketActivityPOResponseData = ResponseUtil.getFailedMsg((String)("\u65b0\u589e\u8425\u9500\u6d3b\u52a8-\u79d2\u6740-\u5931\u8d25:" + e.getMessage()));
        }
        log.info("MarketActivitySecKillController_addMarketActivitySecKill_response:{}", (Object)JSON.toJSONString((Object)marketActivityPOResponseData));
        return marketActivityPOResponseData;
    }

    @PostMapping(value={"findMarketActivitySecKillOne"})
    public ResponseData findMarketActivitySecKillOne(@RequestHeader(value="merchantId") Integer merchantId, Integer marketActivityId) {
        log.info("MarketActivitySecKillController_findMarketActivitySecKillOne_request:{}", (Object)JSON.toJSONString((Object)marketActivityId));
        ResponseData<MarketActivitySecKillResponseVO> marketActivitySecKillOne = this.marketActivitySecKillService.findMarketActivitySecKillOne(marketActivityId, merchantId);
        log.info("MarketActivitySecKillController_findMarketActivitySecKillOne_response:{}", (Object)JSON.toJSONString(marketActivitySecKillOne));
        return marketActivitySecKillOne;
    }

    @PostMapping(value={"findMarketActivitySecKillGoodsOne"})
    public ResponseData findMarketActivitySecKillGoodsOne(@RequestHeader(value="merchantId") Integer merchantId, Integer marketActivityGoodsSecKillId) {
        log.info("MarketActivitySecKillController_findMarketActivitySecKillGoodsOne_request:{}", (Object)JSON.toJSONString((Object)marketActivityGoodsSecKillId));
        ResponseData<MarketActivitySecKillGoodsResponseVO> marketActivitySecKillGoodsOne = this.marketActivityGoodsSecKillBuilderService.findMarketActivitySecKillGoodsOne(marketActivityGoodsSecKillId, merchantId);
        log.info("MarketActivitySecKillController_findMarketActivitySecKillGoodsOne_response:{}", (Object)JSON.toJSONString(marketActivitySecKillGoodsOne));
        return marketActivitySecKillGoodsOne;
    }

    @PostMapping(value={"queryCashGoodsByCondition"})
    public ResponseData queryCashGoodsByCondition(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody GoodsCashSearchRequestVO requestVO) {
        log.info("MarketActivitySecKillController_queryCashGoodsByCondition_request:{}", (Object)JSON.toJSONString((Object)requestVO));
        requestVO.setMerchantId(merchantId);
        GoodsCashSearchResponseVO goodsCashSearchResponseVO = this.goodsNewService.queryCashGoodsByCondition(requestVO);
        ResponseData successData = ResponseUtil.getSuccessData((Object)goodsCashSearchResponseVO);
        log.info("MarketActivitySecKillController_queryCashGoodsByCondition_response:{}", (Object)JSON.toJSONString((Object)successData));
        return successData;
    }

    @PostMapping(value={"modifyMarketActivitySecKill"})
    public ResponseData modifyMarketActivitySecKill(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody MarketActivitySecKillModifyRequestVO requestVO) {
        log.info("MarketActivitySecKillController_modifyMarketActivitySecKill_request:{}", (Object)JSON.toJSONString((Object)requestVO));
        Integer count = this.marketActivitySecKillService.modifyMarketActivitySecKill(requestVO, merchantId);
        ResponseData successData = ResponseUtil.getSuccessData((Object)count);
        log.info("MarketActivitySecKillController_modifyMarketActivitySecKill_response:{}", (Object)JSON.toJSONString((Object)successData));
        return successData;
    }

    @PostMapping(value={"querySkuListByGoodsId"})
    public ResponseData querySkuListByGoodsId(@RequestHeader(value="merchantId") Integer merchantId, Integer goodsId) {
        log.info("MarketActivitySecKillController_querySkuListByGoodsId_request:{}", (Object)JSON.toJSONString((Object)goodsId));
        List byGoodsId = this.goodsSkuDetailService.findByGoodsId(goodsId);
        ResponseData successData = ResponseUtil.getSuccessData((Object)byGoodsId);
        log.info("MarketActivitySecKillController_querySkuListByGoodsId_response:{}", (Object)JSON.toJSONString((Object)successData));
        return successData;
    }
}

