/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.market_activity;

import com.wmeimob.fastboot.bizvane.entity.LoginUser;
import com.wmeimob.fastboot.bizvane.service.market_activity.ActivityGoodsImportService;
import com.wmeimob.fastboot.bizvane.utils.LoginUtil;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.activity.MarketActivityGoodsImportRequestVO;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"MarketActivityGoodsImport"})
public class MarketActivityGoodsImportController {
    private static final Logger log = LoggerFactory.getLogger(MarketActivityGoodsImportController.class);
    @Autowired
    private ActivityGoodsImportService activityGoodsImportService;
    @Resource
    private LoginUtil loginUtil;
    @Autowired
    private HttpServletRequest request;

    @PostMapping(value={"goodsImport"})
    public ResponseData testImport(@RequestBody MarketActivityGoodsImportRequestVO vo, @RequestHeader Integer merchantId) {
        ResponseData result = new ResponseData();
        LoginUser loginUser = this.loginUtil.getLoginUser(this.request);
        vo.setMerchantId(merchantId);
        vo.setAccountCode(loginUser.getAccountCode());
        vo.setAccountName(loginUser.getNickName());
        try {
            result = this.activityGoodsImportService.marketGoodsImport(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseUtil.getFailedMsg((String)e.getMessage());
        }
        return result;
    }
}

