/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.qdqm;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.CompanyBrandRelation;
import com.wmeimob.fastboot.bizvane.entity.LoginUser;
import com.wmeimob.fastboot.bizvane.entity.MerchantGoodsSyncLogWithBLOBs;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.mapper.MerchantGoodsSyncLogMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsPOMapper;
import com.wmeimob.fastboot.bizvane.po.GoodsPO;
import com.wmeimob.fastboot.bizvane.po.GoodsPOExample;
import com.wmeimob.fastboot.bizvane.service.qdqm.GoodsSyncChildService;
import com.wmeimob.fastboot.bizvane.service.qdqm.GoodsSyncService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.qdqm.GoodsClickRequestVO;
import com.wmeimob.fastboot.bizvane.vo.qdqm.GoodsSyncConfirmResponseVO;
import com.wmeimob.fastboot.bizvane.vo.qdqm.GoodsSyncRequestVO;
import com.wmeimob.fastboot.bizvane.vo.qdqm.GoodsSyncResponseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import tk.mybatis.mapper.entity.Example;

@Component
public class GoodsSyncServiceImpl
implements GoodsSyncService {
    private static final Logger log = LoggerFactory.getLogger(GoodsSyncServiceImpl.class);
    @Autowired
    private GoodsSyncChildService goodsSyncChildService;
    @Resource
    private CompanyBrandRelationMapper companyBrandRelationMapper;
    @Resource
    private GoodsPOMapper goodsPOMapper;
    @Resource
    private MerchantGoodsSyncLogMapper merchantGoodsSyncLogMapper;

    public ResponseData<GoodsSyncResponseVO> addGoodsSyncRecordBatch(GoodsSyncRequestVO requestVO, LoginUser loginUser) {
        Integer merchantId = requestVO.getMerchantId();
        if (merchantId == null) {
            return ResponseUtil.getFailedMsg((String)"merchantId\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        Example companyBrandRelationExample = new Example(CompanyBrandRelation.class);
        companyBrandRelationExample.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("isDefault", (Object)Boolean.FALSE);
        List companyBrandRelations = this.companyBrandRelationMapper.selectByExample((Object)companyBrandRelationExample);
        if (CollectionUtils.isEmpty((Collection)companyBrandRelations)) {
            return ResponseUtil.getFailedMsg((String)"\u5f53\u524d\u5546\u6237\u6ca1\u6709\u914d\u7f6e\u4fe1\u606f,\u6216\u975e\u4e3b\u5546\u57ce!");
        }
        CompanyBrandRelation companyBrandRelation = (CompanyBrandRelation)companyBrandRelations.get(0);
        List goodsIdList = requestVO.getGoodsIdList();
        if (CollectionUtils.isEmpty((Collection)goodsIdList)) {
            return ResponseUtil.getFailedMsg((String)"\u9009\u4e2d\u5546\u54c1\u4e3a\u7a7a,\u8fd4\u56de\u540c\u6b65\u6210\u529f\uff01");
        }
        ArrayList<GoodsPO> failGoodsResult = new ArrayList<GoodsPO>();
        ArrayList<GoodsPO> successGoodsResult = new ArrayList<GoodsPO>();
        ArrayList<GoodsPO> existGoodsResult = new ArrayList<GoodsPO>();
        ArrayList<String> errorList = new ArrayList<String>();
        for (Long goodsId : goodsIdList) {
            GoodsPO mainGoods = this.goodsPOMapper.selectByPrimaryKey(Integer.valueOf(goodsId.intValue()));
            GoodsPOExample goodsPOExample = new GoodsPOExample();
            goodsPOExample.createCriteria().andGoodsNoEqualTo(mainGoods.getGoodsNo()).andMerchantIdEqualTo(requestVO.getMerchantId()).andValidEqualTo(Boolean.TRUE).andIsDelEqualTo(Boolean.valueOf(false));
            List goodsPOList = this.goodsPOMapper.selectByExample(goodsPOExample);
            if (CollectionUtils.isNotEmpty((Collection)goodsPOList)) {
                return ResponseUtil.getFailedMsg((String)"\u5546\u57ce\u4e2d\u5df2\u5b58\u5728\u8be5\u5546\u54c1\uff0c\u8bf7\u5220\u9664\u8be5\u5546\u54c1\u518d\u91cd\u65b0\u540c\u6b65\uff01");
            }
            Boolean syncStatus = Boolean.FALSE;
            String goodsNo = mainGoods.getGoodsNo();
            GoodsPOExample goodsPOExampleChild = new GoodsPOExample();
            goodsPOExampleChild.createCriteria().andGoodsNoEqualTo(goodsNo).andMerchantIdEqualTo(merchantId).andIsDelEqualTo(Boolean.FALSE);
            List childGoods = this.goodsPOMapper.selectByExample(goodsPOExampleChild);
            if (CollectionUtils.isEmpty((Collection)childGoods)) {
                log.info("\u5546\u54c1:{}\u4e0d\u5b58\u5728,\u76f4\u63a5\u540c\u6b65\u65b0\u589e\u5546\u54c1", (Object)goodsNo);
                try {
                    this.goodsSyncChildService.syncAddGoods(mainGoods, merchantId, companyBrandRelation);
                    syncStatus = Boolean.TRUE;
                    successGoodsResult.add(mainGoods);
                }
                catch (Exception e) {
                    errorList.add("\u5546\u54c1:" + goodsNo + "\u540c\u6b65\u5931\u8d25:" + e.getMessage());
                    log.error("\u540c\u6b65\u5931\u8d25:", (Throwable)e);
                    failGoodsResult.add(mainGoods);
                }
            } else {
                existGoodsResult.add(mainGoods);
                GoodsPO childGood = (GoodsPO)childGoods.get(0);
                log.info("\u5546\u54c1:{}\u5df2\u5b58\u5728,\u8fd4\u56de\u524d\u7aef\u5f85\u786e\u8ba4,id:{}", (Object)goodsNo, (Object)childGood.getId());
            }
            Date syncDate = new Date();
            this.goodsSyncChildService.addOrModifyGoodsSyncRecord(mainGoods, merchantId, companyBrandRelation, syncStatus, syncDate);
        }
        GoodsSyncResponseVO goodsSyncResponseVO = new GoodsSyncResponseVO();
        goodsSyncResponseVO.setFailGoodsResult(failGoodsResult);
        goodsSyncResponseVO.setSuccessGoodsResult(successGoodsResult);
        goodsSyncResponseVO.setExistGoodsResult(existGoodsResult);
        ResponseData responseData = ResponseUtil.getSuccessData((Object)goodsSyncResponseVO);
        this.saveSyncLog(merchantId, (Object)JSON.toJSONString((Object)requestVO), (Object)JSON.toJSONString((Object)responseData), JSON.toJSONString(errorList), loginUser, "first");
        return responseData;
    }

    public ResponseData<GoodsSyncConfirmResponseVO> modifySyncRecordBatch(GoodsSyncRequestVO requestVO, LoginUser loginUser) {
        Integer merchantId = requestVO.getMerchantId();
        if (merchantId == null) {
            return ResponseUtil.getFailedMsg((String)"merchantId\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        Example companyBrandRelationExample = new Example(CompanyBrandRelation.class);
        companyBrandRelationExample.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("isDefault", (Object)Boolean.FALSE);
        List companyBrandRelations = this.companyBrandRelationMapper.selectByExample((Object)companyBrandRelationExample);
        if (CollectionUtils.isEmpty((Collection)companyBrandRelations)) {
            return ResponseUtil.getFailedMsg((String)"\u5f53\u524d\u5546\u6237\u6ca1\u6709\u914d\u7f6e\u4fe1\u606f,\u6216\u975e\u4e3b\u5546\u57ce!");
        }
        CompanyBrandRelation companyBrandRelation = (CompanyBrandRelation)companyBrandRelations.get(0);
        List goodsIdList = requestVO.getGoodsIdList();
        if (CollectionUtils.isEmpty((Collection)goodsIdList)) {
            return ResponseUtil.getFailedMsg((String)"\u9009\u4e2d\u5546\u54c1\u4e3a\u7a7a,\u8fd4\u56de\u540c\u6b65\u6210\u529f\uff01");
        }
        Integer successCount = 0;
        Integer failCount = 0;
        ArrayList<String> errorList = new ArrayList<String>();
        for (Long goodsId : goodsIdList) {
            Integer n;
            Integer n2;
            GoodsPO mainGoods = this.goodsPOMapper.selectByPrimaryKey(Integer.valueOf(goodsId.intValue()));
            Boolean syncStatus = Boolean.FALSE;
            String goodsNo = mainGoods.getGoodsNo();
            GoodsPOExample goodsPOExampleChild = new GoodsPOExample();
            goodsPOExampleChild.createCriteria().andGoodsNoEqualTo(goodsNo).andMerchantIdEqualTo(merchantId).andIsDelEqualTo(Boolean.FALSE);
            List childGoods = this.goodsPOMapper.selectByExample(goodsPOExampleChild);
            if (CollectionUtils.isEmpty((Collection)childGoods)) {
                log.info("\u5546\u54c1:{}\u4e0d\u5b58\u5728,\u9ed8\u8ba4\u5931\u8d25", (Object)goodsNo);
                errorList.add("\u5546\u54c1:" + goodsNo + "\u4e0d\u5b58\u5728,\u76f4\u63a5\u5931\u8d25!");
                n2 = failCount;
                n = failCount = Integer.valueOf(failCount + 1);
                syncStatus = Boolean.FALSE;
                continue;
            }
            if (!syncStatus.booleanValue()) {
                try {
                    this.goodsSyncChildService.syncModifyGoods(mainGoods, merchantId, companyBrandRelation);
                    n2 = successCount;
                    n = successCount = Integer.valueOf(successCount + 1);
                    syncStatus = Boolean.TRUE;
                }
                catch (Exception e) {
                    errorList.add("\u5546\u54c1:" + goodsNo + "\u540c\u6b65\u5931\u8d25:" + e.getMessage());
                    log.error("\u540c\u6b65\u5931\u8d25:{}", (Throwable)e);
                    n = failCount;
                    Integer n3 = failCount = Integer.valueOf(failCount + 1);
                }
            }
            Date syncDate = new Date();
            this.goodsSyncChildService.addOrModifyGoodsSyncRecord(mainGoods, merchantId, companyBrandRelation, syncStatus, syncDate);
        }
        GoodsSyncConfirmResponseVO goodsSyncConfirmResponseVO = new GoodsSyncConfirmResponseVO();
        goodsSyncConfirmResponseVO.setFailCount(failCount);
        goodsSyncConfirmResponseVO.setSuccessCount(successCount);
        ResponseData responseData = ResponseUtil.getSuccessData((Object)goodsSyncConfirmResponseVO);
        this.saveSyncLog(merchantId, (Object)JSON.toJSONString((Object)requestVO), (Object)JSON.toJSONString((Object)responseData), JSON.toJSONString(errorList), loginUser, "second");
        return responseData;
    }

    public void saveSyncLog(Integer merchantId, Object request, Object response, String errorMsg, LoginUser loginUser, String type) {
        String accountCode = loginUser.getAccountCode();
        log.info("\u65b0\u589e\u5b50\u5546\u57ce\u540c\u6b65\u8bb0\u5f55\u65e5\u5fd7\u5f00\u59cb");
        MerchantGoodsSyncLogWithBLOBs merchantGoodsSyncLog = new MerchantGoodsSyncLogWithBLOBs();
        merchantGoodsSyncLog.setMerchantId(merchantId);
        merchantGoodsSyncLog.setRequestMsg(JSON.toJSONString((Object)request));
        merchantGoodsSyncLog.setResultMsg(JSON.toJSONString((Object)response));
        merchantGoodsSyncLog.setGmtCreate(new Date());
        merchantGoodsSyncLog.setValid(Boolean.TRUE);
        merchantGoodsSyncLog.setType(type);
        merchantGoodsSyncLog.setTrace(MDC.get((String)"traceId"));
        merchantGoodsSyncLog.setErrorMsg(errorMsg);
        merchantGoodsSyncLog.setAccountcode(accountCode);
        this.merchantGoodsSyncLogMapper.insertSelective(merchantGoodsSyncLog);
        log.info("\u65b0\u589e\u5b50\u5546\u57ce\u540c\u6b65\u8bb0\u5f55\u65e5\u5fd7\u7ed3\u675f");
    }

    public ResponseData click(GoodsClickRequestVO requestVO) {
        Integer merchantId = requestVO.getMerchantId();
        Integer goodsId = requestVO.getGoodsId();
        if (merchantId == null) {
            return ResponseUtil.getFailedMsg((String)"merchantId\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        Example companyBrandRelationExample = new Example(CompanyBrandRelation.class);
        companyBrandRelationExample.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("isDefault", (Object)Boolean.FALSE);
        List companyBrandRelations = this.companyBrandRelationMapper.selectByExample((Object)companyBrandRelationExample);
        if (CollectionUtils.isEmpty((Collection)companyBrandRelations)) {
            return ResponseUtil.getFailedMsg((String)"\u5f53\u524d\u5546\u6237\u6ca1\u6709\u914d\u7f6e\u4fe1\u606f,\u6216\u975e\u4e3b\u5546\u57ce!");
        }
        CompanyBrandRelation companyBrandRelation = (CompanyBrandRelation)companyBrandRelations.get(0);
        GoodsPO mainGoods = this.goodsPOMapper.selectByPrimaryKey(goodsId);
        this.goodsSyncChildService.addOrModifyGoodsSyncRecord(mainGoods, merchantId, companyBrandRelation, Boolean.FALSE, null);
        return ResponseUtil.getSuccessData(null, (String)"\u66f4\u65b0\u70b9\u51fb\u72b6\u6001\u6210\u529f");
    }
}

