/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.customization.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.newmapper.CompanyBrandRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CustomizationByDesignerPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CustomizationCategoryPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CustomizationDetailPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CustomizationGoodsRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CustomizationRelationPOMapper;
import com.wmeimob.fastboot.bizvane.po.CustomizationCategoryPO;
import com.wmeimob.fastboot.bizvane.po.CustomizationCategoryPOExample;
import com.wmeimob.fastboot.bizvane.po.CustomizationDetailPO;
import com.wmeimob.fastboot.bizvane.po.CustomizationDetailPOExample;
import com.wmeimob.fastboot.bizvane.po.CustomizationGoodsRelationPO;
import com.wmeimob.fastboot.bizvane.po.CustomizationGoodsRelationPOExample;
import com.wmeimob.fastboot.bizvane.po.CustomizationPO;
import com.wmeimob.fastboot.bizvane.po.CustomizationPOExample;
import com.wmeimob.fastboot.bizvane.po.CustomizationRelationPO;
import com.wmeimob.fastboot.bizvane.po.CustomizationRelationPOExample;
import com.wmeimob.fastboot.bizvane.service.customization.CustomizationService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.customization.CustomizationCategoryAddRequestVO;
import com.wmeimob.fastboot.bizvane.vo.customization.CustomizationCategoryAndGoodRelationAddRequestVO;
import com.wmeimob.fastboot.bizvane.vo.customization.CustomizationCategoryDetailListAddRequestVO;
import com.wmeimob.fastboot.bizvane.vo.customization.CustomizationCategoryDetailListSearchRequestVO;
import com.wmeimob.fastboot.bizvane.vo.customization.CustomizationCategoryListSearchRequestVO;
import com.wmeimob.fastboot.bizvane.vo.customization.CustomizationSearchResponseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CustomizationServiceImpl
implements CustomizationService {
    private static final Logger log = LoggerFactory.getLogger(CustomizationServiceImpl.class);
    @Resource
    private CustomizationByDesignerPOMapper customizationByDesignerPOMapper;
    @Resource
    private CompanyBrandRelationPOMapper companyBrandRelationPOMapper;
    @Resource
    private CustomizationRelationPOMapper customizationRelationPOMapper;
    @Resource
    private CustomizationCategoryPOMapper customizationCategoryPOMapper;
    @Resource
    private CustomizationDetailPOMapper customizationDetailPOMapper;
    @Resource
    private CustomizationGoodsRelationPOMapper customizationGoodsRelationPOMapper;

    public ResponseData searchAvailableCustomizationList(Integer merchantId) {
        log.info("CustomizationServiceImpl#searchAvailableCustomizationList:{}", (Object)merchantId);
        CustomizationPOExample customizationPOExample = new CustomizationPOExample();
        customizationPOExample.createCriteria().andValidEqualTo(Boolean.TRUE);
        List customizationPOS = this.customizationByDesignerPOMapper.selectByExample(customizationPOExample);
        log.info("\u67e5\u8be2\u51fa\u53ef\u7528\u7684\u5b9a\u5236\u670d\u52a1\u5217\u8868:{}", (Object)JSON.toJSONString((Object)customizationPOS));
        if (CollectionUtils.isEmpty((Collection)customizationPOS)) {
            return ResponseUtil.getFailedMsg((String)"\u6ca1\u6709\u53ef\u7528\u7684\u5b9a\u5236\u670d\u52a1");
        }
        Iterator checkCouldUse = customizationPOS.iterator();
        while (checkCouldUse.hasNext()) {
            CustomizationPO check = (CustomizationPO)checkCouldUse.next();
            if (!check.getCustomizationLimit().booleanValue()) continue;
            if (StringUtils.isEmpty((Object)check.getCustomizationLimitBrandIds())) {
                log.info("\u8be5\u5b9a\u5236\u670d\u52a1\u9700\u8981\u6821\u9a8c\uff0c\u4f46\u662f\u6ca1\u6709\u9650\u5236brandId\u6570\u7ec4\uff0cid\uff1a{}", (Object)check.getCustomizationId());
                checkCouldUse.remove();
                continue;
            }
            Integer sysBrandId = this.companyBrandRelationPOMapper.selectBrandIdByMerchantId(merchantId);
            List list = (List)JSON.parseObject((String)check.getCustomizationLimitBrandIds(), List.class);
            log.info("\u9650\u5236\u5546\u6237\u54c1\u724c\u4f7f\u7528\u8303\u56f4\u6570\u7ec4\uff1a{}", (Object)JSON.toJSONString((Object)list));
            if (list.contains(sysBrandId)) continue;
            checkCouldUse.remove();
        }
        ArrayList<CustomizationSearchResponseVO> responseVOS = new ArrayList<CustomizationSearchResponseVO>();
        for (CustomizationPO checkRelation : customizationPOS) {
            Integer relationId;
            CustomizationRelationPOExample customizationRelationPOExample = new CustomizationRelationPOExample();
            customizationRelationPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andCustomizationIdEqualTo(checkRelation.getCustomizationId()).andMerchantIdEqualTo(merchantId);
            List customizationRelationPOS = this.customizationRelationPOMapper.selectByExample(customizationRelationPOExample);
            log.info("\u67e5\u8be2\u51fa\u7684\u5173\u8054\u5173\u7cfb\u7684\u96c6\u5408\u6570\u636e\u4e3a:{}", (Object)JSON.toJSONString((Object)customizationRelationPOS));
            if (CollectionUtils.isEmpty((Collection)customizationRelationPOS)) {
                log.info("\u5546\u6237:{}\u7b2c\u4e00\u6b21\u8fdb\u5165\uff1a{}", (Object)merchantId, (Object)checkRelation.getCustomizationName());
                CustomizationRelationPO insertPo = new CustomizationRelationPO();
                insertPo.setCustomizationId(checkRelation.getCustomizationId());
                insertPo.setGmtCreate(new Date());
                insertPo.setMerchantId(merchantId);
                log.info("\u63d2\u5165\u7684\u6570\u636e\u4e3a:{}", JSON.toJSON((Object)insertPo));
                this.customizationRelationPOMapper.insertSelective(insertPo);
                relationId = insertPo.getCustomizationRelationId();
            } else {
                relationId = ((CustomizationRelationPO)customizationRelationPOS.get(0)).getCustomizationRelationId();
            }
            CustomizationSearchResponseVO responseVO = new CustomizationSearchResponseVO();
            BeanUtils.copyProperties((Object)checkRelation, (Object)responseVO);
            responseVO.setCustomizationRelationId(relationId);
            responseVOS.add(responseVO);
        }
        return ResponseUtil.getSuccessData(responseVOS);
    }

    @Transactional
    public ResponseData updateCategory(CustomizationCategoryAddRequestVO vo) {
        log.info("CustomizationServiceImpl#updateCategory:{}", (Object)JSON.toJSONString((Object)vo));
        CustomizationRelationPOExample customizationRelationPOExample = new CustomizationRelationPOExample();
        customizationRelationPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andCustomizationRelationIdEqualTo(vo.getCustomizationRelationId());
        List customizationRelationPOS = this.customizationRelationPOMapper.selectByExample(customizationRelationPOExample);
        log.info("\u67e5\u8be2\u51fa\u7684\u5173\u8054\u5173\u7cfb\u7684\u96c6\u5408\u6570\u636e\u4e3a:{}", (Object)JSON.toJSONString((Object)customizationRelationPOS));
        if (CollectionUtils.isEmpty((Collection)customizationRelationPOS)) {
            return ResponseUtil.getFailedMsg((String)"\u6ca1\u6709\u53ef\u7528\u7684\u5b9a\u5236\u670d\u52a1");
        }
        vo.setCustomizationRelationId(((CustomizationRelationPO)customizationRelationPOS.get(0)).getCustomizationRelationId());
        if (StringUtils.isEmpty((Object)vo.getCustomizationCategoryId())) {
            CustomizationCategoryPO insertVo = new CustomizationCategoryPO();
            insertVo.setCustomizationCategoryName(vo.getCustomizationCategoryName());
            insertVo.setCustomizationRelationId(vo.getCustomizationRelationId());
            insertVo.setGmtCreate(new Date());
            int insertNum = this.customizationCategoryPOMapper.insertSelective(insertVo);
            log.info("\u63d2\u5165\u6570\u91cf:{}", (Object)insertNum);
            return ResponseUtil.getSuccessData((Object)"");
        }
        CustomizationCategoryPO updateVo = new CustomizationCategoryPO();
        updateVo.setCustomizationCategoryName(vo.getCustomizationCategoryName());
        updateVo.setCustomizationCategoryId(vo.getCustomizationCategoryId());
        int updateNum = this.customizationCategoryPOMapper.updateByPrimaryKeySelective(updateVo);
        log.info("\u63d2\u5165\u6570\u91cf:{}", (Object)updateNum);
        return ResponseUtil.getSuccessData((Object)"");
    }

    public ResponseData searchCategoryDetailList(CustomizationCategoryDetailListSearchRequestVO vo) {
        log.info("CustomizationServiceImpl#searchCategoryDetailLis vo:{}", (Object)JSON.toJSONString((Object)vo));
        CustomizationDetailPOExample searchListExample = new CustomizationDetailPOExample();
        searchListExample.createCriteria().andCustomizationCategoryIdEqualTo(vo.getCustomizationCategoryId()).andValidEqualTo(Boolean.TRUE);
        searchListExample.setOrderByClause("gmt_create desc");
        PageHelper.startPage((int)vo.getPageNum(), (int)vo.getPageSize());
        List customizationDetailPOS = this.customizationDetailPOMapper.selectByExample(searchListExample);
        PageInfo pageInfo = new PageInfo(customizationDetailPOS);
        log.info("customizationDetailPOS:{}", (Object)JSON.toJSONString((Object)customizationDetailPOS));
        return ResponseUtil.getSuccessData((Object)pageInfo);
    }

    @Transactional
    public ResponseData updateCategoryDetail(CustomizationCategoryDetailListAddRequestVO vo) {
        log.info("CustomizationServiceImpl#updateCategoryDetail vo:{}", (Object)JSON.toJSONString((Object)vo));
        ArrayList<CustomizationDetailPO> updatePos = new ArrayList<CustomizationDetailPO>();
        ArrayList<CustomizationDetailPO> insertPos = new ArrayList<CustomizationDetailPO>();
        for (CustomizationDetailPO po : vo.getDetailPOS()) {
            po.setCustomizationCategoryId(vo.getCustomizationCategoryId());
            if (po.getCustomizationDetailId() == null) {
                insertPos.add(po);
                continue;
            }
            updatePos.add(po);
        }
        if (!CollectionUtils.isEmpty(insertPos)) {
            log.info("insertPos:{}", (Object)JSON.toJSONString(insertPos));
            int insertNum = this.customizationByDesignerPOMapper.insertSelectiveDetailById(insertPos);
            log.info("\u63d2\u5165\u8be6\u60c5\u6570\u91cf:{}", (Object)insertNum);
        }
        if (!CollectionUtils.isEmpty(updatePos)) {
            log.info("updatePos:{}", (Object)JSON.toJSONString(updatePos));
            int insertNum = this.customizationByDesignerPOMapper.updateSelectiveDetailById(updatePos);
            log.info("\u4fee\u6539\u8be6\u60c5\u6570\u91cf:{}", (Object)insertNum);
        }
        return ResponseUtil.getSuccessData((Object)"\u4fee\u6539\u6210\u529f");
    }

    public boolean checkCategoryName(CustomizationCategoryAddRequestVO vo) {
        log.info("CustomizationServiceImpl#checkCategoryName:{}", (Object)JSON.toJSONString((Object)vo));
        CustomizationCategoryPOExample checkExample = new CustomizationCategoryPOExample();
        CustomizationCategoryPOExample.Criteria criteria = checkExample.createCriteria().andValidEqualTo(Boolean.TRUE).andCustomizationRelationIdEqualTo(vo.getCustomizationRelationId()).andCustomizationCategoryNameEqualTo(vo.getCustomizationCategoryName());
        if (vo.getCustomizationCategoryId() != null) {
            criteria.andCustomizationCategoryIdNotEqualTo(vo.getCustomizationCategoryId());
        }
        List result = this.customizationCategoryPOMapper.selectByExample(checkExample);
        log.info("checkCategoryName_result:{}", (Object)JSON.toJSONString((Object)result));
        return !CollectionUtils.isEmpty((Collection)result);
    }

    public ResponseData checkCategoryInUsed(Integer customizationCategoryId) {
        log.info("CustomizationServiceImpl#checkCategoryInUsed:{}", (Object)customizationCategoryId);
        CustomizationGoodsRelationPOExample checkExample = new CustomizationGoodsRelationPOExample();
        checkExample.createCriteria().andValidEqualTo(Boolean.TRUE).andCustomizationCategoryIdEqualTo(customizationCategoryId);
        List customizationGoodsRelationPOS = this.customizationGoodsRelationPOMapper.selectByExample(checkExample);
        log.info("\u4f7f\u7528\u4e2d\u7684customizationGoodsRelationPOS:{}", (Object)JSON.toJSONString((Object)customizationGoodsRelationPOS));
        if (CollectionUtils.isEmpty((Collection)customizationGoodsRelationPOS)) {
            return ResponseUtil.getSuccessData((Object)"");
        }
        return ResponseUtil.getFailedMsg((String)"\u8be5\u6837\u5f0f\u4e0b\u6709\u5173\u8054\u5546\u54c1\uff0c\u662f\u5426\u5220\u9664");
    }

    @Transactional
    public ResponseData deleteCategory(Integer customizationCategoryId) {
        log.info("CustomizationServiceImpl#deleteCategory:{}", (Object)customizationCategoryId);
        CustomizationGoodsRelationPOExample goodsRelationPOExample = new CustomizationGoodsRelationPOExample();
        goodsRelationPOExample.createCriteria().andCustomizationCategoryIdEqualTo(customizationCategoryId).andValidEqualTo(Boolean.TRUE);
        CustomizationGoodsRelationPO goodsRelationUpdatePo = new CustomizationGoodsRelationPO();
        goodsRelationUpdatePo.setValid(Boolean.FALSE);
        goodsRelationUpdatePo.setCustomizationCategoryId(customizationCategoryId);
        int goodsRelationUpdateNum = this.customizationGoodsRelationPOMapper.updateByExampleSelective(goodsRelationUpdatePo, goodsRelationPOExample);
        log.info("\u5220\u9664\u5206\u7c7b\u548c\u5546\u54c1\u5173\u8054\u5173\u7cfb\u6570\u91cf\uff1a{}", (Object)goodsRelationUpdateNum);
        CustomizationCategoryPO categoryUpdatePO = new CustomizationCategoryPO();
        categoryUpdatePO.setCustomizationCategoryId(customizationCategoryId);
        categoryUpdatePO.setValid(Boolean.FALSE);
        int categoryUpdateNum = this.customizationCategoryPOMapper.updateByPrimaryKeySelective(categoryUpdatePO);
        log.info("\u5220\u9664\u5206\u7c7b\u6570\u91cf:{}", (Object)categoryUpdateNum);
        return ResponseUtil.getSuccessData((Object)"");
    }

    public ResponseData searchCategoryList(CustomizationCategoryListSearchRequestVO vo) {
        log.info("CustomizationServiceImpl#searchCategoryList vo:{}", (Object)JSON.toJSONString((Object)vo));
        CustomizationRelationPOExample checkRelation = new CustomizationRelationPOExample();
        checkRelation.createCriteria().andValidEqualTo(Boolean.TRUE).andCustomizationRelationIdEqualTo(vo.getCustomizationRelationId());
        List customizationRelationPOS = this.customizationRelationPOMapper.selectByExample(checkRelation);
        log.info("\u67e5\u8be2\u51fa\u7684\u5173\u8054\u5173\u7cfb\u96c6\u5408:{}", (Object)JSON.toJSONString((Object)customizationRelationPOS));
        if (CollectionUtils.isEmpty((Collection)customizationRelationPOS)) {
            return ResponseUtil.getFailedMsg((String)"\u5546\u6237\u5b9a\u5236\u670d\u52a1\u5173\u8054\u5173\u7cfb\u672a\u521b\u5efa");
        }
        if (customizationRelationPOS.size() > 1) {
            return ResponseUtil.getFailedMsg((String)"\u5546\u6237\u5b9a\u5236\u670d\u52a1\u5173\u8054\u5173\u7cfb\u8fc7\u591a");
        }
        Integer customizationRelationId = ((CustomizationRelationPO)customizationRelationPOS.get(0)).getCustomizationRelationId();
        CustomizationCategoryPOExample searchListExample = new CustomizationCategoryPOExample();
        CustomizationCategoryPOExample.Criteria criteria = searchListExample.createCriteria().andCustomizationRelationIdEqualTo(customizationRelationId).andValidEqualTo(Boolean.TRUE);
        PageInfo pageInfo = new PageInfo();
        if (!StringUtils.isEmpty((Object)vo.getCustomizationCategoryName())) {
            criteria.andCustomizationCategoryNameLike("%" + vo.getCustomizationCategoryName() + "%");
        }
        searchListExample.setOrderByClause("gmt_create desc");
        List customizationCategoryPOS = new ArrayList();
        if (vo.getPageJudge().booleanValue()) {
            PageHelper.startPage((int)vo.getPageNum(), (int)vo.getPageSize());
            customizationCategoryPOS = this.customizationCategoryPOMapper.selectByExample(searchListExample);
            pageInfo = new PageInfo(customizationCategoryPOS);
        } else {
            customizationCategoryPOS = this.customizationCategoryPOMapper.selectByExample(searchListExample);
            pageInfo.setList(customizationCategoryPOS);
        }
        return ResponseUtil.getSuccessData((Object)pageInfo);
    }

    public ResponseData addCategoryAndGoodsRelation(CustomizationCategoryAndGoodRelationAddRequestVO vo) {
        log.info("CustomizationServiceImpl#addCategoryAndGoodsRelation:{}", (Object)JSON.toJSONString((Object)vo));
        CustomizationGoodsRelationPOExample checkRelationExistsExample = new CustomizationGoodsRelationPOExample();
        CustomizationGoodsRelationPOExample.Criteria checkRelationExistsExampleCriteria = checkRelationExistsExample.createCriteria().andGoodIdEqualTo(vo.getGoodId());
        if (vo.getCustomizationRelationId() != null) {
            checkRelationExistsExampleCriteria.andCustomizationRelationIdEqualTo(vo.getCustomizationRelationId());
        }
        List customizationGoodsRelationPOS = this.customizationGoodsRelationPOMapper.selectByExample(checkRelationExistsExample);
        log.info("addCategoryAndGoodsRelation_customizationGoodsRelationPOS:{}", (Object)JSON.toJSONString((Object)customizationGoodsRelationPOS));
        ArrayList<CustomizationGoodsRelationPO> validRelationPos = new ArrayList<CustomizationGoodsRelationPO>();
        ArrayList<CustomizationGoodsRelationPO> unValidRelationPos = new ArrayList<CustomizationGoodsRelationPO>();
        if (!CollectionUtils.isEmpty((Collection)customizationGoodsRelationPOS)) {
            for (Object po : customizationGoodsRelationPOS) {
                if (po.getValid().booleanValue()) {
                    validRelationPos.add((CustomizationGoodsRelationPO)po);
                    continue;
                }
                unValidRelationPos.add((CustomizationGoodsRelationPO)po);
            }
        }
        log.info("\u6709\u6548\u5173\u8054\u5173\u7cfb\uff1a{}", (Object)JSON.toJSONString(validRelationPos));
        log.info("\u65e0\u6548\u5173\u8054\u5173\u7cfb\uff1a{}", (Object)JSON.toJSONString(unValidRelationPos));
        if (CollectionUtils.isEmpty((Collection)vo.getCategoryIds()) && !CollectionUtils.isEmpty(validRelationPos)) {
            int deleteAllNum = this.customizationByDesignerPOMapper.deleteAllRelation(validRelationPos);
            log.info("\u5546\u54c1\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb\u4e14\u5b58\u5728\u6709\u6548\u5173\u8054\u5173\u7cfb\u6570\u636e\uff0c\u5220\u9664\u6570\u91cf\u4e3a:{}", (Object)deleteAllNum);
            return ResponseUtil.getSuccessData((Object)"");
        }
        if (!CollectionUtils.isEmpty((Collection)vo.getCategoryIds()) && CollectionUtils.isEmpty((Collection)customizationGoodsRelationPOS)) {
            ArrayList<CustomizationGoodsRelationPO> insertPos = new ArrayList<CustomizationGoodsRelationPO>();
            for (Integer categoryId : vo.getCategoryIds()) {
                CustomizationGoodsRelationPO po = new CustomizationGoodsRelationPO();
                po.setGoodId(vo.getGoodId());
                po.setCustomizationCategoryId(categoryId);
                po.setGmtCreate(new Date());
                po.setCustomizationRelationId(vo.getCustomizationRelationId());
                insertPos.add(po);
            }
            log.info("insertPos:{}", (Object)JSON.toJSONString(insertPos));
            int insertAllNum = this.customizationByDesignerPOMapper.insertAllRelation(insertPos);
            log.info("\u5546\u54c1\u5b58\u5728\u5173\u8054\u5173\u7cfb\u4f46\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb\u6570\u636e\uff0c\u63d2\u5165\u6570\u91cf\u4e3a:{}", (Object)insertAllNum);
            return ResponseUtil.getSuccessData((Object)"");
        }
        if (!CollectionUtils.isEmpty((Collection)vo.getCategoryIds()) && !CollectionUtils.isEmpty((Collection)customizationGoodsRelationPOS)) {
            log.info("\u5546\u54c1\u6709\u5173\u8054\u5173\u7cfb\u4e14\u5b58\u5728\u5173\u8054\u5386\u53f2\u8bb0\u5f55");
            Iterator categoryIdsIterator = vo.getCategoryIds().iterator();
            Iterator relationPOSIterator = customizationGoodsRelationPOS.iterator();
            ArrayList<CustomizationGoodsRelationPO> updatePos = new ArrayList<CustomizationGoodsRelationPO>();
            ArrayList<CustomizationGoodsRelationPO> insertPos = new ArrayList<CustomizationGoodsRelationPO>();
            ArrayList deletePos = new ArrayList();
            while (categoryIdsIterator.hasNext()) {
                Integer sendId = (Integer)categoryIdsIterator.next();
                while (relationPOSIterator.hasNext()) {
                    CustomizationGoodsRelationPO po = (CustomizationGoodsRelationPO)relationPOSIterator.next();
                    if (!sendId.equals(po.getCustomizationCategoryId())) continue;
                    if (po.getValid().equals(Boolean.FALSE)) {
                        updatePos.add(po);
                    }
                    categoryIdsIterator.remove();
                    relationPOSIterator.remove();
                }
            }
            if (!CollectionUtils.isEmpty(updatePos)) {
                log.info("updatePos\uff1a{}", (Object)JSON.toJSONString(updatePos));
                int updateNum = this.customizationByDesignerPOMapper.activeAllRelation(updatePos);
                log.info("\u6fc0\u6d3b\u6570\u91cf\u4e3a:{}", (Object)updateNum);
            }
            if (!CollectionUtils.isEmpty((Collection)vo.getCategoryIds())) {
                for (Integer categoryId : vo.getCategoryIds()) {
                    CustomizationGoodsRelationPO insertPo = new CustomizationGoodsRelationPO();
                    insertPo.setGoodId(vo.getGoodId());
                    insertPo.setCustomizationCategoryId(categoryId);
                    insertPo.setGmtCreate(new Date());
                    insertPo.setCustomizationRelationId(vo.getCustomizationRelationId());
                    insertPos.add(insertPo);
                }
                log.info("insertPos:{}", (Object)JSON.toJSONString(insertPos));
                int insertAllNum = this.customizationByDesignerPOMapper.insertAllRelation(insertPos);
                log.info("\u63d2\u5165\u6570\u91cf\u4e3a:{}", (Object)insertAllNum);
            }
            if (!CollectionUtils.isEmpty((Collection)customizationGoodsRelationPOS)) {
                log.info("deletePos:{}", (Object)JSON.toJSONString((Object)customizationGoodsRelationPOS));
                int deleteAllNum = this.customizationByDesignerPOMapper.deleteAllRelation(customizationGoodsRelationPOS);
                log.info("\u5546\u54c1\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb\u4e14\u5b58\u5728\u6709\u6548\u5173\u8054\u5173\u7cfb\u6570\u636e\uff0c\u5220\u9664\u6570\u91cf\u4e3a:{}", (Object)deleteAllNum);
            }
        }
        return null;
    }

    public ResponseData searchAllCategoryDetailList(CustomizationCategoryDetailListSearchRequestVO vo) {
        log.info("CustomizationServiceImpl#searchAllCategoryDetailList vo:{}", (Object)JSON.toJSONString((Object)vo));
        if (vo.getPageJudge() == null) {
            vo.setPageJudge(Boolean.TRUE);
        }
        List pos = new ArrayList();
        PageInfo pageInfo = new PageInfo();
        if (vo.getPageJudge().booleanValue()) {
            PageHelper.startPage((int)vo.getPageNum(), (int)vo.getPageSize());
            pos = this.customizationByDesignerPOMapper.selectAllCategoryDetailList(vo.getCustomizationRelationId());
            pageInfo = new PageInfo(pos);
        } else {
            pos = this.customizationByDesignerPOMapper.selectAllCategoryDetailList(vo.getCustomizationRelationId());
            pageInfo.setList(pos);
        }
        return ResponseUtil.getSuccessData((Object)pageInfo);
    }
}

