/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.admin.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.enums.admin.GoodsBatchSetEnum;
import com.wmeimob.fastboot.bizvane.exception.MallCommonException;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ActivityCombinationGoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ActivityPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.custommapper.GoodsPlusPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.custommapper.GoodsServiceDescRelationPlusPOMapper;
import com.wmeimob.fastboot.bizvane.po.ActivityCombinationGoodsPOExample;
import com.wmeimob.fastboot.bizvane.po.ActivityPO;
import com.wmeimob.fastboot.bizvane.po.ActivityPOExample;
import com.wmeimob.fastboot.bizvane.po.GoodsPO;
import com.wmeimob.fastboot.bizvane.po.GoodsServiceDescRelationPO;
import com.wmeimob.fastboot.bizvane.po.GoodsServiceDescRelationPOExample;
import com.wmeimob.fastboot.bizvane.service.GoodsService;
import com.wmeimob.fastboot.bizvane.service.admin.GoodsNewService;
import com.wmeimob.fastboot.bizvane.vo.admin.GoodsCashSearchRequestVO;
import com.wmeimob.fastboot.bizvane.vo.admin.GoodsCashSearchResponseVO;
import com.wmeimob.fastboot.bizvane.vo.goods.batchModify.BatchModifyDescRequestVO;
import com.wmeimob.fastboot.bizvane.vo.goods.batchModify.BatchModifyDispatchingTypeVO;
import com.wmeimob.fastboot.bizvane.vo.goods.batchModify.DescriptionRequestVO;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class GoodsNewServiceImpl
implements GoodsNewService {
    private static final Logger log = LoggerFactory.getLogger(GoodsNewServiceImpl.class);
    @Resource
    private GoodsMapper goodsMapper;
    @Autowired
    private GoodsService goodsService;
    @Resource
    private GoodsPlusPOMapper goodsPlusPoMapper;
    @Resource
    private GoodsServiceDescRelationPlusPOMapper goodsServiceDescRelationPlusPOMapper;
    @Resource
    private ActivityPOMapper activityPOMapper;
    @Resource
    private ActivityCombinationGoodsPOMapper activityCombinationGoodsPOMapper;

    public GoodsCashSearchResponseVO queryCashGoodsByCondition(GoodsCashSearchRequestVO requestVO) {
        Integer secondClassifyId;
        Integer firstClassifyId = requestVO.getFirstClassifyId();
        if (firstClassifyId != null && firstClassifyId != 0) {
            requestVO.setClassifyId(firstClassifyId);
        }
        if ((secondClassifyId = requestVO.getSecondClassifyId()) != null && secondClassifyId != 0) {
            requestVO.setClassifyId(secondClassifyId);
        }
        PageHelper.startPage((int)requestVO.getPageNum(), (int)requestVO.getPageSize());
        List goods = this.goodsMapper.queryCashGoodsByCondition(requestVO);
        PageInfo goodsPageInfo = new PageInfo(goods);
        List list = goodsPageInfo.getList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List goodsNew = this.goodsService.addCategoryName(list);
            goodsPageInfo.setList(goodsNew);
        }
        GoodsCashSearchResponseVO goodsCashSearchResponseVO = new GoodsCashSearchResponseVO();
        goodsCashSearchResponseVO.setPageInfo(goodsPageInfo);
        return goodsCashSearchResponseVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchModifyDispatchingType(BatchModifyDispatchingTypeVO batchModifyDispatchingTypeVO) {
        log.info("GoodsNewServiceImpl # batchModifyDispatchingType \u5165\u53c2:{}", JSON.toJSON((Object)batchModifyDispatchingTypeVO));
        Integer merchantId = batchModifyDispatchingTypeVO.getMerchantId();
        List goodsIds = batchModifyDispatchingTypeVO.getGoodsIds();
        Integer shippingMode = batchModifyDispatchingTypeVO.getShippingModes();
        try {
            InputValidator.checkEmpty((Object)merchantId, (String)GoodsBatchSetEnum.ERROR_PARAMETER_MERCHANTID_NULL.getDec());
            InputValidator.checkEmpty((Collection)goodsIds, (String)GoodsBatchSetEnum.ERROR_PARAMETER_GOODSID_NULL.getDec());
            InputValidator.checkEmpty((Object)shippingMode, (String)GoodsBatchSetEnum.ERROR_PARAMETER_SHIPPINGMODE_NULL.getDec());
            if (!(GoodsBatchSetEnum.LOGISTICS.getCode().equals(shippingMode) || GoodsBatchSetEnum.SELF_MENTION.getCode().equals(shippingMode) || GoodsBatchSetEnum.OPTIONAL.getCode().equals(shippingMode))) {
                throw new MallAdminException(GoodsBatchSetEnum.ERROR_PARAMETER_SHIPPINGMODE_TYPE.getMessage());
            }
            Date modifyDate = new Date();
            goodsIds.forEach(goodsId -> {
                GoodsPO goodsPo = this.goodsPlusPoMapper.selectByPrimaryKey(goodsId);
                if (!goodsPo.getShippingMode().equals(shippingMode)) {
                    this.validaGoods(goodsPo);
                }
                if (StringUtils.isEmpty((Object)goodsPo)) {
                    log.warn("\u5546\u54c1[" + goodsId + "]\u518d\u6279\u91cf\u5904\u7406\u914d\u9001\u65b9\u5f0f\u65f6\u67e5\u8be2\u4e3a\u7a7a");
                } else if (shippingMode.equals(goodsPo.getShippingMode())) {
                    log.info("\u5546\u54c1[" + goodsId + "]\u5df2\u7ecf\u662f\u4f60\u8981\u66f4\u6539\u7684\u7c7b\u578b");
                } else {
                    GoodsPO modifyGoods = new GoodsPO();
                    modifyGoods.setId(goodsId);
                    modifyGoods.setShippingMode(shippingMode);
                    modifyGoods.setGmtModified(modifyDate);
                    this.goodsPlusPoMapper.updateByPrimaryKeySelective(modifyGoods);
                }
            });
        }
        catch (Exception e) {
            log.warn("\u6279\u91cf\u4fee\u6539\u5546\u54c1\u7684\u914d\u9001\u65b9\u5f0f\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallAdminException(e.getMessage(), (Throwable)e);
        }
    }

    private void validaGoods(GoodsPO goods) {
        Integer merchantId = goods.getMerchantId();
        ActivityPOExample activityPOExample = new ActivityPOExample();
        activityPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(merchantId).andActivityStatusValueIsNotNull().andActivityStatusValueNotEqualTo(Integer.valueOf(2));
        List activityPOList = this.activityPOMapper.selectByExample(activityPOExample);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)activityPOList)) {
            List activityIds = activityPOList.stream().map(ActivityPO::getId).collect(Collectors.toList());
            ActivityCombinationGoodsPOExample activityCombinationGoodsPOExample = new ActivityCombinationGoodsPOExample();
            activityCombinationGoodsPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE).andActivityIdIn(activityIds).andGoodsIdEqualTo(goods.getId());
            List activityCombinationGoodsPOList = this.activityCombinationGoodsPOMapper.selectByExample(activityCombinationGoodsPOExample);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)activityCombinationGoodsPOList)) {
                throw new MallCommonException("\u5546\u54c1\u5df2\u53c2\u52a0\u7ec4\u5408\u4ef7\u6d3b\u52a8\uff0c\u4e0d\u53ef\u66f4\u6539\u914d\u9001\u65b9\u5f0f!");
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchModifyDesc(BatchModifyDescRequestVO batchModifyDescRequestVO) {
        log.info("GoodsNewServiceImpl # batchModifyDesc \u5165\u53c2:{}", JSON.toJSON((Object)batchModifyDescRequestVO));
        Integer merchantId = batchModifyDescRequestVO.getMerchantId();
        List goodsIds = batchModifyDescRequestVO.getGoodsIds();
        List descriptionList = batchModifyDescRequestVO.getDescriptionList();
        try {
            InputValidator.checkEmpty((Object)merchantId, (String)GoodsBatchSetEnum.ERROR_PARAMETER_MERCHANTID_NULL.getDec());
            InputValidator.checkEmpty((Collection)goodsIds, (String)GoodsBatchSetEnum.ERROR_PARAMETER_GOODSID_NULL.getDec());
            InputValidator.checkEmpty((Collection)descriptionList, (String)GoodsBatchSetEnum.ERROR_PARAMETER_DESCRIPTION.getDec());
            if (descriptionList.size() > 5) {
                throw new MallAdminException(GoodsBatchSetEnum.ERROR_PARAMETER_LONG.getMessage());
            }
            Date modifyDate = new Date();
            goodsIds.forEach(goodsId -> {
                GoodsServiceDescRelationPOExample goodsServiceDescRelationPoExample = new GoodsServiceDescRelationPOExample();
                goodsServiceDescRelationPoExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(merchantId).andGoodsIdEqualTo(goodsId);
                List goodsServiceDescRelationPoList = this.goodsServiceDescRelationPlusPOMapper.selectByExample(goodsServiceDescRelationPoExample);
                if (CollectionUtils.isEmpty((Collection)goodsServiceDescRelationPoList)) {
                    List insertPoList = this.getInsertPoByGoodsId(goodsId, descriptionList, merchantId, modifyDate);
                    this.goodsServiceDescRelationPlusPOMapper.insertList(insertPoList);
                } else {
                    ArrayList ids = new ArrayList();
                    goodsServiceDescRelationPoList.forEach(gsd -> {
                        Integer id = gsd.getId();
                        ids.add(id);
                    });
                    this.goodsServiceDescRelationPlusPOMapper.deleteListByIds(ids);
                    List insertList = this.getInsertPoByGoodsId(goodsId, descriptionList, merchantId, modifyDate);
                    this.goodsServiceDescRelationPlusPOMapper.insertList(insertList);
                }
            });
        }
        catch (Exception e) {
            log.warn("\u6279\u91cf\u4fee\u6539\u670d\u52a1\u8bf4\u660e\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallAdminException(e.getMessage(), (Throwable)e);
        }
    }

    private List<GoodsServiceDescRelationPO> getInsertPoByGoodsId(Integer goodsId, List<DescriptionRequestVO> descriptionList, Integer merchantId, Date modifyDate) {
        ArrayList<GoodsServiceDescRelationPO> list = new ArrayList<GoodsServiceDescRelationPO>();
        descriptionList.forEach(description -> {
            GoodsServiceDescRelationPO goodsServiceDescRelationPo = new GoodsServiceDescRelationPO();
            goodsServiceDescRelationPo.setMerchantId(merchantId);
            goodsServiceDescRelationPo.setGmtCreate(modifyDate);
            goodsServiceDescRelationPo.setGoodsId(goodsId);
            goodsServiceDescRelationPo.setValid(Boolean.TRUE);
            goodsServiceDescRelationPo.setGoodsServiceDescId(description.getId());
            goodsServiceDescRelationPo.setGoodsServiceName(description.getGoodsServiceName());
            goodsServiceDescRelationPo.setGoodsServiceDesc(description.getGoodsServiceDesc());
            list.add(goodsServiceDescRelationPo);
        });
        return list;
    }
}

