/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.Integralstore.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.enums.IntegralOrdersAuditEnum;
import com.wmeimob.fastboot.bizvane.enums.IntegralOrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralOrdersPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.custommapper.IntegralOrdersPlusPOMapper;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersPO;
import com.wmeimob.fastboot.bizvane.service.IntegralOrdersService;
import com.wmeimob.fastboot.bizvane.service.Integralstore.IntegralOrdersNewService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.SysResponseEnum;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.order.QueryIntegralOrderListRequestVO;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.order.QueryIntegralOrderListResponseVO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.AudiPassInfoRequestVO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.BatchAuditErrorInfo;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.BatchAuditIntegralOrdersRequestVO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.BatchAuditIntegralOrdersResponseVO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.BatchAuditUserInfo;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class IntegralOrderNewServiceImpl
implements IntegralOrdersNewService {
    private static final Logger log = LoggerFactory.getLogger(IntegralOrderNewServiceImpl.class);
    @Resource
    private IntegralOrdersPlusPOMapper integralOrdersPlusPoMapper;
    @Resource
    private IntegralOrdersPOMapper integralOrdersPoMapper;
    private final IntegralOrdersService integralOrdersService;

    public IntegralOrderNewServiceImpl(IntegralOrdersService integralOrdersService) {
        this.integralOrdersService = integralOrdersService;
    }

    public List<QueryIntegralOrderListResponseVO> queryIntegralOrderListInfo(QueryIntegralOrderListRequestVO queryIntegralOrderListRequestVO) {
        log.info("IntegralOrderNewServiceImpl#queryIntegralOrderListInfo:{}", (Object)JSON.toJSONString((Object)queryIntegralOrderListRequestVO));
        try {
            InputValidator.checkEmpty((Object)queryIntegralOrderListRequestVO.getMerchantId(), (String)"\u5546\u6237ID");
            return this.integralOrdersPlusPoMapper.queryIntegralOrderListInfo(queryIntegralOrderListRequestVO);
        }
        catch (Exception e) {
            throw new MallAdminException(e.getMessage(), (Throwable)e);
        }
    }

    public ResponseData<BatchAuditIntegralOrdersResponseVO> batchAuditIntegralOrders(BatchAuditIntegralOrdersRequestVO batchAuditIntegralOrdersRequestVo) {
        log.info("IntegralOrderNewServiceImpl#batchAuditIntegralOrders:{}", (Object)JSON.toJSONString((Object)batchAuditIntegralOrdersRequestVo));
        ResponseData responseData = new ResponseData();
        ArrayList<BatchAuditErrorInfo> batchAuditErrorInfos = new ArrayList<BatchAuditErrorInfo>();
        Integer merchantId = batchAuditIntegralOrdersRequestVo.getMerchantId();
        Integer isAuditPass = batchAuditIntegralOrdersRequestVo.getIsAuditPass();
        List paramsList = batchAuditIntegralOrdersRequestVo.getParamsList();
        try {
            if (IntegralOrdersAuditEnum.AUDIT_SEND_PASS.getCode().equals(isAuditPass)) {
                for (AudiPassInfoRequestVO param : paramsList) {
                    BatchAuditErrorInfo errorInfo;
                    BatchAuditErrorInfo errorInfo2;
                    BatchAuditErrorInfo errorInfo3;
                    Integer id = param.getId();
                    IntegralOrdersPO ordersPo = this.integralOrdersPoMapper.selectByPrimaryKey(id);
                    if (StringUtils.isEmpty((Object)ordersPo)) {
                        errorInfo3 = this.gatherErrorInfo(param, "\u8ba2\u5355\u4e0d\u5b58\u5728");
                        batchAuditErrorInfos.add(errorInfo3);
                        continue;
                    }
                    if (Boolean.FALSE.equals(ordersPo.getValid())) {
                        errorInfo3 = this.gatherErrorInfo(param, "\u65e0\u6548\u8ba2\u5355");
                        batchAuditErrorInfos.add(errorInfo3);
                        continue;
                    }
                    if (!IntegralOrdersStatusEnum.AUDITING.getCode().equals(ordersPo.getOrderStatus())) {
                        errorInfo3 = this.gatherErrorInfo(param, "\u975e\u5ba1\u6838\u72b6\u6001\u8ba2\u5355");
                        batchAuditErrorInfos.add(errorInfo3);
                        continue;
                    }
                    BatchAuditUserInfo userInfo = batchAuditIntegralOrdersRequestVo.getUserInfo();
                    String sysAccountId = userInfo.getSysAccountId();
                    String accountCode = userInfo.getAccountCode();
                    String name = userInfo.getName();
                    if (StringUtils.isEmpty((Object)sysAccountId)) {
                        errorInfo2 = this.gatherErrorInfo(param, "\u5ba1\u6838\u4eba\u4e3a\u7a7a");
                        batchAuditErrorInfos.add(errorInfo2);
                        continue;
                    }
                    if (!sysAccountId.equals(ordersPo.getDeliverAuditorMark())) {
                        errorInfo2 = this.gatherErrorInfo(param, "\u6b64\u8ba2\u5355\u5ba1\u6838\u4eba\u4e3a\uff1a" + name + "---" + accountCode);
                        batchAuditErrorInfos.add(errorInfo2);
                        continue;
                    }
                    IntegralOrdersPO updatePo = new IntegralOrdersPO();
                    updatePo.setId(id);
                    updatePo.setIsDeliverCheck(String.valueOf(0));
                    updatePo.setOrderStatus(String.valueOf(0));
                    try {
                        int i = this.integralOrdersPoMapper.updateByPrimaryKeySelective(updatePo);
                        if (i >= 1) continue;
                        errorInfo = this.gatherErrorInfo(param, "\u5ba1\u6838\u5931\u8d25A");
                        batchAuditErrorInfos.add(errorInfo);
                    }
                    catch (Exception e) {
                        errorInfo = this.gatherErrorInfo(param, "\u5ba1\u6838\u5931\u8d25B");
                        batchAuditErrorInfos.add(errorInfo);
                    }
                }
            } else if (IntegralOrdersAuditEnum.AUDIT_SEND_NOT_PASS.getCode().equals(isAuditPass)) {
                for (AudiPassInfoRequestVO params : paramsList) {
                    BatchAuditErrorInfo errorInfo;
                    BatchAuditErrorInfo errorInfo4;
                    Integer id = params.getId();
                    IntegralOrdersPO ordersPo = this.integralOrdersPoMapper.selectByPrimaryKey(id);
                    if (StringUtils.isEmpty((Object)ordersPo)) {
                        errorInfo4 = this.gatherErrorInfo(params, "\u8ba2\u5355\u4e0d\u5b58\u5728");
                        batchAuditErrorInfos.add(errorInfo4);
                        continue;
                    }
                    if (Boolean.FALSE.equals(ordersPo.getValid())) {
                        errorInfo4 = this.gatherErrorInfo(params, "\u65e0\u6548\u8ba2\u5355");
                        batchAuditErrorInfos.add(errorInfo4);
                        continue;
                    }
                    if (!IntegralOrdersStatusEnum.AUDITING.getCode().equals(ordersPo.getOrderStatus())) {
                        errorInfo4 = this.gatherErrorInfo(params, "\u975e\u5ba1\u6838\u72b6\u6001\u8ba2\u5355");
                        batchAuditErrorInfos.add(errorInfo4);
                        continue;
                    }
                    BatchAuditUserInfo userInfo = batchAuditIntegralOrdersRequestVo.getUserInfo();
                    String sysAccountId = userInfo.getSysAccountId();
                    if (StringUtils.isEmpty((Object)sysAccountId)) {
                        errorInfo = this.gatherErrorInfo(params, "\u5ba1\u6838\u4eba\u4e3a\u7a7a");
                        batchAuditErrorInfos.add(errorInfo);
                        continue;
                    }
                    if (!sysAccountId.equals(ordersPo.getDeliverAuditorMark())) {
                        errorInfo = this.gatherErrorInfo(params, "\u60a8\u6ca1\u6709\u6b64\u8ba2\u5355\u7684\u5ba1\u6838\u6743\u9650\uff01");
                        batchAuditErrorInfos.add(errorInfo);
                        continue;
                    }
                    IntegralOrdersPO updatePo = new IntegralOrdersPO();
                    updatePo.setId(id);
                    updatePo.setIsDeliverCheck(String.valueOf(0));
                    updatePo.setOrderStatus(IntegralOrdersStatusEnum.RETURNED_GOODS.getCode());
                    log.info("updatePo:{}", (Object)JSON.toJSONString((Object)updatePo));
                    IntegralOrders integralOrders = new IntegralOrders();
                    integralOrders.setMerchantId(merchantId);
                    integralOrders.setOrderNo(params.getOrderNo());
                    try {
                        this.integralOrdersService.refundByAudit(integralOrders);
                        this.integralOrdersPoMapper.updateByPrimaryKeySelective(updatePo);
                    }
                    catch (Exception e) {
                        BatchAuditErrorInfo errorInfo5 = this.gatherErrorInfo(params, "\u5ba1\u6838\u5931\u8d25C");
                        batchAuditErrorInfos.add(errorInfo5);
                    }
                }
            }
        }
        catch (Exception e) {
            log.warn("\u79ef\u5206\u8ba2\u5355\u6279\u91cf\u5ba1\u6838\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
        }
        int allCount = paramsList == null ? 0 : paramsList.size();
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        BatchAuditIntegralOrdersResponseVO responseVO = new BatchAuditIntegralOrdersResponseVO();
        responseVO.setErrorInfoList(batchAuditErrorInfos);
        responseVO.setAllCount(Integer.valueOf(allCount));
        responseVO.setFailCount(Integer.valueOf(CollectionUtils.isEmpty(batchAuditErrorInfos) ? 0 : batchAuditErrorInfos.size()));
        responseData.setData((Object)responseVO);
        return responseData;
    }

    private BatchAuditErrorInfo gatherErrorInfo(AudiPassInfoRequestVO param, String msg) {
        BatchAuditErrorInfo batchAuditErrorInfo = new BatchAuditErrorInfo();
        batchAuditErrorInfo.setOrderNo(param.getOrderNo());
        batchAuditErrorInfo.setErrorReason(msg);
        return batchAuditErrorInfo;
    }
}

