/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.wx_msg_notice;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.service.wx_msg_notice.WXMsgNoticeService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.wx_msg_template.WXMsgTemplateActiveAndDeactivateRequestVO;
import com.wmeimob.fastboot.bizvane.vo.wx_msg_template.WXMsgTemplateSelectAvailableRequestVO;
import com.wmeimob.fastboot.bizvane.vo.wx_msg_template.WXMsgTemplateSelectRequestVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"wxMsgNotice"})
public class WXMsgNoticeController {
    private static final Logger log = LoggerFactory.getLogger(WXMsgNoticeController.class);
    @Autowired
    private WXMsgNoticeService wxMsgNoticeService;

    @PostMapping(value={"selectAvailableWXMsgTemplate"})
    public ResponseData selectAvailableWXMsgTemplate(@RequestBody(required=false) WXMsgTemplateSelectAvailableRequestVO vo, @RequestHeader Integer merchantId) {
        if (vo == null) {
            vo = new WXMsgTemplateSelectAvailableRequestVO();
        }
        vo.setMerchantId(merchantId);
        log.info("WXMsgNoticeController#selectAvailableWXMsgTemplate:{}", (Object)JSON.toJSONString((Object)vo));
        return this.wxMsgNoticeService.selectAvailableWXMsgTemplate(vo);
    }

    @PostMapping(value={"activeWXMsgTemplate"})
    public ResponseData activeWXMsgTemplate(@RequestHeader Integer merchantId, @RequestBody WXMsgTemplateActiveAndDeactivateRequestVO vo) {
        log.info("WXMsgNoticeController#activeWXMsgTemplate vo{}", (Object)JSON.toJSONString((Object)vo));
        if (vo.getMsgWxTemplateId() == null) {
            return ResponseUtil.getFailedMsg((String)"\u64cd\u4f5c\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        vo.setActive(Boolean.TRUE);
        return this.wxMsgNoticeService.activeWXMsgTemplate(vo);
    }

    @PostMapping(value={"deactivateWXMsgTemplate"})
    public ResponseData deactivateWXMsgTemplate(@RequestHeader Integer merchantId, @RequestBody WXMsgTemplateActiveAndDeactivateRequestVO vo) {
        log.info("WXMsgNoticeController#activeWXMsgTemplate vo{}", (Object)JSON.toJSONString((Object)vo));
        if (vo.getMsgWxTemplateId() == null) {
            return ResponseUtil.getFailedMsg((String)"\u64cd\u4f5c\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        vo.setActive(Boolean.FALSE);
        return this.wxMsgNoticeService.activeWXMsgTemplate(vo);
    }

    @PostMapping(value={"selectWXMsgTemplateRecord"})
    public ResponseData selectWXMsgTemplateRecord(@RequestHeader Integer merchantId, @RequestBody WXMsgTemplateSelectRequestVO vo, @RequestParam Integer pageSize, @RequestParam Integer pageNum) {
        vo.setMerchantId(merchantId);
        vo.setPageNum(pageNum);
        vo.setPageSize(pageSize);
        log.info("WXMsgNoticeController#selectWXMsgTemplateRecord:{}", (Object)JSON.toJSONString((Object)vo));
        return this.wxMsgNoticeService.selectWXMsgTemplateRecord(vo);
    }
}

