/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.entity.GoodsTag;
import com.wmeimob.fastboot.bizvane.mapper.GoodsTagCustomMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsTagMapper;
import com.wmeimob.fastboot.bizvane.service.GoodsTagService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class GoodsTagServiceImpl
implements GoodsTagService {
    @Autowired
    private GoodsTagMapper goodsTagMapper;
    @Autowired
    private GoodsTagCustomMapper goodsTagCustomMapper;

    public GoodsTag add(GoodsTag goodsTag) {
        InputValidator.checkEmpty((Object)goodsTag.getName(), (String)"\u6807\u7b7e\u540d\u79f0");
        InputValidator.checkEmpty((Object)goodsTag.getSort(), (String)"\u6392\u5e8f\u503c");
        goodsTag.setGmtCreate(new Date());
        this.goodsTagMapper.insertSelective((Object)goodsTag);
        return goodsTag;
    }

    public int delete(Integer id) {
        Integer integer = this.goodsTagCustomMapper.selectCountGoodsByTagId(id);
        if (integer > 0) {
            throw new CustomException("\u5206\u7c7b\u4e0b\u8fd8\u6709\u5546\u54c1\uff0c\u5220\u9664\u5931\u8d25");
        }
        return this.goodsTagMapper.deleteByPrimaryKey((Object)id);
    }

    public int update(GoodsTag goodsTag) {
        InputValidator.checkEmpty((Object)goodsTag.getName(), (String)"\u6807\u7b7e\u540d\u79f0");
        InputValidator.checkEmpty((Object)goodsTag.getSort(), (String)"\u6392\u5e8f\u503c");
        goodsTag.setGmtModified(new Date());
        return this.goodsTagMapper.updateByPrimaryKeySelective((Object)goodsTag);
    }

    public List<GoodsTag> findByCondition(GoodsTag condition) {
        Example example = new Example(GoodsTag.class);
        example.orderBy("sort").desc();
        example.createCriteria().andEqualTo("merchantId", (Object)condition.getMerchantId());
        return this.goodsTagMapper.selectByExample((Object)example);
    }
}

