/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.Activity;
import com.wmeimob.fastboot.bizvane.entity.ActivityGoods;
import com.wmeimob.fastboot.bizvane.entity.ActivityRule;
import com.wmeimob.fastboot.bizvane.entity.ActivityRuleCombination;
import com.wmeimob.fastboot.bizvane.entity.ActivityRuleGift;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.enums.ActivitySanEnum;
import com.wmeimob.fastboot.bizvane.enums.GoodsIsGift;
import com.wmeimob.fastboot.bizvane.mapper.ActivityGiftMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityRuleCombinationMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityRuleGiftMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityRuleMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ActivityGoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ActivityRuleCombinationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ActivityRuleGiftPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ActivityRulePOMapper;
import com.wmeimob.fastboot.bizvane.po.ActivityGoodsPOExample;
import com.wmeimob.fastboot.bizvane.po.ActivityRuleCombinationPOExample;
import com.wmeimob.fastboot.bizvane.po.ActivityRuleGiftPOExample;
import com.wmeimob.fastboot.bizvane.po.ActivityRulePOExample;
import com.wmeimob.fastboot.bizvane.service.ActivitySanService;
import com.wmeimob.fastboot.core.exception.CustomException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service
public class ActivitySanServiceImpl
implements ActivitySanService {
    private static final Logger log = LoggerFactory.getLogger(ActivitySanServiceImpl.class);
    @Autowired
    private ActivityMapper activityMapper;
    @Autowired
    private ActivityRuleMapper activityRuleMapper;
    @Autowired
    private ActivityRuleGiftMapper activityRuleGiftMapper;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private ActivityRuleCombinationMapper activityRuleCombinationMapper;
    @Autowired
    private ActivityGoodsMapper activityGoodsMapper;
    @Autowired
    private ActivityGiftMapper activityGiftMapper;
    @Autowired
    private ActivityRuleGiftPOMapper activityRuleGiftPOMapper;
    @Autowired
    private ActivityRuleCombinationPOMapper activityRuleCombinationPOMapper;
    @Autowired
    private ActivityGoodsPOMapper activityGoodsPOMapper;
    @Autowired
    private ActivityRulePOMapper activityRulePOMapper;

    public List<Activity> getActivitySanList(String type, Integer merchantId) {
        Example example = new Example(Activity.class);
        example.setOrderByClause("id desc");
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("type", (Object)type).andEqualTo("valid", (Object)Boolean.TRUE);
        List list = this.activityMapper.selectByExample((Object)example);
        if (list.size() > 0) {
            for (Activity activity : list) {
                Example ruleExample = new Example(ActivityRule.class);
                ruleExample.createCriteria().andEqualTo("activityId", (Object)activity.getId());
                List ruleList = this.activityRuleMapper.selectByExample((Object)ruleExample);
                activity.setActivityRuleList(ruleList);
                if ("3".equals(type)) continue;
                for (ActivityRule rule : ruleList) {
                    if (activity.getType().equals(ActivitySanEnum.FULL_GIFT.getCode())) {
                        Example giftExample = new Example(ActivityRuleGift.class);
                        giftExample.createCriteria().andEqualTo("ruleId", (Object)rule.getId());
                        List gifts = this.activityRuleGiftMapper.selectByExample((Object)giftExample);
                        for (ActivityRuleGift ruleGift : gifts) {
                            Example goodExample = new Example(Goods.class);
                            Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey((Object)ruleGift.getGoodsId());
                            ruleGift.setGoodsName(goods != null ? goods.getGoodsName() : null);
                        }
                        rule.setActivityRuleGiftList(gifts);
                        continue;
                    }
                    if (!activity.getType().equals(ActivitySanEnum.COMBINATION.getCode())) continue;
                    Example comExample = new Example(ActivityRuleCombination.class);
                    comExample.createCriteria().andEqualTo("ruleId", (Object)rule.getId());
                    List combinations = this.activityRuleCombinationMapper.selectByExample((Object)comExample);
                    rule.setCombinations(combinations);
                }
            }
        }
        return list;
    }

    @Transactional
    public void addActivitySan(Activity activity) {
        Example example = new Example(Activity.class);
        example.createCriteria().andEqualTo("name", (Object)activity.getName()).andEqualTo("type", (Object)activity.getType()).andEqualTo("merchantId", (Object)activity.getMerchantId());
        List cfList = this.activityMapper.selectByExample((Object)example);
        if (cfList.size() > 0) {
            throw new CustomException("\u6b64\u6d3b\u52a8\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u540d\u79f0\uff01");
        }
        if (!activity.getType().equals(ActivitySanEnum.COMBINATION.getCode())) {
            Example validExample = new Example(Activity.class);
            validExample.createCriteria().andEqualTo("valid", (Object)Boolean.TRUE).andEqualTo("merchantId", (Object)activity.getMerchantId()).andEqualTo("type", (Object)activity.getType()).andCondition("DATE_FORMAT(NOW(),'%Y-%m-%d %H:%i:%S') BETWEEN DATE_FORMAT(begin_date,'%Y-%m-%d %H:%i:%S') AND DATE_FORMAT(end_date,'%Y-%m-%d %H:%i:%S')").andEqualTo("status", (Object)Boolean.TRUE);
            List activities = this.activityMapper.selectByExample((Object)validExample);
            if (activities.size() > 0) {
                throw new CustomException("\u6b64\u6d3b\u52a8\u5728\u6709\u6548\u65f6\u95f4\u5185\u5df2\u5b58\u5728\u4e00\u4e2a\uff0c\u60a8\u53ef\u4ee5\u5728\u5df2\u6709\u7684\u6d3b\u52a8\u4e2d\u6dfb\u52a0\u7b56\u7565\uff01");
            }
        }
        this.activityMapper.insertSelective((Object)activity);
        List list = activity.getActivityRuleList();
        for (ActivityRule rule : list) {
            Object combination2;
            rule.setActivityId(activity.getId());
            rule.setActivityType(activity.getType().toString());
            rule.setCombinationNum(Integer.valueOf(rule.getCombinations() == null ? 0 : rule.getCombinations().size()));
            this.activityRuleMapper.insertSelective((Object)rule);
            if (activity.getType().equals(ActivitySanEnum.FULL_GIFT.getCode())) {
                List giftList = rule.getActivityRuleGiftList();
                for (ActivityRuleGift gift : giftList) {
                    gift.setRuleId(rule.getId());
                    this.activityRuleGiftMapper.insertSelective((Object)gift);
                }
                continue;
            }
            if (activity.getType().equals(ActivitySanEnum.COMBINATION.getCode())) {
                List combinations = rule.getCombinations();
                if (this.getComRules(combinations)) {
                    throw new CustomException("\u6b64\u7ec4\u5408\u5546\u54c1\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u5546\u54c1");
                }
                for (Object combination2 : combinations) {
                    combination2.setRuleId(rule.getId());
                    this.activityRuleCombinationMapper.insertSelective(combination2);
                }
                continue;
            }
            if (!activity.getType().equals(ActivitySanEnum.FULL_REDUCTION.getCode()) || activity.getGoodsList() == null || activity.getGoodsList().isEmpty()) continue;
            List finishedAddActivity = this.activityMapper.selectByExample((Object)example);
            if (finishedAddActivity.isEmpty()) {
                throw new CustomException("\u6b64\u6d3b\u52a8\u63d2\u5165\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u5904\u7406\uff01");
            }
            Integer activityId = ((Activity)finishedAddActivity.get(0)).getId();
            log.info("\u8fdb\u884c\u6ee1\u51cf\u5546\u54c1\u63d2\u5165\u64cd\u4f5c param:{}", JSON.toJSON((Object)activity.getGoodsList()));
            combination2 = activity.getGoodsList().iterator();
            while (combination2.hasNext()) {
                ActivityGoods activityGoods = (ActivityGoods)combination2.next();
                activityGoods.setActivityId(activityId);
            }
            log.info("param:{}", JSON.toJSON((Object)activity.getGoodsList()));
            Integer insertResult = this.activityGoodsMapper.insertGoodsByActivity(activity.getGoodsList());
            log.info("\u6dfb\u52a0\u540e\u7684\u7ed3\u679c\u6570\u636e param:{}", (Object)insertResult);
        }
    }

    public Activity getActivityById(Integer id) {
        Activity activity = (Activity)this.activityMapper.selectByPrimaryKey((Object)id);
        if (activity == null) {
            return null;
        }
        Example example = new Example(ActivityRule.class);
        example.createCriteria().andEqualTo("activityId", (Object)id);
        List list = this.activityRuleMapper.selectByExample((Object)example);
        activity.setActivityRuleList(list);
        for (ActivityRule rule : list) {
            if (activity.getType().equals(ActivitySanEnum.FULL_GIFT.getCode())) {
                Example giftExample = new Example(ActivityRuleGift.class);
                giftExample.createCriteria().andEqualTo("ruleId", (Object)rule.getId());
                List gifts = this.activityRuleGiftMapper.selectByExample((Object)giftExample);
                Iterator iterator = gifts.iterator();
                while (iterator.hasNext()) {
                    ActivityRuleGift ruleGift;
                    Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey((Object)(ruleGift = (ActivityRuleGift)iterator.next()).getGoodsId());
                    ruleGift.setGoodsName(goods != null ? goods.getGoodsName() : null);
                }
                rule.setActivityRuleGiftList(gifts);
                continue;
            }
            if (activity.getType().equals(ActivitySanEnum.COMBINATION.getCode())) {
                Example comExample = new Example(ActivityRuleCombination.class);
                comExample.createCriteria().andEqualTo("ruleId", (Object)rule.getId());
                List combinations = this.activityRuleCombinationMapper.selectByExample((Object)comExample);
                rule.setCombinations(combinations);
                continue;
            }
            if (!activity.getType().equals(ActivitySanEnum.FULL_REDUCTION.getCode())) continue;
            List goodIds = this.activityGoodsMapper.selectActivityGoodsIdsByActivityId(id);
            log.info("\u53c2\u4e0e\u6d3b\u52a8\u7684\u5546\u54c1List:{}", (Object)goodIds);
            if (goodIds.size() <= 0) continue;
            List goods = this.goodsMapper.selectGoodListByGoodIds(goodIds);
            activity.setGoods(goods);
        }
        return activity;
    }

    @Transactional
    public int deleteActivity(Integer activityId) {
        log.info("ActivitySanServiceImpl#deleteActivity activityId:{}", (Object)JSON.toJSONString((Object)activityId));
        int i = 0;
        Activity activity = (Activity)this.activityMapper.selectByPrimaryKey((Object)activityId);
        Example example = new Example(ActivityRule.class);
        example.createCriteria().andEqualTo("activityId", (Object)activityId);
        List rules = this.activityRuleMapper.selectByExample((Object)example);
        for (ActivityRule rule : rules) {
            if (rule.getId() == null) continue;
            if (ActivitySanEnum.FULL_GIFT.getCode().equals(activity.getType())) {
                ActivityRuleGiftPOExample activityRuleGiftPOExample = new ActivityRuleGiftPOExample();
                activityRuleGiftPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andRuleIdEqualTo(rule.getId());
                i += this.activityRuleGiftPOMapper.deleteByExample(activityRuleGiftPOExample);
                continue;
            }
            if (ActivitySanEnum.COMBINATION.getCode().equals(activity.getType())) {
                ActivityRuleCombinationPOExample activityRuleCombinationPOExample = new ActivityRuleCombinationPOExample();
                activityRuleCombinationPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andRuleIdEqualTo(rule.getId());
                i += this.activityRuleCombinationPOMapper.deleteByExample(activityRuleCombinationPOExample);
                continue;
            }
            if (!ActivitySanEnum.FULL_REDUCTION.getCode().equals(activity.getType())) continue;
            log.info("\u6ee1\u51cf\u6d3b\u52a8\u5220\u9664\u5546\u54c1");
            ActivityGoodsPOExample activityGoodsPOExample = new ActivityGoodsPOExample();
            activityGoodsPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andActivityIdEqualTo(activityId);
            this.activityGoodsPOMapper.deleteByExample(activityGoodsPOExample);
        }
        ActivityRulePOExample activityRulePOExample = new ActivityRulePOExample();
        activityRulePOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andActivityIdEqualTo(activityId);
        this.activityRulePOMapper.deleteByExample(activityRulePOExample);
        Activity deleteActivity = new Activity();
        deleteActivity.setValid(Boolean.FALSE);
        deleteActivity.setId(activityId);
        i = this.activityMapper.updateByPrimaryKeySelective((Object)deleteActivity);
        return i;
    }

    @Transactional
    public void updateActivity(Activity activity) {
        log.info("ActivitySanServiceImpl#updateActivity activity:{}", (Object)JSON.toJSONString((Object)activity));
        Example cfExample = new Example(Activity.class);
        cfExample.createCriteria().andEqualTo("name", (Object)activity.getName()).andEqualTo("type", (Object)activity.getType()).andEqualTo("merchantId", (Object)activity.getMerchantId()).andNotEqualTo("id", (Object)activity.getId());
        List cfList = this.activityMapper.selectByExample((Object)cfExample);
        if (cfList.size() > 0) {
            throw new CustomException("\u6b64\u6d3b\u52a8\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u540d\u79f0\uff01");
        }
        this.activityMapper.updateByPrimaryKeySelective((Object)activity);
        Example example = new Example(ActivityRule.class);
        example.createCriteria().andEqualTo("activityId", (Object)activity.getId());
        List rules = this.activityRuleMapper.selectByExample((Object)example);
        for (ActivityRule rule : rules) {
            if (rule.getId() == null) continue;
            if (ActivitySanEnum.FULL_GIFT.getCode().equals(activity.getType())) {
                ActivityRuleGiftPOExample activityRuleGiftPOExample = new ActivityRuleGiftPOExample();
                activityRuleGiftPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andRuleIdEqualTo(rule.getId());
                this.activityRuleGiftPOMapper.deleteByExample(activityRuleGiftPOExample);
                continue;
            }
            if (ActivitySanEnum.COMBINATION.getCode().equals(activity.getType())) {
                ActivityRuleCombinationPOExample activityRuleCombinationPOExample = new ActivityRuleCombinationPOExample();
                activityRuleCombinationPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andRuleIdEqualTo(rule.getId());
                this.activityRuleCombinationPOMapper.deleteByExample(activityRuleCombinationPOExample);
                continue;
            }
            if (!ActivitySanEnum.FULL_REDUCTION.getCode().equals(activity.getType())) continue;
            log.info("\u6ee1\u51cf\u6d3b\u52a8\u4fee\u6539\u5546\u54c1");
            ActivityGoodsPOExample activityGoodsPOExample = new ActivityGoodsPOExample();
            activityGoodsPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andActivityIdEqualTo(activity.getId());
            this.activityGoodsPOMapper.deleteByExample(activityGoodsPOExample);
            if (CollectionUtils.isEmpty((Collection)activity.getGoodsList())) continue;
            for (ActivityGoods goods : activity.getGoodsList()) {
                List activityGoods = this.activityGoodsMapper.selectActivityByGoodId(goods.getGoodsId(), ActivitySanEnum.FULL_REDUCTION.getCode());
                if (activityGoods.size() <= 0) continue;
                throw new CustomException("\u6d3b\u52a8\u5546\u54c1\u6dfb\u52a0\u5931\u8d25\uff0c\u8be5\u5546\u54c1\u53c2\u4e0e\u5176\u4ed6\u6d3b\u52a8!");
            }
            this.activityGoodsMapper.insertGoodsByActivity(activity.getGoodsList());
        }
        ActivityRulePOExample activityRulePOExample = new ActivityRulePOExample();
        activityRulePOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andActivityIdEqualTo(activity.getId());
        this.activityRulePOMapper.deleteByExample(activityRulePOExample);
        List list = activity.getActivityRuleList();
        for (ActivityRule rule : list) {
            rule.setActivityId(activity.getId());
            rule.setActivityType(activity.getType().toString());
            rule.setCombinationNum(Integer.valueOf(rule.getCombinations() == null ? 0 : rule.getCombinations().size()));
            this.activityRuleMapper.insertSelective((Object)rule);
            if (ActivitySanEnum.FULL_GIFT.getCode().equals(activity.getType())) {
                List giftList = rule.getActivityRuleGiftList();
                for (ActivityRuleGift gift : giftList) {
                    gift.setRuleId(rule.getId());
                    this.activityRuleGiftMapper.insertSelective((Object)gift);
                }
                continue;
            }
            if (!activity.getType().equals(ActivitySanEnum.COMBINATION.getCode())) continue;
            List combinationList = rule.getCombinations();
            if (this.getComRules(combinationList)) {
                throw new CustomException("\u6b64\u7ec4\u5408\u5546\u54c1\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u5546\u54c1");
            }
            for (ActivityRuleCombination combination : combinationList) {
                combination.setRuleId(rule.getId());
                this.activityRuleCombinationMapper.insertSelective((Object)combination);
            }
        }
    }

    public List<ActivityGoods> checkGoodInActivity(ArrayList<ActivityGoods> goodsList) {
        Iterator<ActivityGoods> goodsIterator = goodsList.iterator();
        ArrayList<ActivityGoods> result = new ArrayList<ActivityGoods>();
        while (goodsIterator.hasNext()) {
            ActivityGoods good = goodsIterator.next();
            List activityGoods = this.activityGoodsMapper.selectActivityByGoodId(good.getGoodsId(), null);
            List activityGifts = this.activityGiftMapper.selectActivityByGoodId(good.getGoodsId(), null);
            List activityRuleCombinationIds = this.activityRuleCombinationMapper.selectActivityByGoodId(good.getGoodsId(), null);
            Integer sum = activityGoods.size() + activityGifts.size() + activityRuleCombinationIds.size();
            log.info("\u8be5\u5546\u54c1\u53c2\u4e0e\u7684\u6d3b\u52a8\u6709 \u6ee1\u51cf\u6298\u6263\uff1a{}\uff0c\u6ee1\u8d60\uff1a{}\uff0c\u7ec4\u5408\u5546\u54c1\uff1a{}", new Object[]{JSON.toJSON((Object)activityGoods), JSON.toJSON((Object)activityGifts), JSON.toJSON((Object)activityRuleCombinationIds)});
            Goods good1 = this.goodsMapper.selectById(good.getGoodsId());
            good.setGoodsName(good1.getGoodsName());
            if (sum > 0) {
                log.info("\u6d3b\u52a8\u5546\u54c1\u8868\u4e2d\u6709\u6570\u636e");
                result.add(good);
                continue;
            }
            if (GoodsIsGift.GIFT.getCode().equals(good1.getIsGift())) {
                log.info("\u8be5\u5546\u54c1\u662f\u793c\u54c1");
                result.add(good);
                continue;
            }
            if (!Boolean.TRUE.equals(good1.getIsDel())) continue;
            log.info("\u8be5\u5546\u54c1\u5df2\u7ecf\u88ab\u5220\u9664");
            result.add(good);
        }
        return result;
    }

    public List<ActivityGoods> compare(List<ActivityGoods> a, List<ActivityGoods> b, Integer activityId) {
        HashMap<Integer, Integer> test = new HashMap<Integer, Integer>();
        ArrayList<ActivityGoods> result = new ArrayList<ActivityGoods>();
        for (ActivityGoods good : a) {
            if (good.getGoodsId() == null) continue;
            test.put(good.getGoodsId(), 1);
        }
        for (ActivityGoods good : b) {
            if (good.getGoodsId() == null || test.get(good.getGoodsId()) != null) continue;
            good.setActivityId(activityId);
            result.add(good);
        }
        return result;
    }

    private boolean getComRules(List<ActivityRuleCombination> combinationList) {
        boolean flag = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < combinationList.size(); ++i) {
            if (i != combinationList.size() - 1) {
                stringBuffer.append(combinationList.get(i).getGoodsId()).append(",");
                continue;
            }
            stringBuffer.append(combinationList.get(i).getGoodsId());
        }
        Example example = new Example(ActivityRule.class);
        example.createCriteria().andEqualTo("activityType", (Object)"4");
        List rules = this.activityRuleMapper.selectByExample((Object)example);
        for (ActivityRule rule : rules) {
            Example comExample = new Example(ActivityRuleCombination.class);
            comExample.createCriteria().andEqualTo("ruleId", (Object)rule.getId());
            List combinations = this.activityRuleCombinationMapper.selectByExample((Object)comExample);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < combinations.size(); ++i) {
                if (i != combinations.size() - 1) {
                    sb.append(((ActivityRuleCombination)combinations.get(i)).getGoodsId()).append(",");
                    continue;
                }
                sb.append(((ActivityRuleCombination)combinations.get(i)).getGoodsId());
            }
            if (!this.isScrambledString(stringBuffer.toString(), sb.toString())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private boolean isScrambledString(String source, String target) {
        Integer count;
        if (source.length() != target.length()) {
            System.out.println("target string's length is not equal to source length.");
            return false;
        }
        int length = source.length();
        HashMap<Character, Integer> targetCount = new HashMap<Character, Integer>();
        for (int i = 0; i < length; ++i) {
            char c = target.charAt(i);
            int indexOfSource = source.indexOf(c);
            if (indexOfSource == -1) {
                return false;
            }
            if (targetCount.get(Character.valueOf(c)) == null) {
                targetCount.put(Character.valueOf(c), 1);
                continue;
            }
            count = (Integer)targetCount.get(Character.valueOf(c));
            targetCount.put(Character.valueOf(c), 1 + count);
        }
        HashMap<Character, Integer> sourceCount = new HashMap<Character, Integer>();
        for (int i = 0; i < length; ++i) {
            char c = source.charAt(i);
            if (sourceCount.get(Character.valueOf(c)) == null) {
                sourceCount.put(Character.valueOf(c), 1);
                continue;
            }
            count = (Integer)sourceCount.get(Character.valueOf(c));
            sourceCount.put(Character.valueOf(c), 1 + count);
        }
        for (Map.Entry entry : targetCount.entrySet()) {
            Character key = (Character)entry.getKey();
            if (!((Integer)entry.getValue()).equals(sourceCount.get(key))) continue;
            return false;
        }
        return true;
    }
}

