/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.integral;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.CommonUtil;
import com.wmeimob.fastboot.bizvane.config.BizvaneProperties;
import com.wmeimob.fastboot.bizvane.dto.SysStoreVo;
import com.wmeimob.fastboot.bizvane.dto.integral.IntegralGoodsDTO;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoods;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.IntegralGoodsService;
import com.wmeimob.fastboot.core.annotation.Page;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/integral/goods"})
@Api(description="\u79ef\u5206\u5546\u57ce\u5546\u54c1API")
public class IntegralGoodsController {
    private static final Logger log = LoggerFactory.getLogger(IntegralGoodsController.class);
    @Resource
    private BizvaneProperties bizvaneProperties;
    @Autowired
    private IntegralGoodsService integralGoodsService;
    @Autowired
    private IntegralGoodsMapper integralGoodsMapper;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private CompanyBrandRelationMapper companyBrandRelationMapper;
    @Autowired
    private ApplicationContext applicationContext;

    @ApiOperation(value="\u4fdd\u5b58\u4fee\u6539\u5546\u54c1")
    @RequestMapping(value={"/saveGoods"}, method={RequestMethod.POST})
    public RestResult saveGoods(@RequestBody IntegralGoods integralGoods) {
        if (CommonUtil.hasChinese((String)integralGoods.getGoodsNo())) {
            throw new CustomException("\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u5b58\u5728\u4e2d\u6587\uff01");
        }
        if (integralGoods.getId() == null) {
            log.info("\u5546\u54c1\u65b0\u589e\u65b9\u6cd5....");
            this.integralGoodsService.addGoods(integralGoods);
        } else {
            log.info("\u5546\u54c1\u4fee\u6539\u65b9\u6cd5....");
            this.integralGoodsService.updateGoods(integralGoods);
        }
        return RestResult.success();
    }

    @ApiOperation(value="\u5546\u54c1\u5206\u9875")
    @ApiImplicitParams(value={@ApiImplicitParam(name="merchantId", value="\u54c1\u724cid", dataType="int", paramType="query", required=true), @ApiImplicitParam(name="pageIndex", value="\u5f53\u524d\u9875\u6570", dataType="int", paramType="query", required=true), @ApiImplicitParam(name="pageSize", value="\u4e00\u9875\u5c55\u793a\u6570\u91cf", dataType="int", paramType="query", required=true), @ApiImplicitParam(name="searchValue", value="\u641c\u7d22", dataType="String", paramType="query", required=false)})
    @RequestMapping(value={"/getGoodsList"}, method={RequestMethod.GET})
    @Page
    public PageInfo getGoodsList(@RequestParam(value="merchantId") Integer merchantId, @RequestParam(value="searchValue", required=false) String searchValue, IntegralGoods integralGoods, Integer pageSize, Integer pageIndex) {
        log.info("\u67e5\u8be2\u6240\u6709\u5546\u54c1\u5206\u9875\u3002\u3002\u3002");
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List list = this.integralGoodsService.getGoods(merchantId, null, null, searchValue, "pc", integralGoods);
        return new PageInfo(list);
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1\u8be6\u60c5")
    @ApiImplicitParam(name="id", value="\u4e3b\u952eid", dataType="int", paramType="query", required=true)
    @RequestMapping(value={"/getGoodsDetail"}, method={RequestMethod.GET})
    public IntegralGoods getGoodsDetail(@RequestParam(value="id") Integer id) {
        log.info("\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u3002\u3002\u3002");
        IntegralGoods integralGoods = this.integralGoodsService.getGoodsById(id, "pc");
        return integralGoods;
    }

    @ApiOperation(value="\u5220\u9664\u5546\u54c1")
    @ApiImplicitParam(name="id", value="\u4e3b\u952eid", dataType="int", paramType="query", required=true)
    @RequestMapping(value={"/deleteGoods"}, method={RequestMethod.GET})
    public RestResult deleteGoods(@RequestParam(value="id") Integer id) {
        log.info("\u5220\u9664\u5546\u54c1\u3002\u3002\u3002\u3002");
        this.integralGoodsService.deleteGoods(id);
        return RestResult.success();
    }

    @ApiOperation(value="\u6279\u91cf\u4e0a\u4e0b\u67b6")
    @RequestMapping(value={"/upperOrlower"}, method={RequestMethod.POST})
    public RestResult upperOrlower(@RequestBody IntegralGoodsDTO integralGoodsDTO) {
        log.info("\u6279\u91cf\u4e0a\u4e0b\u67b6\u3002\u3002\u3002\u3002");
        if (integralGoodsDTO.getShelf() == null || integralGoodsDTO.getGoodIds() == null) {
            return RestResult.fail((String)"\u53c2\u6570\u6709\u8bef");
        }
        for (Integer id : integralGoodsDTO.getGoodIds()) {
            this.integralGoodsService.upperOrlower(id, integralGoodsDTO.getShelf());
        }
        return RestResult.success();
    }

    @ApiOperation(value="\u6821\u9a8c\u79ef\u5206\u5546\u54c1\u662f\u5426\u5c5e\u4e8e\u5206\u7c7b")
    @RequestMapping(value={"/checkIntegralGoods"}, method={RequestMethod.POST})
    public JSONObject checkIntegralGoods(@RequestBody IntegralGoods integralGoods) {
        log.info("\u6821\u9a8c\u79ef\u5206\u5546\u54c1\u662f\u5426\u5c5e\u4e8e\u5206\u7c7b:[{}]", JSON.toJSON((Object)integralGoods));
        JSONObject result = new JSONObject();
        result.put("code", (Object)-1);
        if (StringUtils.isEmpty((Object)integralGoods.getClassifyId()) || StringUtils.isEmpty((Object)integralGoods.getGoodsNo()) || integralGoods.getMerchantId() == null) {
            result.put("msg", (Object)"\u5fc5\u4f20\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return result;
        }
        IntegralGoods param = new IntegralGoods();
        param.setMerchantId(integralGoods.getMerchantId());
        param.setValid(Boolean.valueOf(true));
        param.setShelf(Boolean.valueOf(true));
        param.setGoodsNo(integralGoods.getGoodsNo());
        param = (IntegralGoods)this.integralGoodsMapper.selectOne((Object)param);
        if (param == null) {
            if (integralGoods.getMerchantId() == 18 && integralGoods.getGoodsNo().startsWith("NC")) {
                BizvaneInterface bizvaneInterface = new BizvaneInterface();
                String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getAppletQueryCouponByExchangeCodeUrl();
                log.info("url:{}", (Object)url);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("exchangeCode", (Object)integralGoods.getGoodsNo());
                JSONObject result1 = JSONObject.parseObject((String)bizvaneInterface.HttpPostWithJson(url, jsonObject.toJSONString()));
                JSONArray couponList = (JSONArray)result1.get((Object)"data");
                if (couponList.size() < 1) {
                    result.put("msg", (Object)"\u672a\u627e\u5230\u8be5\u5546\u54c1,\u8bf7\u67e5\u770b\u5546\u54c1\u662f\u5426\u4e0a\u67b6\u548c\u6709\u6548\uff01");
                    return result;
                }
                log.info("json:{}", couponList.get(0));
                JSONObject CouponIntegralExchangePO = (JSONObject)couponList.get(0);
                IntegralGoods couponGood = new IntegralGoods();
                couponGood.setId((Integer)CouponIntegralExchangePO.get((Object)"exchangeId"));
                couponGood.setGoodsNo(String.valueOf(CouponIntegralExchangePO.get((Object)"exchangeCode") != null ? CouponIntegralExchangePO.get((Object)"exchangeCode") : ""));
                couponGood.setGoodsName(String.valueOf(CouponIntegralExchangePO.get((Object)"couponName") != null ? CouponIntegralExchangePO.get((Object)"couponName") : ""));
                couponGood.setShelf(Boolean.TRUE);
                result.put("code", (Object)0);
                result.put("data", (Object)couponGood);
                return result;
            }
            result.put("msg", (Object)"\u672a\u627e\u5230\u8be5\u5546\u54c1,\u8bf7\u67e5\u770b\u5546\u54c1\u662f\u5426\u4e0a\u67b6\u548c\u6709\u6548\uff01");
            return result;
        }
        if (StringUtils.isEmpty((Object)param.getClassifyId())) {
            result.put("msg", (Object)"\u8be5\u5546\u54c1\u6682\u65f6\u6ca1\u6709\u5206\u7c7b\uff0c\u8bf7\u6dfb\u52a0\u5206\u7c7b\uff01");
            return result;
        }
        if (Arrays.stream(param.getClassifyId().split(",")).filter(e -> integralGoods.getClassifyId().equals(e)).findAny().isPresent()) {
            result.put("code", (Object)0);
            result.put("data", (Object)param);
            return result;
        }
        result.put("msg", (Object)"\u8be5\u5546\u54c1\u548c\u5206\u7c7b\u4e0d\u5339\u914d\uff01");
        return result;
    }

    @PostMapping(value={"getStoreList"})
    public JSONObject getStoreList(@RequestBody SysStoreVo vo) {
        log.info("getStoreList\u7684\u5165\u53c2:[{}]", JSON.toJSON((Object)vo));
        JSONObject result = new JSONObject();
        result.put("code", (Object)-1);
        if (StringUtils.isEmpty((Object)vo.getSysCompanyId()) || vo.getSysBrandId() == null) {
            result.put("msg", (Object)"\u5fc5\u4f20\u53c2\u6570\u4e3a\u7a7a");
            return result;
        }
        JSONObject storeListName = this.bizvaneInterface.getStoreListName(vo);
        log.info("\u79ef\u5206\u5546\u57ce\u83b7\u53d6\u54c1\u724c\u4e0b\u7684\u6240\u6709\u95e8\u5e97\u8fd4\u56de\u53c2\u6570:[{}]", (Object)storeListName.toString());
        return storeListName;
    }

    @GetMapping(value={"getLevelList"})
    public JSONObject getLevelList(@RequestParam(value="brandId") Long brandId) {
        JSONObject result = new JSONObject();
        result.put("code", (Object)-1);
        if (brandId == null) {
            result.put("msg", (Object)"\u5fc5\u4f20\u53c2\u6570\u4e3a\u7a7a");
            return result;
        }
        return this.bizvaneInterface.getLevelList(brandId);
    }
}

