/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.api;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.api.vo.ApiModifyStockRequestVO;
import com.wmeimob.fastboot.bizvane.service.admin.ApiService;
import com.wmeimob.fastboot.bizvane.service.api.ApiStockService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.util.InputValidator;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"apiStock"})
public class ApiStockController {
    private static final Logger log = LoggerFactory.getLogger(ApiStockController.class);
    @Resource
    private ApiStockService apiStockService;
    @Autowired
    private ApiService apiService;

    @PostMapping(value={"/modify"})
    @ResponseBody
    public ResponseData updateStock(@RequestBody ApiModifyStockRequestVO requestVO) {
        log.info("ApiStockController_updateStock_param:{},\u9700\u8981\u66f4\u65b0\u5e93\u5b58\u7684SKU:{}", (Object)JSON.toJSONString((Object)requestVO), (Object)requestVO.getSkuNo());
        String shopCode = requestVO.getShopCode();
        String merchantId = this.apiService.checkStoreAuth(requestVO.getToken(), shopCode);
        requestVO.setMerchantId(merchantId);
        String skuNo = requestVO.getSkuNo();
        InputValidator.checkEmpty((Object)skuNo, (String)"skuNo");
        String stock = requestVO.getStock();
        InputValidator.checkEmpty((Object)stock, (String)"stock");
        ResponseData responseData = this.apiStockService.updateStock(requestVO);
        return responseData;
    }
}

