/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.wmeimob.fastboot.bizvane.entity.MarketActivity;
import com.wmeimob.fastboot.bizvane.service.CutDownService;
import com.wmeimob.fastboot.bizvane.service.MarketActivityService;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"cutDown"})
public class CutDownController {
    private static final Logger log = LoggerFactory.getLogger(CutDownController.class);
    @Autowired
    private CutDownService cutDownService;
    @Autowired
    private MarketActivityService marketActivityService;

    @GetMapping(value={"{id}"})
    public MarketActivity getDetail(@PathVariable(value="id") Integer id) {
        return this.marketActivityService.getMarketDetail(id);
    }

    @GetMapping(value={"/analysis"})
    @ResponseBody
    public RestResult cutDownAnalysis(@RequestParam(value="id") String id) {
        try {
            Map result = this.cutDownService.analysis(id);
            return RestResult.success((Map)result);
        }
        catch (Exception e) {
            return RestResult.fail((String)e.getMessage());
        }
    }
}

