/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.logistics.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mzlion.easyokhttp.HttpClient;
import com.wmeimob.fastboot.bizvane.exception.MallCommonException;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralCourierCompanyPOMapper;
import com.wmeimob.fastboot.bizvane.po.IntegralCourierCompanyPO;
import com.wmeimob.fastboot.bizvane.service.logistics.LogisticsService;
import com.wmeimob.fastboot.bizvane.vo.logistics.CourierCompanyCodeResponseVO;
import com.wmeimob.fastboot.bizvane.vo.logistics.CourierCompanyInfoResponseVO;
import com.wmeimob.fastboot.bizvane.vo.logistics.LogisticsInfoDetailsResponseVO;
import com.wmeimob.fastboot.bizvane.vo.logistics.QueryLogisticsInfoDetailsRequestVO;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LogisticsServiceImpl
implements LogisticsService {
    private static final Logger log = LoggerFactory.getLogger(LogisticsServiceImpl.class);
    @Value(value="${kuaidi100.key}")
    private String key;
    @Value(value="${kuaidi100.customer}")
    private String customer;
    @Value(value="${kuaidi100.urlA}")
    private String urlA;
    @Value(value="${kuaidi100.urlB}")
    private String urlB;
    @Resource
    private IntegralCourierCompanyPOMapper integralCourierCompanyPoMapper;

    @Override
    public List<CourierCompanyCodeResponseVO> courierCompanyCodeTirByCourierCode(String courierCode) {
        log.info("LogisticsServiceImpl#courierCompanyCodeTirByCourierCode:\u5feb\u9012\u5355\u53f7={}", (Object)courierCode);
        try {
            InputValidator.checkEmpty((Object)this.urlB, (String)"urlB\u4e3a\u7a7a");
            InputValidator.checkEmpty((Object)this.key, (String)"key\u4e3a\u7a7a");
            InputValidator.checkEmpty((Object)courierCode, (String)"\u5feb\u9012\u5355\u53f7\u4e3a\u7a7a");
            StringBuilder params = new StringBuilder();
            params.append(this.urlB).append("?").append("num=").append(courierCode).append("&key=").append(this.key);
            CourierCompanyCodeResponseVO courierCompanyCodeResponseVO = (CourierCompanyCodeResponseVO)HttpClient.get((String)"http://www.kuaidi100.com/autonumber/auto?num=9899036063096&key=NFFfsVSO6034").asBean(CourierCompanyCodeResponseVO.class);
            return null;
        }
        catch (Exception e) {
            log.warn("\u5feb\u9012100\u667a\u80fd\u5355\u53f7\u8bc6\u522bAPI\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallCommonException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<CourierCompanyInfoResponseVO> queryCourierCompany() {
        try {
            List integralCourierCompanyList = this.integralCourierCompanyPoMapper.selectByExample(null);
            if (CollectionUtils.isEmpty((Collection)integralCourierCompanyList)) {
                return null;
            }
            List<CourierCompanyInfoResponseVO> list = this.convertPoToVo(integralCourierCompanyList);
            log.info("list:{}", (Object)JSON.toJSONString(list));
            return list;
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u5feb\u9012\u516c\u53f8\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallCommonException(e.getMessage());
        }
    }

    @Override
    public LogisticsInfoDetailsResponseVO queryLogisticsInfoDetailsBy100(QueryLogisticsInfoDetailsRequestVO requestVo) {
        log.info("LogisticsServiceImpl#queryLogisticsInfoDetailsBy100:{}", (Object)JSON.toJSONString((Object)requestVo));
        try {
            InputValidator.checkEmpty((Object)requestVo.getMerchantId(), (String)"\u5546\u6237ID");
            InputValidator.checkEmpty((Object)requestVo.getCourierCode(), (String)"\u5feb\u9012\u5355\u53f7");
            String courierCompanyCode = requestVo.getCourierCompanyCode();
            JSONObject json = new JSONObject();
            json.put("com", (Object)courierCompanyCode);
            json.put("num", (Object)requestVo.getCourierCode());
            json.put("phone", (Object)requestVo.getConsigneePhone());
            String param = json.toJSONString();
            String sign = this.buildSign(param, this.key, this.customer);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("param", param);
            params.put("sign", sign);
            params.put("customer", this.customer);
            log.info("\u5feb\u9012100\u53c2\u6570===>{}", (Object)params.toString());
            String replace = this.urlA.replace("https", "http");
            JSONObject res = (JSONObject)HttpClient.post((String)replace).param(params).asBean(JSONObject.class);
            log.info("\u5feb\u9012\u67e5\u8be2\u7ed3\u679c{}", (Object)res.toString());
            if (res.getJSONArray("data") == null) {
                throw new MallAdminException("\u67e5\u8be2\u65e0\u7ed3\u679c\uff0c\u8bf7\u9694\u6bb5\u65f6\u95f4\u518d\u67e5");
            }
            LogisticsInfoDetailsResponseVO result = null;
            try {
                result = (LogisticsInfoDetailsResponseVO)JSONObject.parseObject((String)res.getJSONArray("data").toString(), LogisticsInfoDetailsResponseVO.class);
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            }
            return result;
        }
        catch (Exception e) {
            log.warn("\u901a\u8fc7\u5feb\u9012100\u516c\u5171API\u83b7\u53d6\u7269\u6d41\u8be6\u60c5\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallAdminException(e.getMessage(), e);
        }
    }

    private String buildSign(String param, String key, String customer) {
        StringBuffer sb = new StringBuffer(param);
        sb.append(key).append(customer);
        System.out.println(sb.toString());
        String sign = DigestUtils.md5Hex((String)sb.toString()).toUpperCase();
        log.info("\u7ec4\u88c5\u7b7e\u540d\u7ed3\u679c==>:{}", (Object)sign);
        return sign;
    }

    private List<CourierCompanyInfoResponseVO> convertPoToVo(List<IntegralCourierCompanyPO> integralCourierCompanyList) {
        ArrayList<CourierCompanyInfoResponseVO> courierCompanyInfoResponseVoS = new ArrayList<CourierCompanyInfoResponseVO>();
        integralCourierCompanyList.forEach(po -> {
            CourierCompanyInfoResponseVO vo = new CourierCompanyInfoResponseVO();
            vo.setName(po.getName());
            vo.setCode(po.getCode());
            courierCompanyInfoResponseVoS.add(vo);
        });
        return courierCompanyInfoResponseVoS;
    }
}

