/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.goods_group;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.po.GoodsGroupPO;
import com.wmeimob.fastboot.bizvane.service.CompanyBrandRelationService;
import com.wmeimob.fastboot.bizvane.service.goodsgroup.GoodsGroupService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.goodsgroup.GoodsGroupClassAddResquestVO;
import com.wmeimob.fastboot.bizvane.vo.goodsgroup.GoodsGroupClassDeleteResquestVO;
import com.wmeimob.fastboot.bizvane.vo.goodsgroup.GoodsGroupClassUpdateResquestVO;
import com.wmeimob.fastboot.util.StringUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"goodsGroupClass"})
public class GoodsGroupClassController {
    private static final Logger log = LoggerFactory.getLogger(GoodsGroupClassController.class);
    @Autowired
    private GoodsGroupService goodsGroupService;
    @Autowired
    private CompanyBrandRelationService companyBrandRelationService;

    @PostMapping(value={"add"})
    public ResponseData addGroupClass(@RequestHeader Integer merchantId, @RequestBody GoodsGroupClassAddResquestVO vo) {
        log.info("GoodsGroupClassController addGroupClass merchantID:{} vo:{}", (Object)merchantId, JSON.toJSON((Object)((Object)vo)));
        if (StringUtils.isEmpty((Object)vo.getGoodsGroupName())) {
            return ResponseUtil.getFailedMsg((String)"\u4f20\u5165\u7684\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        vo.setMerchantId(merchantId);
        vo.setBrandId(this.companyBrandRelationService.getBrandIdByMerchantId(merchantId));
        vo.setPid(0);
        GoodsGroupPO goodsGroupPO = new GoodsGroupPO();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)goodsGroupPO);
        List<GoodsGroupPO> goodsGroupPOS = this.goodsGroupService.checkClassIfSameName(goodsGroupPO);
        log.info("\u67e5\u8be2\u5230\u540c\u540d\u7684\u5206\u7ec4\u5206\u7c7b\u662f:{}", JSON.toJSON(goodsGroupPOS));
        if (!CollectionUtils.isEmpty(goodsGroupPOS)) {
            return ResponseUtil.getFailedMsg((String)"\u6709\u540c\u540d\u5206\u7ec4\u5206\u7c7b");
        }
        return this.goodsGroupService.addGroupClass(vo);
    }

    @PostMapping(value={"delete"})
    public ResponseData deleteGroupClass(@RequestHeader Integer merchantId, @RequestBody GoodsGroupClassDeleteResquestVO vo) {
        log.info("GoodsGroupClassController deleteGroupClass merchantID:{} vo:{}", (Object)merchantId, JSON.toJSON((Object)((Object)vo)));
        if (vo.getId() == null) {
            return ResponseUtil.getFailedMsg((String)"\u5220\u9664\u5206\u7c7bid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        vo.setMerchantId(merchantId);
        List<GoodsGroupPO> goodsGroupPOS = this.goodsGroupService.checkClassInUsed(vo);
        log.info("\u67e5\u8be2\u5230\u4f7f\u7528\u8be5\u5206\u7ec4\u5206\u7c7b\u4fe1\u606f\u7684\u5206\u7ec4\u662f:{}", JSON.toJSON(goodsGroupPOS));
        if (!CollectionUtils.isEmpty(goodsGroupPOS)) {
            return ResponseUtil.getFailedMsg((String)"\u8be5\u5206\u7c7b\u88ab\u5206\u7ec4\u4f7f\u7528\u4e2d\uff0c\u6682\u65f6\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        return this.goodsGroupService.deleteGroupClass(vo);
    }

    @PostMapping(value={"update"})
    public ResponseData updateGroupClass(@RequestHeader Integer merchantId, @RequestBody GoodsGroupClassUpdateResquestVO vo) {
        log.info("GoodsGroupClassController deleteGroupClass merchantID:{} vo:{}", (Object)merchantId, JSON.toJSON((Object)((Object)vo)));
        if (vo.getId() == null) {
            return ResponseUtil.getFailedMsg((String)"\u4fee\u6539\u5206\u7c7bid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        vo.setMerchantId(merchantId);
        GoodsGroupPO goodsGroupPO = new GoodsGroupPO();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)goodsGroupPO);
        goodsGroupPO.setPid(Integer.valueOf(0));
        List<GoodsGroupPO> goodsGroupPOS = this.goodsGroupService.checkClassIfSameName(goodsGroupPO);
        log.info("\u67e5\u8be2\u5230\u540c\u540d\u7684\u5206\u7ec4\u5206\u7c7b\u662f:{}", JSON.toJSON(goodsGroupPOS));
        if (!CollectionUtils.isEmpty(goodsGroupPOS)) {
            return ResponseUtil.getFailedMsg((String)"\u6709\u540c\u540d\u5206\u7ec4\u5206\u7c7b");
        }
        return this.goodsGroupService.updateGroupClass(vo);
    }

    @PostMapping(value={"searchList"})
    public ResponseData searchList(@RequestHeader Integer merchantId) {
        log.info("GoodsGroupClassController updateGroupClass merchantID:{}", (Object)merchantId);
        return this.goodsGroupService.searchGroupClassList(merchantId);
    }
}

