/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.courier.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.newmapper.CourierPOMapper;
import com.wmeimob.fastboot.bizvane.po.CourierPO;
import com.wmeimob.fastboot.bizvane.po.CourierPOExample;
import com.wmeimob.fastboot.bizvane.service.courier.CourierNewService;
import com.wmeimob.fastboot.bizvane.vo.courier.AddCourierRequestVO;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CourierNewServiceImpl
implements CourierNewService {
    private static final Logger log = LoggerFactory.getLogger(CourierNewServiceImpl.class);
    @Resource
    private CourierPOMapper courierPoMapper;

    public void addCourierCompany(AddCourierRequestVO addCourierRequestVo) {
        log.info("CourierNewServiceImpl#addCourierCompany:{}", (Object)JSON.toJSONString((Object)addCourierRequestVo));
        try {
            InputValidator.checkEmpty((Object)addCourierRequestVo.getMerchantId(), (String)"\u5546\u6237id");
            InputValidator.checkEmpty((Object)addCourierRequestVo.getName(), (String)"\u516c\u53f8\u540d\u79f0");
            InputValidator.checkEmpty((Object)addCourierRequestVo.getCode(), (String)"\u516c\u53f8\u7f16\u53f7");
            InputValidator.checkLengthRange((Object)addCourierRequestVo.getName(), (int)1, (int)15, (String)"\u516c\u53f8\u540d\u79f0");
            CourierPOExample courierPoByNameExample = new CourierPOExample();
            courierPoByNameExample.createCriteria().andNameEqualTo(addCourierRequestVo.getName()).andMerchantIdEqualTo(addCourierRequestVo.getMerchantId()).andValidEqualTo(Boolean.TRUE);
            List poByNameList = this.courierPoMapper.selectByExample(courierPoByNameExample);
            if (!CollectionUtils.isEmpty((Collection)poByNameList)) {
                throw new MallAdminException("\u4e0e\u73b0\u6709\u7684\u516c\u53f8\u540d\u79f0\u91cd\u590d,\u5efa\u8bae\u4f7f\u7528\u5feb\u9012100\u4e2d\u7684\u6807\u51c6\u540d\u79f0\uff01");
            }
            CourierPOExample courierPoByCodeExample = new CourierPOExample();
            courierPoByCodeExample.createCriteria().andCodeEqualTo(addCourierRequestVo.getCode()).andMerchantIdEqualTo(addCourierRequestVo.getMerchantId()).andValidEqualTo(Boolean.TRUE);
            List poByCodeList = this.courierPoMapper.selectByExample(courierPoByCodeExample);
            if (!CollectionUtils.isEmpty((Collection)poByCodeList)) {
                throw new MallAdminException("\u4e0e\u73b0\u6709\u7684\u516c\u53f8\u7f16\u53f7\u91cd\u590d,\u5efa\u8bae\u4f7f\u7528\u5feb\u9012100\u4e2d\u7684\u6807\u51c6\u7f16\u53f7\uff01");
            }
            CourierPO insertCourierPo = new CourierPO();
            insertCourierPo.setName(addCourierRequestVo.getName());
            insertCourierPo.setCode(addCourierRequestVo.getCode());
            insertCourierPo.setMerchantId(addCourierRequestVo.getMerchantId());
            insertCourierPo.setGmtCreate(new Date());
            insertCourierPo.setValid(Boolean.TRUE);
            this.courierPoMapper.insertSelective(insertCourierPo);
        }
        catch (Exception e) {
            log.warn("\u65b0\u589e\u5feb\u9012\u516c\u53f8\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallAdminException(e.getMessage());
        }
    }

    public void updateCourierCompany(AddCourierRequestVO updateCourierRequestVO) {
        log.info("CourierNewServiceImpl#updateCourierCompany:{}", (Object)JSON.toJSONString((Object)updateCourierRequestVO));
        try {
            InputValidator.checkEmpty((Object)updateCourierRequestVO.getMerchantId(), (String)"\u5546\u6237ID");
            InputValidator.checkEmpty((Object)updateCourierRequestVO.getId(), (String)"ID");
            InputValidator.checkEmpty((Object)updateCourierRequestVO.getName(), (String)"\u5feb\u9012\u516c\u53f8\u540d\u79f0");
            InputValidator.checkEmpty((Object)updateCourierRequestVO.getCode(), (String)"\u5feb\u9012\u516c\u53f8\u7f16\u53f7");
            InputValidator.checkLengthRange((Object)updateCourierRequestVO.getName(), (int)1, (int)15, (String)"\u5feb\u9012\u516c\u53f8\u540d\u79f0");
            CourierPOExample courierPoByNameExample = new CourierPOExample();
            courierPoByNameExample.createCriteria().andNameEqualTo(updateCourierRequestVO.getName()).andMerchantIdEqualTo(updateCourierRequestVO.getMerchantId()).andValidEqualTo(Boolean.TRUE);
            List poByNameList = this.courierPoMapper.selectByExample(courierPoByNameExample);
            if (!CollectionUtils.isEmpty((Collection)poByNameList)) {
                throw new MallAdminException("\u4e0e\u73b0\u6709\u7684\u516c\u53f8\u540d\u79f0\u91cd\u590d,\u5efa\u8bae\u4f7f\u7528\u5feb\u9012100\u4e2d\u7684\u6807\u51c6\u540d\u79f0\uff01");
            }
            CourierPOExample courierPoByCodeExample = new CourierPOExample();
            courierPoByCodeExample.createCriteria().andCodeEqualTo(updateCourierRequestVO.getCode()).andMerchantIdEqualTo(updateCourierRequestVO.getMerchantId()).andValidEqualTo(Boolean.TRUE);
            List poByCodeList = this.courierPoMapper.selectByExample(courierPoByCodeExample);
            if (!CollectionUtils.isEmpty((Collection)poByCodeList)) {
                throw new MallAdminException("\u4e0e\u73b0\u6709\u7684\u516c\u53f8\u7f16\u53f7\u91cd\u590d,\u5efa\u8bae\u4f7f\u7528\u5feb\u9012100\u4e2d\u7684\u6807\u51c6\u7f16\u53f7\uff01");
            }
            CourierPO updateCourierPo = new CourierPO();
            updateCourierPo.setId(updateCourierRequestVO.getId());
            updateCourierPo.setName(updateCourierRequestVO.getName());
            updateCourierPo.setCode(updateCourierRequestVO.getCode());
            updateCourierPo.setGmtModified(new Date());
            this.courierPoMapper.updateByPrimaryKeySelective(updateCourierPo);
        }
        catch (Exception e) {
            log.warn("\u66f4\u65b0\u5feb\u9012\u516c\u53f8\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallAdminException(e.getMessage());
        }
    }
}

