/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.CommonUtil;
import com.wmeimob.fastboot.bizvane.HttpHelper;
import com.wmeimob.fastboot.bizvane.entity.UserCommissionAccountLogs;
import com.wmeimob.fastboot.bizvane.entity.UserCommissionAccounts;
import com.wmeimob.fastboot.bizvane.entity.WechatMchNew;
import com.wmeimob.fastboot.bizvane.mapper.UserCommissionAccountLogsMapper;
import com.wmeimob.fastboot.bizvane.mapper.WechatMchNewMapper;
import com.wmeimob.fastboot.bizvane.service.UserCommissionAccountLogsService;
import com.wmeimob.fastboot.bizvane.service.UserCommissionService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import me.hao0.wechat.model.base.WechatMch;
import me.hao0.wechat.model.base.WechatMp;
import org.json.JSONException;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
public class UserCommissionAccountLogsServiceImpl
implements UserCommissionAccountLogsService {
    private static final Logger log = LoggerFactory.getLogger(UserCommissionAccountLogsServiceImpl.class);
    @Autowired
    private UserCommissionAccountLogsMapper logsMapper;
    @Autowired
    private UserCommissionService userCommissionService;
    @Resource
    private WechatMchNewMapper wechatMchNewMapper;
    @Autowired
    private UserCommissionAccountLogsMapper userCommissionAccountLogsMapper;
    private static final String TRANSFERS = "https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers";

    public List<UserCommissionAccountLogs> findByCondition(UserCommissionAccountLogs userCommissionAccountLogs) {
        log.info("\u6240\u9700\u8981merchantId==:{}", (Object)JSONObject.toJSONString((Object)userCommissionAccountLogs.getMerchantId()));
        return this.logsMapper.findList(userCommissionAccountLogs);
    }

    public List<UserCommissionAccountLogs> withdrawalList(UserCommissionAccountLogs userCommissionAccountLogs) {
        return this.logsMapper.withdrawalList(userCommissionAccountLogs);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public int update(UserCommissionAccountLogs updateObject) {
        if (updateObject.getAuditStatus() == 2) {
            UserCommissionAccounts commissionAccounts = (UserCommissionAccounts)this.userCommissionService.findById(updateObject.getUserAccountId());
            commissionAccounts.setAmount(commissionAccounts.getAmount().add(updateObject.getChangeAmount()));
            this.userCommissionService.update((Serializable)commissionAccounts);
        } else {
            UserCommissionAccountLogs logs = (UserCommissionAccountLogs)this.logsMapper.selectByPrimaryKey((Object)updateObject.getId());
            UserCommissionAccounts commissionAccounts = (UserCommissionAccounts)this.userCommissionService.findById(logs.getUserAccountId());
            int n = this.toWithdraw(updateObject.getMerchantId(), commissionAccounts.getBindOpenId(), logs.getChangeAmount(), updateObject.getIp(), logs.getWithdrawNo());
        }
        return this.logsMapper.updateByPrimaryKeySelective((Object)updateObject);
    }

    public int toWithdraw(Integer merchantId, String openid, BigDecimal amount, String ip, String orderNo) {
        Example example = new Example(WechatMchNew.class);
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId);
        WechatMchNew mchNew = (WechatMchNew)this.wechatMchNewMapper.selectOneByExample((Object)example);
        if (mchNew == null) {
            throw new CustomException("\u54c1\u724cID:" + merchantId + ",\u672a\u5b8c\u6210\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e");
        }
        WechatMch wechatMch = new WechatMch();
        wechatMch.setMchNo(mchNew.getMchNo());
        wechatMch.setMchKey(mchNew.getMchKey());
        wechatMch.setP12(mchNew.getP12());
        WechatMp wechatMp = new WechatMp();
        wechatMp.setAppid(mchNew.getAppId());
        log.info("\u5fae\u4fe1\u63a5\u53e3\u6570\u636ewechatMch\uff1a{}", (Object)JSON.toJSONString((Object)wechatMch));
        log.info("\u5fae\u4fe1\u63a5\u53e3\u6570\u636ewechatMp\uff1a{}", (Object)JSON.toJSONString((Object)wechatMp));
        String money = String.valueOf(amount.multiply(new BigDecimal(100)).intValue());
        Map redpack = HttpHelper.prepareTransfer((WechatMch)wechatMch, (WechatMp)wechatMp, (String)openid, (String)money, (String)ip, (String)orderNo);
        System.out.println("=============\u63d0\u73b0\u8bf7\u6c42\u53c2\u6570===============" + redpack);
        ByteArrayInputStream input = new ByteArrayInputStream(wechatMch.getP12());
        String xmlStr = CommonUtil.map2xml((Map)redpack);
        System.out.println("=============\u63d0\u73b0\u8bf7\u6c42\u53c2\u6570xmlStr===============" + xmlStr);
        String xml = HttpHelper.payPost((WechatMch)wechatMch, (String)TRANSFERS, (String)CommonUtil.map2xml((Map)redpack), (InputStream)input);
        log.info("=============\u63d0\u73b0\u7ed3\u679c===============:{}", (Object)xml);
        if (StringUtils.isEmpty((Object)xml)) {
            throw new CustomException("\u63d0\u73b0\u5931\u8d25");
        }
        Map result = CommonUtil.xmlString2Map((String)xml);
        org.json.JSONObject jsonObject = null;
        try {
            jsonObject = XML.toJSONObject((String)xml);
            org.json.JSONObject object = jsonObject.getJSONObject("xml");
            System.out.println("=============\u63d0\u73b0\u7ed3\u679cjsonObject===============" + jsonObject);
            if ("SUCCESS".equals(object.getString("return_code")) && "SUCCESS".equals(object.get("result_code"))) {
                return 1;
            }
            log.info("=======================\u8f6c\u8d26\u7ed3\u679c\u5bf9\u8c61=========================\uff1a{}", (Object)object);
            throw new CustomException("\u8f6c\u8d26\u5931\u8d25:" + object.getString("err_code_des"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            throw new CustomException("\u8f6c\u8d26\u5931\u8d25");
        }
    }
}

